# Copyright (C) 2018 NTT DATA
# All Rights Reserved.
#    Licensed under the Apache License, Version 2.0 (the "License"); you may
#    not use this file except in compliance with the License. You may obtain
#    a copy of the License at
#
#         http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
#    WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
#    License for the specific language governing permissions and limitations
#    under the License.

"""
Schema for V3 volume manage API.

"""
import copy


from cinder.api.validation import parameter_types

volume_manage_create = {
    'type': 'object',
    'properties': {
        'volume': {
            'type': 'object',
            'properties': {
                "description": parameter_types.description,
                "availability_zone": parameter_types.
                    name_allow_zero_min_length,
                "bootable": parameter_types.boolean,
                "volume_type": parameter_types.name_allow_zero_min_length,
                "name": parameter_types.name_allow_zero_min_length,
                "host": parameter_types.cinder_host,
                "ref": {'type': ['object', 'string']},
                "metadata": parameter_types.metadata_allows_null,
            },
            'required': ['ref'],
            'additionalProperties': False,
        },
    },
    'required': ['volume'],
    'additionalProperties': False,
}

volume_manage_create_v316 = copy.deepcopy(volume_manage_create)
volume_manage_create_v316['properties']['volume']['properties'][
    'cluster'] = {'type': ['string', 'null'],
                  'minLength': 0, 'maxLength': 255}
