/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.util;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.Locator;
import org.apache.jena.util.TypedStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocatorZip
implements Locator {
    static Logger log = LoggerFactory.getLogger(LocatorZip.class);
    String zipFileName = null;
    ZipFile zipFile = null;

    public LocatorZip(String zfn) {
        try {
            this.zipFileName = zfn;
            this.zipFile = new ZipFile(this.zipFileName);
        }
        catch (IOException ex) {
            throw new JenaException("Problems accessing " + this.zipFileName, ex);
        }
    }

    @Override
    public TypedStream open(String filenameOrURI) {
        ZipEntry entry = this.zipFile.getEntry(filenameOrURI);
        if (entry == null) {
            if (FileManager.logAllLookups && log.isDebugEnabled()) {
                log.debug("Not found: " + this.zipFileName + " : " + filenameOrURI);
            }
            return null;
        }
        try {
            InputStream in = this.zipFile.getInputStream(entry);
            if (in == null) {
                if (FileManager.logAllLookups && log.isTraceEnabled()) {
                    log.trace("Not found: " + filenameOrURI);
                }
                return null;
            }
            if (FileManager.logAllLookups && log.isTraceEnabled()) {
                log.trace("Found: " + filenameOrURI);
            }
            return new TypedStream(in);
        }
        catch (IOException ex) {
            log.warn("IO Exception opening zip entry: " + filenameOrURI);
            return null;
        }
    }

    public String getZipFileName() {
        return this.zipFileName;
    }

    @Override
    public String getName() {
        return "LocatorZip(" + this.zipFileName + ")";
    }
}

