﻿// <auto-generated />

#nullable enable

using System;
using System.Collections.Generic;
using System.Diagnostics.CodeAnalysis;
using Microsoft.CodeAnalysis.Syntax.InternalSyntax;
using Roslyn.Utilities;
using CoreSyntax = Microsoft.CodeAnalysis.Syntax.InternalSyntax;

namespace Microsoft.CodeAnalysis.CSharp.Syntax.InternalSyntax;

/// <summary>Provides the base class from which the classes that represent name syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class NameSyntax : TypeSyntax
{
    internal NameSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal NameSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Provides the base class from which the classes that represent simple name syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class SimpleNameSyntax : NameSyntax
{
    internal SimpleNameSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal SimpleNameSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>SyntaxToken representing the identifier of the simple name.</summary>
    public abstract SyntaxToken Identifier { get; }
}

/// <summary>Class which represents the syntax node for identifier name.</summary>
internal sealed partial class IdentifierNameSyntax : SimpleNameSyntax
{
    internal readonly SyntaxToken identifier;

    internal IdentifierNameSyntax(SyntaxKind kind, SyntaxToken identifier, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal IdentifierNameSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal IdentifierNameSyntax(SyntaxKind kind, SyntaxToken identifier)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    /// <summary>SyntaxToken representing the keyword for the kind of the identifier name.</summary>
    public override SyntaxToken Identifier => this.identifier;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.identifier : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.IdentifierNameSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIdentifierName(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIdentifierName(this);

    public IdentifierNameSyntax Update(SyntaxToken identifier)
    {
        if (identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.IdentifierName(identifier);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new IdentifierNameSyntax(this.Kind, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new IdentifierNameSyntax(this.Kind, this.identifier, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for qualified name.</summary>
internal sealed partial class QualifiedNameSyntax : NameSyntax
{
    internal readonly NameSyntax left;
    internal readonly SyntaxToken dotToken;
    internal readonly SimpleNameSyntax right;

    internal QualifiedNameSyntax(SyntaxKind kind, NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal QualifiedNameSyntax(SyntaxKind kind, NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal QualifiedNameSyntax(SyntaxKind kind, NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    /// <summary>NameSyntax node representing the name on the left side of the dot token of the qualified name.</summary>
    public NameSyntax Left => this.left;
    /// <summary>SyntaxToken representing the dot.</summary>
    public SyntaxToken DotToken => this.dotToken;
    /// <summary>SimpleNameSyntax node representing the name on the right side of the dot token of the qualified name.</summary>
    public SimpleNameSyntax Right => this.right;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.left,
            1 => this.dotToken,
            2 => this.right,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.QualifiedNameSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQualifiedName(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQualifiedName(this);

    public QualifiedNameSyntax Update(NameSyntax left, SyntaxToken dotToken, SimpleNameSyntax right)
    {
        if (left != this.Left || dotToken != this.DotToken || right != this.Right)
        {
            var newNode = SyntaxFactory.QualifiedName(left, dotToken, right);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new QualifiedNameSyntax(this.Kind, this.left, this.dotToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new QualifiedNameSyntax(this.Kind, this.left, this.dotToken, this.right, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for generic name.</summary>
internal sealed partial class GenericNameSyntax : SimpleNameSyntax
{
    internal readonly SyntaxToken identifier;
    internal readonly TypeArgumentListSyntax typeArgumentList;

    internal GenericNameSyntax(SyntaxKind kind, SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(typeArgumentList);
        this.typeArgumentList = typeArgumentList;
    }

    internal GenericNameSyntax(SyntaxKind kind, SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(typeArgumentList);
        this.typeArgumentList = typeArgumentList;
    }

    internal GenericNameSyntax(SyntaxKind kind, SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(typeArgumentList);
        this.typeArgumentList = typeArgumentList;
    }

    /// <summary>SyntaxToken representing the name of the identifier of the generic name.</summary>
    public override SyntaxToken Identifier => this.identifier;
    /// <summary>TypeArgumentListSyntax node representing the list of type arguments of the generic name.</summary>
    public TypeArgumentListSyntax TypeArgumentList => this.typeArgumentList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.identifier,
            1 => this.typeArgumentList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.GenericNameSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGenericName(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGenericName(this);

    public GenericNameSyntax Update(SyntaxToken identifier, TypeArgumentListSyntax typeArgumentList)
    {
        if (identifier != this.Identifier || typeArgumentList != this.TypeArgumentList)
        {
            var newNode = SyntaxFactory.GenericName(identifier, typeArgumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new GenericNameSyntax(this.Kind, this.identifier, this.typeArgumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new GenericNameSyntax(this.Kind, this.identifier, this.typeArgumentList, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for type argument list.</summary>
internal sealed partial class TypeArgumentListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken lessThanToken;
    internal readonly GreenNode? arguments;
    internal readonly SyntaxToken greaterThanToken;

    internal TypeArgumentListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? arguments, SyntaxToken greaterThanToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    internal TypeArgumentListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? arguments, SyntaxToken greaterThanToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    internal TypeArgumentListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? arguments, SyntaxToken greaterThanToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    /// <summary>SyntaxToken representing less than.</summary>
    public SyntaxToken LessThanToken => this.lessThanToken;
    /// <summary>SeparatedSyntaxList of TypeSyntax node representing the type arguments.</summary>
    public CoreSyntax.SeparatedSyntaxList<TypeSyntax> Arguments => new CoreSyntax.SeparatedSyntaxList<TypeSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing greater than.</summary>
    public SyntaxToken GreaterThanToken => this.greaterThanToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.lessThanToken,
            1 => this.arguments,
            2 => this.greaterThanToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeArgumentListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeArgumentList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeArgumentList(this);

    public TypeArgumentListSyntax Update(SyntaxToken lessThanToken, CoreSyntax.SeparatedSyntaxList<TypeSyntax> arguments, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || arguments != this.Arguments || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.TypeArgumentList(lessThanToken, arguments, greaterThanToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeArgumentListSyntax(this.Kind, this.lessThanToken, this.arguments, this.greaterThanToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeArgumentListSyntax(this.Kind, this.lessThanToken, this.arguments, this.greaterThanToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for alias qualified name.</summary>
internal sealed partial class AliasQualifiedNameSyntax : NameSyntax
{
    internal readonly IdentifierNameSyntax alias;
    internal readonly SyntaxToken colonColonToken;
    internal readonly SimpleNameSyntax name;

    internal AliasQualifiedNameSyntax(SyntaxKind kind, IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(alias);
        this.alias = alias;
        this.AdjustFlagsAndWidth(colonColonToken);
        this.colonColonToken = colonColonToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal AliasQualifiedNameSyntax(SyntaxKind kind, IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(alias);
        this.alias = alias;
        this.AdjustFlagsAndWidth(colonColonToken);
        this.colonColonToken = colonColonToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal AliasQualifiedNameSyntax(SyntaxKind kind, IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(alias);
        this.alias = alias;
        this.AdjustFlagsAndWidth(colonColonToken);
        this.colonColonToken = colonColonToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>IdentifierNameSyntax node representing the name of the alias</summary>
    public IdentifierNameSyntax Alias => this.alias;
    /// <summary>SyntaxToken representing colon colon.</summary>
    public SyntaxToken ColonColonToken => this.colonColonToken;
    /// <summary>SimpleNameSyntax node representing the name that is being alias qualified.</summary>
    public SimpleNameSyntax Name => this.name;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.alias,
            1 => this.colonColonToken,
            2 => this.name,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AliasQualifiedNameSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAliasQualifiedName(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAliasQualifiedName(this);

    public AliasQualifiedNameSyntax Update(IdentifierNameSyntax alias, SyntaxToken colonColonToken, SimpleNameSyntax name)
    {
        if (alias != this.Alias || colonColonToken != this.ColonColonToken || name != this.Name)
        {
            var newNode = SyntaxFactory.AliasQualifiedName(alias, colonColonToken, name);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AliasQualifiedNameSyntax(this.Kind, this.alias, this.colonColonToken, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AliasQualifiedNameSyntax(this.Kind, this.alias, this.colonColonToken, this.name, GetDiagnostics(), annotations);
}

/// <summary>Provides the base class from which the classes that represent type syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class TypeSyntax : ExpressionSyntax
{
    internal TypeSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal TypeSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Class which represents the syntax node for predefined types.</summary>
internal sealed partial class PredefinedTypeSyntax : TypeSyntax
{
    internal readonly SyntaxToken keyword;

    internal PredefinedTypeSyntax(SyntaxKind kind, SyntaxToken keyword, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
    }

    internal PredefinedTypeSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
    }

    internal PredefinedTypeSyntax(SyntaxKind kind, SyntaxToken keyword)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
    }

    /// <summary>SyntaxToken which represents the keyword corresponding to the predefined type.</summary>
    public SyntaxToken Keyword => this.keyword;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.keyword : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PredefinedTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPredefinedType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPredefinedType(this);

    public PredefinedTypeSyntax Update(SyntaxToken keyword)
    {
        if (keyword != this.Keyword)
        {
            var newNode = SyntaxFactory.PredefinedType(keyword);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PredefinedTypeSyntax(this.Kind, this.keyword, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PredefinedTypeSyntax(this.Kind, this.keyword, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for the array type.</summary>
internal sealed partial class ArrayTypeSyntax : TypeSyntax
{
    internal readonly TypeSyntax elementType;
    internal readonly GreenNode? rankSpecifiers;

    internal ArrayTypeSyntax(SyntaxKind kind, TypeSyntax elementType, GreenNode? rankSpecifiers, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        if (rankSpecifiers != null)
        {
            this.AdjustFlagsAndWidth(rankSpecifiers);
            this.rankSpecifiers = rankSpecifiers;
        }
    }

    internal ArrayTypeSyntax(SyntaxKind kind, TypeSyntax elementType, GreenNode? rankSpecifiers, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        if (rankSpecifiers != null)
        {
            this.AdjustFlagsAndWidth(rankSpecifiers);
            this.rankSpecifiers = rankSpecifiers;
        }
    }

    internal ArrayTypeSyntax(SyntaxKind kind, TypeSyntax elementType, GreenNode? rankSpecifiers)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        if (rankSpecifiers != null)
        {
            this.AdjustFlagsAndWidth(rankSpecifiers);
            this.rankSpecifiers = rankSpecifiers;
        }
    }

    /// <summary>TypeSyntax node representing the type of the element of the array.</summary>
    public TypeSyntax ElementType => this.elementType;
    /// <summary>SyntaxList of ArrayRankSpecifierSyntax nodes representing the list of rank specifiers for the array.</summary>
    public CoreSyntax.SyntaxList<ArrayRankSpecifierSyntax> RankSpecifiers => new CoreSyntax.SyntaxList<ArrayRankSpecifierSyntax>(this.rankSpecifiers);

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.elementType,
            1 => this.rankSpecifiers,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ArrayTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrayType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrayType(this);

    public ArrayTypeSyntax Update(TypeSyntax elementType, CoreSyntax.SyntaxList<ArrayRankSpecifierSyntax> rankSpecifiers)
    {
        if (elementType != this.ElementType || rankSpecifiers != this.RankSpecifiers)
        {
            var newNode = SyntaxFactory.ArrayType(elementType, rankSpecifiers);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ArrayTypeSyntax(this.Kind, this.elementType, this.rankSpecifiers, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ArrayTypeSyntax(this.Kind, this.elementType, this.rankSpecifiers, GetDiagnostics(), annotations);
}

internal sealed partial class ArrayRankSpecifierSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? sizes;
    internal readonly SyntaxToken closeBracketToken;

    internal ArrayRankSpecifierSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? sizes, SyntaxToken closeBracketToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (sizes != null)
        {
            this.AdjustFlagsAndWidth(sizes);
            this.sizes = sizes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal ArrayRankSpecifierSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? sizes, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (sizes != null)
        {
            this.AdjustFlagsAndWidth(sizes);
            this.sizes = sizes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal ArrayRankSpecifierSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? sizes, SyntaxToken closeBracketToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (sizes != null)
        {
            this.AdjustFlagsAndWidth(sizes);
            this.sizes = sizes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    public SyntaxToken OpenBracketToken => this.openBracketToken;
    public CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> Sizes => new CoreSyntax.SeparatedSyntaxList<ExpressionSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.sizes));
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.sizes,
            2 => this.closeBracketToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ArrayRankSpecifierSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrayRankSpecifier(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrayRankSpecifier(this);

    public ArrayRankSpecifierSyntax Update(SyntaxToken openBracketToken, CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> sizes, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || sizes != this.Sizes || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.ArrayRankSpecifier(openBracketToken, sizes, closeBracketToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ArrayRankSpecifierSyntax(this.Kind, this.openBracketToken, this.sizes, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ArrayRankSpecifierSyntax(this.Kind, this.openBracketToken, this.sizes, this.closeBracketToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for pointer type.</summary>
internal sealed partial class PointerTypeSyntax : TypeSyntax
{
    internal readonly TypeSyntax elementType;
    internal readonly SyntaxToken asteriskToken;

    internal PointerTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken asteriskToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
    }

    internal PointerTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken asteriskToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
    }

    internal PointerTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken asteriskToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
    }

    /// <summary>TypeSyntax node that represents the element type of the pointer.</summary>
    public TypeSyntax ElementType => this.elementType;
    /// <summary>SyntaxToken representing the asterisk.</summary>
    public SyntaxToken AsteriskToken => this.asteriskToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.elementType,
            1 => this.asteriskToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PointerTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPointerType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPointerType(this);

    public PointerTypeSyntax Update(TypeSyntax elementType, SyntaxToken asteriskToken)
    {
        if (elementType != this.ElementType || asteriskToken != this.AsteriskToken)
        {
            var newNode = SyntaxFactory.PointerType(elementType, asteriskToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PointerTypeSyntax(this.Kind, this.elementType, this.asteriskToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PointerTypeSyntax(this.Kind, this.elementType, this.asteriskToken, GetDiagnostics(), annotations);
}

internal sealed partial class FunctionPointerTypeSyntax : TypeSyntax
{
    internal readonly SyntaxToken delegateKeyword;
    internal readonly SyntaxToken asteriskToken;
    internal readonly FunctionPointerCallingConventionSyntax? callingConvention;
    internal readonly FunctionPointerParameterListSyntax parameterList;

    internal FunctionPointerTypeSyntax(SyntaxKind kind, SyntaxToken delegateKeyword, SyntaxToken asteriskToken, FunctionPointerCallingConventionSyntax? callingConvention, FunctionPointerParameterListSyntax parameterList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
        if (callingConvention != null)
        {
            this.AdjustFlagsAndWidth(callingConvention);
            this.callingConvention = callingConvention;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
    }

    internal FunctionPointerTypeSyntax(SyntaxKind kind, SyntaxToken delegateKeyword, SyntaxToken asteriskToken, FunctionPointerCallingConventionSyntax? callingConvention, FunctionPointerParameterListSyntax parameterList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
        if (callingConvention != null)
        {
            this.AdjustFlagsAndWidth(callingConvention);
            this.callingConvention = callingConvention;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
    }

    internal FunctionPointerTypeSyntax(SyntaxKind kind, SyntaxToken delegateKeyword, SyntaxToken asteriskToken, FunctionPointerCallingConventionSyntax? callingConvention, FunctionPointerParameterListSyntax parameterList)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(asteriskToken);
        this.asteriskToken = asteriskToken;
        if (callingConvention != null)
        {
            this.AdjustFlagsAndWidth(callingConvention);
            this.callingConvention = callingConvention;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
    }

    /// <summary>SyntaxToken representing the delegate keyword.</summary>
    public SyntaxToken DelegateKeyword => this.delegateKeyword;
    /// <summary>SyntaxToken representing the asterisk.</summary>
    public SyntaxToken AsteriskToken => this.asteriskToken;
    /// <summary>Node representing the optional calling convention.</summary>
    public FunctionPointerCallingConventionSyntax? CallingConvention => this.callingConvention;
    /// <summary>List of the parameter types and return type of the function pointer.</summary>
    public FunctionPointerParameterListSyntax ParameterList => this.parameterList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.delegateKeyword,
            1 => this.asteriskToken,
            2 => this.callingConvention,
            3 => this.parameterList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FunctionPointerTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFunctionPointerType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFunctionPointerType(this);

    public FunctionPointerTypeSyntax Update(SyntaxToken delegateKeyword, SyntaxToken asteriskToken, FunctionPointerCallingConventionSyntax callingConvention, FunctionPointerParameterListSyntax parameterList)
    {
        if (delegateKeyword != this.DelegateKeyword || asteriskToken != this.AsteriskToken || callingConvention != this.CallingConvention || parameterList != this.ParameterList)
        {
            var newNode = SyntaxFactory.FunctionPointerType(delegateKeyword, asteriskToken, callingConvention, parameterList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FunctionPointerTypeSyntax(this.Kind, this.delegateKeyword, this.asteriskToken, this.callingConvention, this.parameterList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FunctionPointerTypeSyntax(this.Kind, this.delegateKeyword, this.asteriskToken, this.callingConvention, this.parameterList, GetDiagnostics(), annotations);
}

/// <summary>Function pointer parameter list syntax.</summary>
internal sealed partial class FunctionPointerParameterListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken lessThanToken;
    internal readonly GreenNode? parameters;
    internal readonly SyntaxToken greaterThanToken;

    internal FunctionPointerParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? parameters, SyntaxToken greaterThanToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    internal FunctionPointerParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? parameters, SyntaxToken greaterThanToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    internal FunctionPointerParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? parameters, SyntaxToken greaterThanToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    /// <summary>SyntaxToken representing the less than token.</summary>
    public SyntaxToken LessThanToken => this.lessThanToken;
    /// <summary>SeparatedSyntaxList of ParameterSyntaxes representing the list of parameters and return type.</summary>
    public CoreSyntax.SeparatedSyntaxList<FunctionPointerParameterSyntax> Parameters => new CoreSyntax.SeparatedSyntaxList<FunctionPointerParameterSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.parameters));
    /// <summary>SyntaxToken representing the greater than token.</summary>
    public SyntaxToken GreaterThanToken => this.greaterThanToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.lessThanToken,
            1 => this.parameters,
            2 => this.greaterThanToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FunctionPointerParameterListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFunctionPointerParameterList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFunctionPointerParameterList(this);

    public FunctionPointerParameterListSyntax Update(SyntaxToken lessThanToken, CoreSyntax.SeparatedSyntaxList<FunctionPointerParameterSyntax> parameters, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || parameters != this.Parameters || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.FunctionPointerParameterList(lessThanToken, parameters, greaterThanToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FunctionPointerParameterListSyntax(this.Kind, this.lessThanToken, this.parameters, this.greaterThanToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FunctionPointerParameterListSyntax(this.Kind, this.lessThanToken, this.parameters, this.greaterThanToken, GetDiagnostics(), annotations);
}

/// <summary>Function pointer calling convention syntax.</summary>
internal sealed partial class FunctionPointerCallingConventionSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken managedOrUnmanagedKeyword;
    internal readonly FunctionPointerUnmanagedCallingConventionListSyntax? unmanagedCallingConventionList;

    internal FunctionPointerCallingConventionSyntax(SyntaxKind kind, SyntaxToken managedOrUnmanagedKeyword, FunctionPointerUnmanagedCallingConventionListSyntax? unmanagedCallingConventionList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(managedOrUnmanagedKeyword);
        this.managedOrUnmanagedKeyword = managedOrUnmanagedKeyword;
        if (unmanagedCallingConventionList != null)
        {
            this.AdjustFlagsAndWidth(unmanagedCallingConventionList);
            this.unmanagedCallingConventionList = unmanagedCallingConventionList;
        }
    }

    internal FunctionPointerCallingConventionSyntax(SyntaxKind kind, SyntaxToken managedOrUnmanagedKeyword, FunctionPointerUnmanagedCallingConventionListSyntax? unmanagedCallingConventionList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(managedOrUnmanagedKeyword);
        this.managedOrUnmanagedKeyword = managedOrUnmanagedKeyword;
        if (unmanagedCallingConventionList != null)
        {
            this.AdjustFlagsAndWidth(unmanagedCallingConventionList);
            this.unmanagedCallingConventionList = unmanagedCallingConventionList;
        }
    }

    internal FunctionPointerCallingConventionSyntax(SyntaxKind kind, SyntaxToken managedOrUnmanagedKeyword, FunctionPointerUnmanagedCallingConventionListSyntax? unmanagedCallingConventionList)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(managedOrUnmanagedKeyword);
        this.managedOrUnmanagedKeyword = managedOrUnmanagedKeyword;
        if (unmanagedCallingConventionList != null)
        {
            this.AdjustFlagsAndWidth(unmanagedCallingConventionList);
            this.unmanagedCallingConventionList = unmanagedCallingConventionList;
        }
    }

    /// <summary>SyntaxToken representing whether the calling convention is managed or unmanaged.</summary>
    public SyntaxToken ManagedOrUnmanagedKeyword => this.managedOrUnmanagedKeyword;
    /// <summary>Optional list of identifiers that will contribute to an unmanaged calling convention.</summary>
    public FunctionPointerUnmanagedCallingConventionListSyntax? UnmanagedCallingConventionList => this.unmanagedCallingConventionList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.managedOrUnmanagedKeyword,
            1 => this.unmanagedCallingConventionList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FunctionPointerCallingConventionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFunctionPointerCallingConvention(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFunctionPointerCallingConvention(this);

    public FunctionPointerCallingConventionSyntax Update(SyntaxToken managedOrUnmanagedKeyword, FunctionPointerUnmanagedCallingConventionListSyntax unmanagedCallingConventionList)
    {
        if (managedOrUnmanagedKeyword != this.ManagedOrUnmanagedKeyword || unmanagedCallingConventionList != this.UnmanagedCallingConventionList)
        {
            var newNode = SyntaxFactory.FunctionPointerCallingConvention(managedOrUnmanagedKeyword, unmanagedCallingConventionList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FunctionPointerCallingConventionSyntax(this.Kind, this.managedOrUnmanagedKeyword, this.unmanagedCallingConventionList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FunctionPointerCallingConventionSyntax(this.Kind, this.managedOrUnmanagedKeyword, this.unmanagedCallingConventionList, GetDiagnostics(), annotations);
}

/// <summary>Function pointer calling convention syntax.</summary>
internal sealed partial class FunctionPointerUnmanagedCallingConventionListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? callingConventions;
    internal readonly SyntaxToken closeBracketToken;

    internal FunctionPointerUnmanagedCallingConventionListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? callingConventions, SyntaxToken closeBracketToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (callingConventions != null)
        {
            this.AdjustFlagsAndWidth(callingConventions);
            this.callingConventions = callingConventions;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal FunctionPointerUnmanagedCallingConventionListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? callingConventions, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (callingConventions != null)
        {
            this.AdjustFlagsAndWidth(callingConventions);
            this.callingConventions = callingConventions;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal FunctionPointerUnmanagedCallingConventionListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? callingConventions, SyntaxToken closeBracketToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (callingConventions != null)
        {
            this.AdjustFlagsAndWidth(callingConventions);
            this.callingConventions = callingConventions;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    /// <summary>SyntaxToken representing open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SeparatedSyntaxList of calling convention identifiers.</summary>
    public CoreSyntax.SeparatedSyntaxList<FunctionPointerUnmanagedCallingConventionSyntax> CallingConventions => new CoreSyntax.SeparatedSyntaxList<FunctionPointerUnmanagedCallingConventionSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.callingConventions));
    /// <summary>SyntaxToken representing close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.callingConventions,
            2 => this.closeBracketToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FunctionPointerUnmanagedCallingConventionListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFunctionPointerUnmanagedCallingConventionList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFunctionPointerUnmanagedCallingConventionList(this);

    public FunctionPointerUnmanagedCallingConventionListSyntax Update(SyntaxToken openBracketToken, CoreSyntax.SeparatedSyntaxList<FunctionPointerUnmanagedCallingConventionSyntax> callingConventions, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || callingConventions != this.CallingConventions || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.FunctionPointerUnmanagedCallingConventionList(openBracketToken, callingConventions, closeBracketToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FunctionPointerUnmanagedCallingConventionListSyntax(this.Kind, this.openBracketToken, this.callingConventions, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FunctionPointerUnmanagedCallingConventionListSyntax(this.Kind, this.openBracketToken, this.callingConventions, this.closeBracketToken, GetDiagnostics(), annotations);
}

/// <summary>Individual function pointer unmanaged calling convention.</summary>
internal sealed partial class FunctionPointerUnmanagedCallingConventionSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken name;

    internal FunctionPointerUnmanagedCallingConventionSyntax(SyntaxKind kind, SyntaxToken name, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal FunctionPointerUnmanagedCallingConventionSyntax(SyntaxKind kind, SyntaxToken name, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal FunctionPointerUnmanagedCallingConventionSyntax(SyntaxKind kind, SyntaxToken name)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>SyntaxToken representing the calling convention identifier.</summary>
    public SyntaxToken Name => this.name;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.name : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FunctionPointerUnmanagedCallingConventionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFunctionPointerUnmanagedCallingConvention(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFunctionPointerUnmanagedCallingConvention(this);

    public FunctionPointerUnmanagedCallingConventionSyntax Update(SyntaxToken name)
    {
        if (name != this.Name)
        {
            var newNode = SyntaxFactory.FunctionPointerUnmanagedCallingConvention(name);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FunctionPointerUnmanagedCallingConventionSyntax(this.Kind, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FunctionPointerUnmanagedCallingConventionSyntax(this.Kind, this.name, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for a nullable type.</summary>
internal sealed partial class NullableTypeSyntax : TypeSyntax
{
    internal readonly TypeSyntax elementType;
    internal readonly SyntaxToken questionToken;

    internal NullableTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken questionToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
    }

    internal NullableTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken questionToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
    }

    internal NullableTypeSyntax(SyntaxKind kind, TypeSyntax elementType, SyntaxToken questionToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elementType);
        this.elementType = elementType;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
    }

    /// <summary>TypeSyntax node representing the type of the element.</summary>
    public TypeSyntax ElementType => this.elementType;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken => this.questionToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.elementType,
            1 => this.questionToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.NullableTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNullableType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNullableType(this);

    public NullableTypeSyntax Update(TypeSyntax elementType, SyntaxToken questionToken)
    {
        if (elementType != this.ElementType || questionToken != this.QuestionToken)
        {
            var newNode = SyntaxFactory.NullableType(elementType, questionToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new NullableTypeSyntax(this.Kind, this.elementType, this.questionToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new NullableTypeSyntax(this.Kind, this.elementType, this.questionToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for tuple type.</summary>
internal sealed partial class TupleTypeSyntax : TypeSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? elements;
    internal readonly SyntaxToken closeParenToken;

    internal TupleTypeSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? elements, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal TupleTypeSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? elements, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal TupleTypeSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? elements, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    public CoreSyntax.SeparatedSyntaxList<TupleElementSyntax> Elements => new CoreSyntax.SeparatedSyntaxList<TupleElementSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.elements));
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.elements,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TupleTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTupleType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTupleType(this);

    public TupleTypeSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<TupleElementSyntax> elements, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || elements != this.Elements || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TupleType(openParenToken, elements, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TupleTypeSyntax(this.Kind, this.openParenToken, this.elements, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TupleTypeSyntax(this.Kind, this.openParenToken, this.elements, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Tuple type element.</summary>
internal sealed partial class TupleElementSyntax : CSharpSyntaxNode
{
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken? identifier;

    internal TupleElementSyntax(SyntaxKind kind, TypeSyntax type, SyntaxToken? identifier, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
    }

    internal TupleElementSyntax(SyntaxKind kind, TypeSyntax type, SyntaxToken? identifier, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
    }

    internal TupleElementSyntax(SyntaxKind kind, TypeSyntax type, SyntaxToken? identifier)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
    }

    /// <summary>Gets the type of the tuple element.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>Gets the name of the tuple element.</summary>
    public SyntaxToken? Identifier => this.identifier;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.type,
            1 => this.identifier,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TupleElementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTupleElement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTupleElement(this);

    public TupleElementSyntax Update(TypeSyntax type, SyntaxToken identifier)
    {
        if (type != this.Type || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.TupleElement(type, identifier);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TupleElementSyntax(this.Kind, this.type, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TupleElementSyntax(this.Kind, this.type, this.identifier, GetDiagnostics(), annotations);
}

/// <summary>Class which represents a placeholder in the type argument list of an unbound generic type.</summary>
internal sealed partial class OmittedTypeArgumentSyntax : TypeSyntax
{
    internal readonly SyntaxToken omittedTypeArgumentToken;

    internal OmittedTypeArgumentSyntax(SyntaxKind kind, SyntaxToken omittedTypeArgumentToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedTypeArgumentToken);
        this.omittedTypeArgumentToken = omittedTypeArgumentToken;
    }

    internal OmittedTypeArgumentSyntax(SyntaxKind kind, SyntaxToken omittedTypeArgumentToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedTypeArgumentToken);
        this.omittedTypeArgumentToken = omittedTypeArgumentToken;
    }

    internal OmittedTypeArgumentSyntax(SyntaxKind kind, SyntaxToken omittedTypeArgumentToken)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedTypeArgumentToken);
        this.omittedTypeArgumentToken = omittedTypeArgumentToken;
    }

    /// <summary>SyntaxToken representing the omitted type argument.</summary>
    public SyntaxToken OmittedTypeArgumentToken => this.omittedTypeArgumentToken;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.omittedTypeArgumentToken : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.OmittedTypeArgumentSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOmittedTypeArgument(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOmittedTypeArgument(this);

    public OmittedTypeArgumentSyntax Update(SyntaxToken omittedTypeArgumentToken)
    {
        if (omittedTypeArgumentToken != this.OmittedTypeArgumentToken)
        {
            var newNode = SyntaxFactory.OmittedTypeArgument(omittedTypeArgumentToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new OmittedTypeArgumentSyntax(this.Kind, this.omittedTypeArgumentToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new OmittedTypeArgumentSyntax(this.Kind, this.omittedTypeArgumentToken, GetDiagnostics(), annotations);
}

/// <summary>The ref modifier of a method's return value or a local.</summary>
internal sealed partial class RefTypeSyntax : TypeSyntax
{
    internal readonly SyntaxToken refKeyword;
    internal readonly SyntaxToken? readOnlyKeyword;
    internal readonly TypeSyntax type;

    internal RefTypeSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken? readOnlyKeyword, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        if (readOnlyKeyword != null)
        {
            this.AdjustFlagsAndWidth(readOnlyKeyword);
            this.readOnlyKeyword = readOnlyKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal RefTypeSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken? readOnlyKeyword, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        if (readOnlyKeyword != null)
        {
            this.AdjustFlagsAndWidth(readOnlyKeyword);
            this.readOnlyKeyword = readOnlyKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal RefTypeSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken? readOnlyKeyword, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        if (readOnlyKeyword != null)
        {
            this.AdjustFlagsAndWidth(readOnlyKeyword);
            this.readOnlyKeyword = readOnlyKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    public SyntaxToken RefKeyword => this.refKeyword;
    /// <summary>Gets the optional "readonly" keyword.</summary>
    public SyntaxToken? ReadOnlyKeyword => this.readOnlyKeyword;
    public TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.refKeyword,
            1 => this.readOnlyKeyword,
            2 => this.type,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RefTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefType(this);

    public RefTypeSyntax Update(SyntaxToken refKeyword, SyntaxToken readOnlyKeyword, TypeSyntax type)
    {
        if (refKeyword != this.RefKeyword || readOnlyKeyword != this.ReadOnlyKeyword || type != this.Type)
        {
            var newNode = SyntaxFactory.RefType(refKeyword, readOnlyKeyword, type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RefTypeSyntax(this.Kind, this.refKeyword, this.readOnlyKeyword, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RefTypeSyntax(this.Kind, this.refKeyword, this.readOnlyKeyword, this.type, GetDiagnostics(), annotations);
}

/// <summary>The 'scoped' modifier of a local.</summary>
internal sealed partial class ScopedTypeSyntax : TypeSyntax
{
    internal readonly SyntaxToken scopedKeyword;
    internal readonly TypeSyntax type;

    internal ScopedTypeSyntax(SyntaxKind kind, SyntaxToken scopedKeyword, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(scopedKeyword);
        this.scopedKeyword = scopedKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal ScopedTypeSyntax(SyntaxKind kind, SyntaxToken scopedKeyword, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(scopedKeyword);
        this.scopedKeyword = scopedKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal ScopedTypeSyntax(SyntaxKind kind, SyntaxToken scopedKeyword, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(scopedKeyword);
        this.scopedKeyword = scopedKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    public SyntaxToken ScopedKeyword => this.scopedKeyword;
    public TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.scopedKeyword,
            1 => this.type,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ScopedTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitScopedType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitScopedType(this);

    public ScopedTypeSyntax Update(SyntaxToken scopedKeyword, TypeSyntax type)
    {
        if (scopedKeyword != this.ScopedKeyword || type != this.Type)
        {
            var newNode = SyntaxFactory.ScopedType(scopedKeyword, type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ScopedTypeSyntax(this.Kind, this.scopedKeyword, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ScopedTypeSyntax(this.Kind, this.scopedKeyword, this.type, GetDiagnostics(), annotations);
}

internal abstract partial class ExpressionOrPatternSyntax : CSharpSyntaxNode
{
    internal ExpressionOrPatternSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal ExpressionOrPatternSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Provides the base class from which the classes that represent expression syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class ExpressionSyntax : ExpressionOrPatternSyntax
{
    internal ExpressionSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal ExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Class which represents the syntax node for parenthesized expression.</summary>
internal sealed partial class ParenthesizedExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal ParenthesizedExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParenthesizedExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParenthesizedExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>ExpressionSyntax node representing the expression enclosed within the parenthesis.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.expression,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ParenthesizedExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedExpression(this);

    public ParenthesizedExpressionSyntax Update(SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedExpression(openParenToken, expression, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ParenthesizedExpressionSyntax(this.Kind, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ParenthesizedExpressionSyntax(this.Kind, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for tuple expression.</summary>
internal sealed partial class TupleExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? arguments;
    internal readonly SyntaxToken closeParenToken;

    internal TupleExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal TupleExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal TupleExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments => new CoreSyntax.SeparatedSyntaxList<ArgumentSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.arguments,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TupleExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTupleExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTupleExpression(this);

    public TupleExpressionSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TupleExpression(openParenToken, arguments, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TupleExpressionSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TupleExpressionSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for prefix unary expression.</summary>
internal sealed partial class PrefixUnaryExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax operand;

    internal PrefixUnaryExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax operand, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
    }

    internal PrefixUnaryExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax operand, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
    }

    internal PrefixUnaryExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax operand)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
    }

    /// <summary>SyntaxToken representing the kind of the operator of the prefix unary expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax representing the operand of the prefix unary expression.</summary>
    public ExpressionSyntax Operand => this.operand;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operatorToken,
            1 => this.operand,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PrefixUnaryExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPrefixUnaryExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPrefixUnaryExpression(this);

    public PrefixUnaryExpressionSyntax Update(SyntaxToken operatorToken, ExpressionSyntax operand)
    {
        if (operatorToken != this.OperatorToken || operand != this.Operand)
        {
            var newNode = SyntaxFactory.PrefixUnaryExpression(this.Kind, operatorToken, operand);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PrefixUnaryExpressionSyntax(this.Kind, this.operatorToken, this.operand, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PrefixUnaryExpressionSyntax(this.Kind, this.operatorToken, this.operand, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for an "await" expression.</summary>
internal sealed partial class AwaitExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken awaitKeyword;
    internal readonly ExpressionSyntax expression;

    internal AwaitExpressionSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(awaitKeyword);
        this.awaitKeyword = awaitKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal AwaitExpressionSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(awaitKeyword);
        this.awaitKeyword = awaitKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal AwaitExpressionSyntax(SyntaxKind kind, SyntaxToken awaitKeyword, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(awaitKeyword);
        this.awaitKeyword = awaitKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>SyntaxToken representing the kind "await" keyword.</summary>
    public SyntaxToken AwaitKeyword => this.awaitKeyword;
    /// <summary>ExpressionSyntax representing the operand of the "await" operator.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.awaitKeyword,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AwaitExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAwaitExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAwaitExpression(this);

    public AwaitExpressionSyntax Update(SyntaxToken awaitKeyword, ExpressionSyntax expression)
    {
        if (awaitKeyword != this.AwaitKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AwaitExpression(awaitKeyword, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AwaitExpressionSyntax(this.Kind, this.awaitKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AwaitExpressionSyntax(this.Kind, this.awaitKeyword, this.expression, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for postfix unary expression.</summary>
internal sealed partial class PostfixUnaryExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax operand;
    internal readonly SyntaxToken operatorToken;

    internal PostfixUnaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax operand, SyntaxToken operatorToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
    }

    internal PostfixUnaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax operand, SyntaxToken operatorToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
    }

    internal PostfixUnaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax operand, SyntaxToken operatorToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operand);
        this.operand = operand;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
    }

    /// <summary>ExpressionSyntax representing the operand of the postfix unary expression.</summary>
    public ExpressionSyntax Operand => this.operand;
    /// <summary>SyntaxToken representing the kind of the operator of the postfix unary expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operand,
            1 => this.operatorToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PostfixUnaryExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPostfixUnaryExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPostfixUnaryExpression(this);

    public PostfixUnaryExpressionSyntax Update(ExpressionSyntax operand, SyntaxToken operatorToken)
    {
        if (operand != this.Operand || operatorToken != this.OperatorToken)
        {
            var newNode = SyntaxFactory.PostfixUnaryExpression(this.Kind, operand, operatorToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PostfixUnaryExpressionSyntax(this.Kind, this.operand, this.operatorToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PostfixUnaryExpressionSyntax(this.Kind, this.operand, this.operatorToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for member access expression.</summary>
internal sealed partial class MemberAccessExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken operatorToken;
    internal readonly SimpleNameSyntax name;

    internal MemberAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal MemberAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal MemberAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>ExpressionSyntax node representing the object that the member belongs to.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing the kind of the operator in the member access expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>SimpleNameSyntax node representing the member being accessed.</summary>
    public SimpleNameSyntax Name => this.name;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.operatorToken,
            2 => this.name,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.MemberAccessExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMemberAccessExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMemberAccessExpression(this);

    public MemberAccessExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken operatorToken, SimpleNameSyntax name)
    {
        if (expression != this.Expression || operatorToken != this.OperatorToken || name != this.Name)
        {
            var newNode = SyntaxFactory.MemberAccessExpression(this.Kind, expression, operatorToken, name);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new MemberAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new MemberAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.name, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for conditional access expression.</summary>
internal sealed partial class ConditionalAccessExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax whenNotNull;

    internal ConditionalAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(whenNotNull);
        this.whenNotNull = whenNotNull;
    }

    internal ConditionalAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(whenNotNull);
        this.whenNotNull = whenNotNull;
    }

    internal ConditionalAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(whenNotNull);
        this.whenNotNull = whenNotNull;
    }

    /// <summary>ExpressionSyntax node representing the object conditionally accessed.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the access expression to be executed when the object is not null.</summary>
    public ExpressionSyntax WhenNotNull => this.whenNotNull;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.operatorToken,
            2 => this.whenNotNull,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConditionalAccessExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConditionalAccessExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConditionalAccessExpression(this);

    public ConditionalAccessExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken operatorToken, ExpressionSyntax whenNotNull)
    {
        if (expression != this.Expression || operatorToken != this.OperatorToken || whenNotNull != this.WhenNotNull)
        {
            var newNode = SyntaxFactory.ConditionalAccessExpression(expression, operatorToken, whenNotNull);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConditionalAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.whenNotNull, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConditionalAccessExpressionSyntax(this.Kind, this.expression, this.operatorToken, this.whenNotNull, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for member binding expression.</summary>
internal sealed partial class MemberBindingExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken operatorToken;
    internal readonly SimpleNameSyntax name;

    internal MemberBindingExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, SimpleNameSyntax name, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal MemberBindingExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, SimpleNameSyntax name, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    internal MemberBindingExpressionSyntax(SyntaxKind kind, SyntaxToken operatorToken, SimpleNameSyntax name)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
    }

    /// <summary>SyntaxToken representing dot.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>SimpleNameSyntax node representing the member being bound to.</summary>
    public SimpleNameSyntax Name => this.name;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operatorToken,
            1 => this.name,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.MemberBindingExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMemberBindingExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMemberBindingExpression(this);

    public MemberBindingExpressionSyntax Update(SyntaxToken operatorToken, SimpleNameSyntax name)
    {
        if (operatorToken != this.OperatorToken || name != this.Name)
        {
            var newNode = SyntaxFactory.MemberBindingExpression(operatorToken, name);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new MemberBindingExpressionSyntax(this.Kind, this.operatorToken, this.name, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new MemberBindingExpressionSyntax(this.Kind, this.operatorToken, this.name, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for element binding expression.</summary>
internal sealed partial class ElementBindingExpressionSyntax : ExpressionSyntax
{
    internal readonly BracketedArgumentListSyntax argumentList;

    internal ElementBindingExpressionSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ElementBindingExpressionSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ElementBindingExpressionSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the element binding expression.</summary>
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.argumentList : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ElementBindingExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitElementBindingExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitElementBindingExpression(this);

    public ElementBindingExpressionSyntax Update(BracketedArgumentListSyntax argumentList)
    {
        if (argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ElementBindingExpression(argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ElementBindingExpressionSyntax(this.Kind, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ElementBindingExpressionSyntax(this.Kind, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for a range expression.</summary>
internal sealed partial class RangeExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax? leftOperand;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax? rightOperand;

    internal RangeExpressionSyntax(SyntaxKind kind, ExpressionSyntax? leftOperand, SyntaxToken operatorToken, ExpressionSyntax? rightOperand, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (leftOperand != null)
        {
            this.AdjustFlagsAndWidth(leftOperand);
            this.leftOperand = leftOperand;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (rightOperand != null)
        {
            this.AdjustFlagsAndWidth(rightOperand);
            this.rightOperand = rightOperand;
        }
    }

    internal RangeExpressionSyntax(SyntaxKind kind, ExpressionSyntax? leftOperand, SyntaxToken operatorToken, ExpressionSyntax? rightOperand, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (leftOperand != null)
        {
            this.AdjustFlagsAndWidth(leftOperand);
            this.leftOperand = leftOperand;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (rightOperand != null)
        {
            this.AdjustFlagsAndWidth(rightOperand);
            this.rightOperand = rightOperand;
        }
    }

    internal RangeExpressionSyntax(SyntaxKind kind, ExpressionSyntax? leftOperand, SyntaxToken operatorToken, ExpressionSyntax? rightOperand)
      : base(kind)
    {
        this.SlotCount = 3;
        if (leftOperand != null)
        {
            this.AdjustFlagsAndWidth(leftOperand);
            this.leftOperand = leftOperand;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (rightOperand != null)
        {
            this.AdjustFlagsAndWidth(rightOperand);
            this.rightOperand = rightOperand;
        }
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the range operator.</summary>
    public ExpressionSyntax? LeftOperand => this.leftOperand;
    /// <summary>SyntaxToken representing the operator of the range expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the expression on the right of the range operator.</summary>
    public ExpressionSyntax? RightOperand => this.rightOperand;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.leftOperand,
            1 => this.operatorToken,
            2 => this.rightOperand,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RangeExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRangeExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRangeExpression(this);

    public RangeExpressionSyntax Update(ExpressionSyntax leftOperand, SyntaxToken operatorToken, ExpressionSyntax rightOperand)
    {
        if (leftOperand != this.LeftOperand || operatorToken != this.OperatorToken || rightOperand != this.RightOperand)
        {
            var newNode = SyntaxFactory.RangeExpression(leftOperand, operatorToken, rightOperand);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RangeExpressionSyntax(this.Kind, this.leftOperand, this.operatorToken, this.rightOperand, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RangeExpressionSyntax(this.Kind, this.leftOperand, this.operatorToken, this.rightOperand, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for implicit element access expression.</summary>
internal sealed partial class ImplicitElementAccessSyntax : ExpressionSyntax
{
    internal readonly BracketedArgumentListSyntax argumentList;

    internal ImplicitElementAccessSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ImplicitElementAccessSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ImplicitElementAccessSyntax(SyntaxKind kind, BracketedArgumentListSyntax argumentList)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the implicit element access expression.</summary>
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.argumentList : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ImplicitElementAccessSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitElementAccess(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitElementAccess(this);

    public ImplicitElementAccessSyntax Update(BracketedArgumentListSyntax argumentList)
    {
        if (argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ImplicitElementAccess(argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ImplicitElementAccessSyntax(this.Kind, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ImplicitElementAccessSyntax(this.Kind, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Class which represents an expression that has a binary operator.</summary>
internal sealed partial class BinaryExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax left;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax right;

    internal BinaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal BinaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal BinaryExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the binary operator.</summary>
    public ExpressionSyntax Left => this.left;
    /// <summary>SyntaxToken representing the operator of the binary expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the expression on the right of the binary operator.</summary>
    public ExpressionSyntax Right => this.right;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.left,
            1 => this.operatorToken,
            2 => this.right,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BinaryExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBinaryExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBinaryExpression(this);

    public BinaryExpressionSyntax Update(ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.BinaryExpression(this.Kind, left, operatorToken, right);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BinaryExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BinaryExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, GetDiagnostics(), annotations);
}

/// <summary>Class which represents an expression that has an assignment operator.</summary>
internal sealed partial class AssignmentExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax left;
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax right;

    internal AssignmentExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal AssignmentExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal AssignmentExpressionSyntax(SyntaxKind kind, ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the assignment operator.</summary>
    public ExpressionSyntax Left => this.left;
    /// <summary>SyntaxToken representing the operator of the assignment expression.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    /// <summary>ExpressionSyntax node representing the expression on the right of the assignment operator.</summary>
    public ExpressionSyntax Right => this.right;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.left,
            1 => this.operatorToken,
            2 => this.right,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AssignmentExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAssignmentExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAssignmentExpression(this);

    public AssignmentExpressionSyntax Update(ExpressionSyntax left, SyntaxToken operatorToken, ExpressionSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.AssignmentExpression(this.Kind, left, operatorToken, right);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AssignmentExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AssignmentExpressionSyntax(this.Kind, this.left, this.operatorToken, this.right, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for conditional expression.</summary>
internal sealed partial class ConditionalExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken questionToken;
    internal readonly ExpressionSyntax whenTrue;
    internal readonly SyntaxToken colonToken;
    internal readonly ExpressionSyntax whenFalse;

    internal ConditionalExpressionSyntax(SyntaxKind kind, ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
        this.AdjustFlagsAndWidth(whenTrue);
        this.whenTrue = whenTrue;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(whenFalse);
        this.whenFalse = whenFalse;
    }

    internal ConditionalExpressionSyntax(SyntaxKind kind, ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
        this.AdjustFlagsAndWidth(whenTrue);
        this.whenTrue = whenTrue;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(whenFalse);
        this.whenFalse = whenFalse;
    }

    internal ConditionalExpressionSyntax(SyntaxKind kind, ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse)
      : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(questionToken);
        this.questionToken = questionToken;
        this.AdjustFlagsAndWidth(whenTrue);
        this.whenTrue = whenTrue;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(whenFalse);
        this.whenFalse = whenFalse;
    }

    /// <summary>ExpressionSyntax node representing the condition of the conditional expression.</summary>
    public ExpressionSyntax Condition => this.condition;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken QuestionToken => this.questionToken;
    /// <summary>ExpressionSyntax node representing the expression to be executed when the condition is true.</summary>
    public ExpressionSyntax WhenTrue => this.whenTrue;
    /// <summary>SyntaxToken representing the colon.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>ExpressionSyntax node representing the expression to be executed when the condition is false.</summary>
    public ExpressionSyntax WhenFalse => this.whenFalse;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.condition,
            1 => this.questionToken,
            2 => this.whenTrue,
            3 => this.colonToken,
            4 => this.whenFalse,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConditionalExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConditionalExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConditionalExpression(this);

    public ConditionalExpressionSyntax Update(ExpressionSyntax condition, SyntaxToken questionToken, ExpressionSyntax whenTrue, SyntaxToken colonToken, ExpressionSyntax whenFalse)
    {
        if (condition != this.Condition || questionToken != this.QuestionToken || whenTrue != this.WhenTrue || colonToken != this.ColonToken || whenFalse != this.WhenFalse)
        {
            var newNode = SyntaxFactory.ConditionalExpression(condition, questionToken, whenTrue, colonToken, whenFalse);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConditionalExpressionSyntax(this.Kind, this.condition, this.questionToken, this.whenTrue, this.colonToken, this.whenFalse, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConditionalExpressionSyntax(this.Kind, this.condition, this.questionToken, this.whenTrue, this.colonToken, this.whenFalse, GetDiagnostics(), annotations);
}

/// <summary>Provides the base class from which the classes that represent instance expression syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class InstanceExpressionSyntax : ExpressionSyntax
{
    internal InstanceExpressionSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal InstanceExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Class which represents the syntax node for a this expression.</summary>
internal sealed partial class ThisExpressionSyntax : InstanceExpressionSyntax
{
    internal readonly SyntaxToken token;

    internal ThisExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal ThisExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal ThisExpressionSyntax(SyntaxKind kind, SyntaxToken token)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the this keyword.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.token : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ThisExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitThisExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitThisExpression(this);

    public ThisExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.ThisExpression(token);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ThisExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ThisExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for a base expression.</summary>
internal sealed partial class BaseExpressionSyntax : InstanceExpressionSyntax
{
    internal readonly SyntaxToken token;

    internal BaseExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal BaseExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal BaseExpressionSyntax(SyntaxKind kind, SyntaxToken token)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the base keyword.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.token : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BaseExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBaseExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBaseExpression(this);

    public BaseExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.BaseExpression(token);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BaseExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BaseExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for a literal expression.</summary>
internal sealed partial class LiteralExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken token;

    internal LiteralExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal LiteralExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal LiteralExpressionSyntax(SyntaxKind kind, SyntaxToken token)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the keyword corresponding to the kind of the literal expression.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.token : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.LiteralExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLiteralExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLiteralExpression(this);

    public LiteralExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.LiteralExpression(this.Kind, token);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new LiteralExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new LiteralExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for a field expression.</summary>
internal sealed partial class FieldExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken token;

    internal FieldExpressionSyntax(SyntaxKind kind, SyntaxToken token, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal FieldExpressionSyntax(SyntaxKind kind, SyntaxToken token, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    internal FieldExpressionSyntax(SyntaxKind kind, SyntaxToken token)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(token);
        this.token = token;
    }

    /// <summary>SyntaxToken representing the field keyword.</summary>
    public SyntaxToken Token => this.token;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.token : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FieldExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFieldExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFieldExpression(this);

    public FieldExpressionSyntax Update(SyntaxToken token)
    {
        if (token != this.Token)
        {
            var newNode = SyntaxFactory.FieldExpression(token);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FieldExpressionSyntax(this.Kind, this.token, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FieldExpressionSyntax(this.Kind, this.token, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for MakeRef expression.</summary>
internal sealed partial class MakeRefExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal MakeRefExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal MakeRefExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal MakeRefExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the MakeRefKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.expression,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.MakeRefExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMakeRefExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMakeRefExpression(this);

    public MakeRefExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.MakeRefExpression(keyword, openParenToken, expression, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new MakeRefExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new MakeRefExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for RefType expression.</summary>
internal sealed partial class RefTypeExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal RefTypeExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal RefTypeExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal RefTypeExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the RefTypeKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.expression,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RefTypeExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefTypeExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefTypeExpression(this);

    public RefTypeExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.RefTypeExpression(keyword, openParenToken, expression, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RefTypeExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RefTypeExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for RefValue expression.</summary>
internal sealed partial class RefValueExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken comma;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal RefValueExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(comma);
        this.comma = comma;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal RefValueExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(comma);
        this.comma = comma;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal RefValueExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 6;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(comma);
        this.comma = comma;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the RefValueKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Typed reference expression.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>Comma separating the arguments.</summary>
    public SyntaxToken Comma => this.comma;
    /// <summary>The type of the value.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.expression,
            3 => this.comma,
            4 => this.type,
            5 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RefValueExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefValueExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefValueExpression(this);

    public RefValueExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken comma, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || comma != this.Comma || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.RefValueExpression(keyword, openParenToken, expression, comma, type, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RefValueExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.comma, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RefValueExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.comma, this.type, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for Checked or Unchecked expression.</summary>
internal sealed partial class CheckedExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;

    internal CheckedExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CheckedExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CheckedExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the checked or unchecked keyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.expression,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CheckedExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCheckedExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCheckedExpression(this);

    public CheckedExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CheckedExpression(this.Kind, keyword, openParenToken, expression, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CheckedExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CheckedExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.expression, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for Default expression.</summary>
internal sealed partial class DefaultExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal DefaultExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal DefaultExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal DefaultExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the DefaultKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.type,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DefaultExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDefaultExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDefaultExpression(this);

    public DefaultExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.DefaultExpression(keyword, openParenToken, type, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DefaultExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DefaultExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for TypeOf expression.</summary>
internal sealed partial class TypeOfExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal TypeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal TypeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal TypeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the TypeOfKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>The expression to return type of.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.type,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeOfExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeOfExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeOfExpression(this);

    public TypeOfExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.TypeOfExpression(keyword, openParenToken, type, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for SizeOf expression.</summary>
internal sealed partial class SizeOfExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;

    internal SizeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal SizeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal SizeOfExpressionSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing the SizeOfKeyword.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Argument of the primary function.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.openParenToken,
            2 => this.type,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SizeOfExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSizeOfExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSizeOfExpression(this);

    public SizeOfExpressionSyntax Update(SyntaxToken keyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken)
    {
        if (keyword != this.Keyword || openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.SizeOfExpression(keyword, openParenToken, type, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SizeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SizeOfExpressionSyntax(this.Kind, this.keyword, this.openParenToken, this.type, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for invocation expression.</summary>
internal sealed partial class InvocationExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly ArgumentListSyntax argumentList;

    internal InvocationExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, ArgumentListSyntax argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal InvocationExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, ArgumentListSyntax argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal InvocationExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, ArgumentListSyntax argumentList)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>ExpressionSyntax node representing the expression part of the invocation.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>ArgumentListSyntax node representing the list of arguments of the invocation expression.</summary>
    public ArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.argumentList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InvocationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInvocationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInvocationExpression(this);

    public InvocationExpressionSyntax Update(ExpressionSyntax expression, ArgumentListSyntax argumentList)
    {
        if (expression != this.Expression || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.InvocationExpression(expression, argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InvocationExpressionSyntax(this.Kind, this.expression, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InvocationExpressionSyntax(this.Kind, this.expression, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for element access expression.</summary>
internal sealed partial class ElementAccessExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly BracketedArgumentListSyntax argumentList;

    internal ElementAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, BracketedArgumentListSyntax argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ElementAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, BracketedArgumentListSyntax argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ElementAccessExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, BracketedArgumentListSyntax argumentList)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>ExpressionSyntax node representing the expression which is accessing the element.</summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>BracketedArgumentListSyntax node representing the list of arguments of the element access expression.</summary>
    public BracketedArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.argumentList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ElementAccessExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitElementAccessExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitElementAccessExpression(this);

    public ElementAccessExpressionSyntax Update(ExpressionSyntax expression, BracketedArgumentListSyntax argumentList)
    {
        if (expression != this.Expression || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ElementAccessExpression(expression, argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ElementAccessExpressionSyntax(this.Kind, this.expression, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ElementAccessExpressionSyntax(this.Kind, this.expression, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Provides the base class from which the classes that represent argument list syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class BaseArgumentListSyntax : CSharpSyntaxNode
{
    internal BaseArgumentListSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseArgumentListSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>SeparatedSyntaxList of ArgumentSyntax nodes representing the list of arguments.</summary>
    public abstract CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments { get; }
}

/// <summary>Class which represents the syntax node for the list of arguments.</summary>
internal sealed partial class ArgumentListSyntax : BaseArgumentListSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? arguments;
    internal readonly SyntaxToken closeParenToken;

    internal ArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>SyntaxToken representing open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public override CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments => new CoreSyntax.SeparatedSyntaxList<ArgumentSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.arguments,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ArgumentListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArgumentList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArgumentList(this);

    public ArgumentListSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ArgumentList(openParenToken, arguments, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for bracketed argument list.</summary>
internal sealed partial class BracketedArgumentListSyntax : BaseArgumentListSyntax
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? arguments;
    internal readonly SyntaxToken closeBracketToken;

    internal BracketedArgumentListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? arguments, SyntaxToken closeBracketToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal BracketedArgumentListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? arguments, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal BracketedArgumentListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? arguments, SyntaxToken closeBracketToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    /// <summary>SyntaxToken representing open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SeparatedSyntaxList of ArgumentSyntax representing the list of arguments.</summary>
    public override CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> Arguments => new CoreSyntax.SeparatedSyntaxList<ArgumentSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>SyntaxToken representing close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.arguments,
            2 => this.closeBracketToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BracketedArgumentListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBracketedArgumentList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBracketedArgumentList(this);

    public BracketedArgumentListSyntax Update(SyntaxToken openBracketToken, CoreSyntax.SeparatedSyntaxList<ArgumentSyntax> arguments, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || arguments != this.Arguments || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.BracketedArgumentList(openBracketToken, arguments, closeBracketToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BracketedArgumentListSyntax(this.Kind, this.openBracketToken, this.arguments, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BracketedArgumentListSyntax(this.Kind, this.openBracketToken, this.arguments, this.closeBracketToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for argument.</summary>
internal sealed partial class ArgumentSyntax : CSharpSyntaxNode
{
    internal readonly NameColonSyntax? nameColon;
    internal readonly SyntaxToken? refKindKeyword;
    internal readonly ExpressionSyntax expression;

    internal ArgumentSyntax(SyntaxKind kind, NameColonSyntax? nameColon, SyntaxToken? refKindKeyword, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        if (refKindKeyword != null)
        {
            this.AdjustFlagsAndWidth(refKindKeyword);
            this.refKindKeyword = refKindKeyword;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ArgumentSyntax(SyntaxKind kind, NameColonSyntax? nameColon, SyntaxToken? refKindKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        if (refKindKeyword != null)
        {
            this.AdjustFlagsAndWidth(refKindKeyword);
            this.refKindKeyword = refKindKeyword;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ArgumentSyntax(SyntaxKind kind, NameColonSyntax? nameColon, SyntaxToken? refKindKeyword, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 3;
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        if (refKindKeyword != null)
        {
            this.AdjustFlagsAndWidth(refKindKeyword);
            this.refKindKeyword = refKindKeyword;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>NameColonSyntax node representing the optional name arguments.</summary>
    public NameColonSyntax? NameColon => this.nameColon;
    /// <summary>SyntaxToken representing the optional ref or out keyword.</summary>
    public SyntaxToken? RefKindKeyword => this.refKindKeyword;
    /// <summary>ExpressionSyntax node representing the argument.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.nameColon,
            1 => this.refKindKeyword,
            2 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ArgumentSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArgument(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArgument(this);

    public ArgumentSyntax Update(NameColonSyntax nameColon, SyntaxToken refKindKeyword, ExpressionSyntax expression)
    {
        if (nameColon != this.NameColon || refKindKeyword != this.RefKindKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.Argument(nameColon, refKindKeyword, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ArgumentSyntax(this.Kind, this.nameColon, this.refKindKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ArgumentSyntax(this.Kind, this.nameColon, this.refKindKeyword, this.expression, GetDiagnostics(), annotations);
}

internal abstract partial class BaseExpressionColonSyntax : CSharpSyntaxNode
{
    internal BaseExpressionColonSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseExpressionColonSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract ExpressionSyntax Expression { get; }

    public abstract SyntaxToken ColonToken { get; }
}

internal sealed partial class ExpressionColonSyntax : BaseExpressionColonSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken colonToken;

    internal ExpressionColonSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken colonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal ExpressionColonSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken colonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal ExpressionColonSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken colonToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    public override ExpressionSyntax Expression => this.expression;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.colonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ExpressionColonSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExpressionColon(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExpressionColon(this);

    public ExpressionColonSyntax Update(ExpressionSyntax expression, SyntaxToken colonToken)
    {
        if (expression != this.Expression || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.ExpressionColon(expression, colonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ExpressionColonSyntax(this.Kind, this.expression, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ExpressionColonSyntax(this.Kind, this.expression, this.colonToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for name colon syntax.</summary>
internal sealed partial class NameColonSyntax : BaseExpressionColonSyntax
{
    internal readonly IdentifierNameSyntax name;
    internal readonly SyntaxToken colonToken;

    internal NameColonSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken colonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal NameColonSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken colonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal NameColonSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken colonToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>IdentifierNameSyntax representing the identifier name.</summary>
    public IdentifierNameSyntax Name => this.name;
    /// <summary>SyntaxToken representing colon.</summary>
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.name,
            1 => this.colonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.NameColonSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNameColon(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNameColon(this);

    public NameColonSyntax Update(IdentifierNameSyntax name, SyntaxToken colonToken)
    {
        if (name != this.Name || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.NameColon(name, colonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new NameColonSyntax(this.Kind, this.name, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new NameColonSyntax(this.Kind, this.name, this.colonToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for the variable declaration in an out var declaration or a deconstruction declaration.</summary>
internal sealed partial class DeclarationExpressionSyntax : ExpressionSyntax
{
    internal readonly TypeSyntax type;
    internal readonly VariableDesignationSyntax designation;

    internal DeclarationExpressionSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    internal DeclarationExpressionSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    internal DeclarationExpressionSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    public TypeSyntax Type => this.type;
    /// <summary>Declaration representing the variable declared in an out parameter or deconstruction.</summary>
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.type,
            1 => this.designation,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DeclarationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDeclarationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDeclarationExpression(this);

    public DeclarationExpressionSyntax Update(TypeSyntax type, VariableDesignationSyntax designation)
    {
        if (type != this.Type || designation != this.Designation)
        {
            var newNode = SyntaxFactory.DeclarationExpression(type, designation);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DeclarationExpressionSyntax(this.Kind, this.type, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DeclarationExpressionSyntax(this.Kind, this.type, this.designation, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for cast expression.</summary>
internal sealed partial class CastExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken closeParenToken;
    internal readonly ExpressionSyntax expression;

    internal CastExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal CastExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal CastExpressionSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>SyntaxToken representing the open parenthesis.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>TypeSyntax node representing the type to which the expression is being cast.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>SyntaxToken representing the close parenthesis.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;
    /// <summary>ExpressionSyntax node representing the expression that is being casted.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.type,
            2 => this.closeParenToken,
            3 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CastExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCastExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCastExpression(this);

    public CastExpressionSyntax Update(SyntaxToken openParenToken, TypeSyntax type, SyntaxToken closeParenToken, ExpressionSyntax expression)
    {
        if (openParenToken != this.OpenParenToken || type != this.Type || closeParenToken != this.CloseParenToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.CastExpression(openParenToken, type, closeParenToken, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CastExpressionSyntax(this.Kind, this.openParenToken, this.type, this.closeParenToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CastExpressionSyntax(this.Kind, this.openParenToken, this.type, this.closeParenToken, this.expression, GetDiagnostics(), annotations);
}

/// <summary>Provides the base class from which the classes that represent anonymous function expressions are derived.</summary>
internal abstract partial class AnonymousFunctionExpressionSyntax : ExpressionSyntax
{
    internal AnonymousFunctionExpressionSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal AnonymousFunctionExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract CoreSyntax.SyntaxList<SyntaxToken> Modifiers { get; }

    /// <summary>
    /// BlockSyntax node representing the body of the anonymous function.
    /// Only one of Block or ExpressionBody will be non-null.
    /// </summary>
    public abstract BlockSyntax? Block { get; }

    /// <summary>
    /// ExpressionSyntax node representing the body of the anonymous function.
    /// Only one of Block or ExpressionBody will be non-null.
    /// </summary>
    public abstract ExpressionSyntax? ExpressionBody { get; }
}

/// <summary>Class which represents the syntax node for anonymous method expression.</summary>
internal sealed partial class AnonymousMethodExpressionSyntax : AnonymousFunctionExpressionSyntax
{
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken delegateKeyword;
    internal readonly ParameterListSyntax? parameterList;
    internal readonly BlockSyntax block;
    internal readonly ExpressionSyntax? expressionBody;

    internal AnonymousMethodExpressionSyntax(SyntaxKind kind, GreenNode? modifiers, SyntaxToken delegateKeyword, ParameterListSyntax? parameterList, BlockSyntax block, ExpressionSyntax? expressionBody, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    internal AnonymousMethodExpressionSyntax(SyntaxKind kind, GreenNode? modifiers, SyntaxToken delegateKeyword, ParameterListSyntax? parameterList, BlockSyntax block, ExpressionSyntax? expressionBody, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    internal AnonymousMethodExpressionSyntax(SyntaxKind kind, GreenNode? modifiers, SyntaxToken delegateKeyword, ParameterListSyntax? parameterList, BlockSyntax block, ExpressionSyntax? expressionBody)
      : base(kind)
    {
        this.SlotCount = 5;
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>SyntaxToken representing the delegate keyword.</summary>
    public SyntaxToken DelegateKeyword => this.delegateKeyword;
    /// <summary>List of parameters of the anonymous method expression, or null if there no parameters are specified.</summary>
    public ParameterListSyntax? ParameterList => this.parameterList;
    /// <summary>
    /// BlockSyntax node representing the body of the anonymous function.
    /// This will never be null.
    /// </summary>
    public override BlockSyntax Block => this.block;
    /// <summary>
    /// Inherited from AnonymousFunctionExpressionSyntax, but not used for
    /// AnonymousMethodExpressionSyntax.  This will always be null.
    /// </summary>
    public override ExpressionSyntax? ExpressionBody => this.expressionBody;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.modifiers,
            1 => this.delegateKeyword,
            2 => this.parameterList,
            3 => this.block,
            4 => this.expressionBody,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AnonymousMethodExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAnonymousMethodExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAnonymousMethodExpression(this);

    public AnonymousMethodExpressionSyntax Update(CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken delegateKeyword, ParameterListSyntax parameterList, BlockSyntax block, ExpressionSyntax expressionBody)
    {
        if (modifiers != this.Modifiers || delegateKeyword != this.DelegateKeyword || parameterList != this.ParameterList || block != this.Block || expressionBody != this.ExpressionBody)
        {
            var newNode = SyntaxFactory.AnonymousMethodExpression(modifiers, delegateKeyword, parameterList, block, expressionBody);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AnonymousMethodExpressionSyntax(this.Kind, this.modifiers, this.delegateKeyword, this.parameterList, this.block, this.expressionBody, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AnonymousMethodExpressionSyntax(this.Kind, this.modifiers, this.delegateKeyword, this.parameterList, this.block, this.expressionBody, GetDiagnostics(), annotations);
}

/// <summary>Provides the base class from which the classes that represent lambda expressions are derived.</summary>
internal abstract partial class LambdaExpressionSyntax : AnonymousFunctionExpressionSyntax
{
    internal LambdaExpressionSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal LambdaExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>SyntaxToken representing equals greater than.</summary>
    public abstract SyntaxToken ArrowToken { get; }
}

/// <summary>Class which represents the syntax node for a simple lambda expression.</summary>
internal sealed partial class SimpleLambdaExpressionSyntax : LambdaExpressionSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly ParameterSyntax parameter;
    internal readonly SyntaxToken arrowToken;
    internal readonly BlockSyntax? block;
    internal readonly ExpressionSyntax? expressionBody;

    internal SimpleLambdaExpressionSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, ParameterSyntax parameter, SyntaxToken arrowToken, BlockSyntax? block, ExpressionSyntax? expressionBody, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(parameter);
        this.parameter = parameter;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        if (block != null)
        {
            this.AdjustFlagsAndWidth(block);
            this.block = block;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    internal SimpleLambdaExpressionSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, ParameterSyntax parameter, SyntaxToken arrowToken, BlockSyntax? block, ExpressionSyntax? expressionBody, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(parameter);
        this.parameter = parameter;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        if (block != null)
        {
            this.AdjustFlagsAndWidth(block);
            this.block = block;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    internal SimpleLambdaExpressionSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, ParameterSyntax parameter, SyntaxToken arrowToken, BlockSyntax? block, ExpressionSyntax? expressionBody)
      : base(kind)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(parameter);
        this.parameter = parameter;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        if (block != null)
        {
            this.AdjustFlagsAndWidth(block);
            this.block = block;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>ParameterSyntax node representing the parameter of the lambda expression.</summary>
    public ParameterSyntax Parameter => this.parameter;
    /// <summary>SyntaxToken representing equals greater than.</summary>
    public override SyntaxToken ArrowToken => this.arrowToken;
    /// <summary>
    /// BlockSyntax node representing the body of the lambda.
    /// Only one of Block or ExpressionBody will be non-null.
    /// </summary>
    public override BlockSyntax? Block => this.block;
    /// <summary>
    /// ExpressionSyntax node representing the body of the lambda.
    /// Only one of Block or ExpressionBody will be non-null.
    /// </summary>
    public override ExpressionSyntax? ExpressionBody => this.expressionBody;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.parameter,
            3 => this.arrowToken,
            4 => this.block,
            5 => this.expressionBody,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SimpleLambdaExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSimpleLambdaExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSimpleLambdaExpression(this);

    public SimpleLambdaExpressionSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, ParameterSyntax parameter, SyntaxToken arrowToken, BlockSyntax block, ExpressionSyntax expressionBody)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || parameter != this.Parameter || arrowToken != this.ArrowToken || block != this.Block || expressionBody != this.ExpressionBody)
        {
            var newNode = SyntaxFactory.SimpleLambdaExpression(attributeLists, modifiers, parameter, arrowToken, block, expressionBody);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SimpleLambdaExpressionSyntax(this.Kind, this.attributeLists, this.modifiers, this.parameter, this.arrowToken, this.block, this.expressionBody, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SimpleLambdaExpressionSyntax(this.Kind, this.attributeLists, this.modifiers, this.parameter, this.arrowToken, this.block, this.expressionBody, GetDiagnostics(), annotations);
}

internal sealed partial class RefExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken refKeyword;
    internal readonly ExpressionSyntax expression;

    internal RefExpressionSyntax(SyntaxKind kind, SyntaxToken refKeyword, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal RefExpressionSyntax(SyntaxKind kind, SyntaxToken refKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal RefExpressionSyntax(SyntaxKind kind, SyntaxToken refKeyword, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken RefKeyword => this.refKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.refKeyword,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RefExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefExpression(this);

    public RefExpressionSyntax Update(SyntaxToken refKeyword, ExpressionSyntax expression)
    {
        if (refKeyword != this.RefKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.RefExpression(refKeyword, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RefExpressionSyntax(this.Kind, this.refKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RefExpressionSyntax(this.Kind, this.refKeyword, this.expression, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for parenthesized lambda expression.</summary>
internal sealed partial class ParenthesizedLambdaExpressionSyntax : LambdaExpressionSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax? returnType;
    internal readonly ParameterListSyntax parameterList;
    internal readonly SyntaxToken arrowToken;
    internal readonly BlockSyntax? block;
    internal readonly ExpressionSyntax? expressionBody;

    internal ParenthesizedLambdaExpressionSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? returnType, ParameterListSyntax parameterList, SyntaxToken arrowToken, BlockSyntax? block, ExpressionSyntax? expressionBody, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 7;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (returnType != null)
        {
            this.AdjustFlagsAndWidth(returnType);
            this.returnType = returnType;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        if (block != null)
        {
            this.AdjustFlagsAndWidth(block);
            this.block = block;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    internal ParenthesizedLambdaExpressionSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? returnType, ParameterListSyntax parameterList, SyntaxToken arrowToken, BlockSyntax? block, ExpressionSyntax? expressionBody, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 7;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (returnType != null)
        {
            this.AdjustFlagsAndWidth(returnType);
            this.returnType = returnType;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        if (block != null)
        {
            this.AdjustFlagsAndWidth(block);
            this.block = block;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    internal ParenthesizedLambdaExpressionSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? returnType, ParameterListSyntax parameterList, SyntaxToken arrowToken, BlockSyntax? block, ExpressionSyntax? expressionBody)
      : base(kind)
    {
        this.SlotCount = 7;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (returnType != null)
        {
            this.AdjustFlagsAndWidth(returnType);
            this.returnType = returnType;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        if (block != null)
        {
            this.AdjustFlagsAndWidth(block);
            this.block = block;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public TypeSyntax? ReturnType => this.returnType;
    /// <summary>ParameterListSyntax node representing the list of parameters for the lambda expression.</summary>
    public ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>SyntaxToken representing equals greater than.</summary>
    public override SyntaxToken ArrowToken => this.arrowToken;
    /// <summary>
    /// BlockSyntax node representing the body of the lambda.
    /// Only one of Block or ExpressionBody will be non-null.
    /// </summary>
    public override BlockSyntax? Block => this.block;
    /// <summary>
    /// ExpressionSyntax node representing the body of the lambda.
    /// Only one of Block or ExpressionBody will be non-null.
    /// </summary>
    public override ExpressionSyntax? ExpressionBody => this.expressionBody;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.returnType,
            3 => this.parameterList,
            4 => this.arrowToken,
            5 => this.block,
            6 => this.expressionBody,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ParenthesizedLambdaExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedLambdaExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedLambdaExpression(this);

    public ParenthesizedLambdaExpressionSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, ParameterListSyntax parameterList, SyntaxToken arrowToken, BlockSyntax block, ExpressionSyntax expressionBody)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || parameterList != this.ParameterList || arrowToken != this.ArrowToken || block != this.Block || expressionBody != this.ExpressionBody)
        {
            var newNode = SyntaxFactory.ParenthesizedLambdaExpression(attributeLists, modifiers, returnType, parameterList, arrowToken, block, expressionBody);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ParenthesizedLambdaExpressionSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.parameterList, this.arrowToken, this.block, this.expressionBody, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ParenthesizedLambdaExpressionSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.parameterList, this.arrowToken, this.block, this.expressionBody, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for initializer expression.</summary>
internal sealed partial class InitializerExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? expressions;
    internal readonly SyntaxToken closeBraceToken;

    internal InitializerExpressionSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? expressions, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (expressions != null)
        {
            this.AdjustFlagsAndWidth(expressions);
            this.expressions = expressions;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal InitializerExpressionSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? expressions, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (expressions != null)
        {
            this.AdjustFlagsAndWidth(expressions);
            this.expressions = expressions;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal InitializerExpressionSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? expressions, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (expressions != null)
        {
            this.AdjustFlagsAndWidth(expressions);
            this.expressions = expressions;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    /// <summary>SyntaxToken representing the open brace.</summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>SeparatedSyntaxList of ExpressionSyntax representing the list of expressions in the initializer expression.</summary>
    public CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> Expressions => new CoreSyntax.SeparatedSyntaxList<ExpressionSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.expressions));
    /// <summary>SyntaxToken representing the close brace.</summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBraceToken,
            1 => this.expressions,
            2 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InitializerExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInitializerExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInitializerExpression(this);

    public InitializerExpressionSyntax Update(SyntaxToken openBraceToken, CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> expressions, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || expressions != this.Expressions || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.InitializerExpression(this.Kind, openBraceToken, expressions, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InitializerExpressionSyntax(this.Kind, this.openBraceToken, this.expressions, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InitializerExpressionSyntax(this.Kind, this.openBraceToken, this.expressions, this.closeBraceToken, GetDiagnostics(), annotations);
}

internal abstract partial class BaseObjectCreationExpressionSyntax : ExpressionSyntax
{
    internal BaseObjectCreationExpressionSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseObjectCreationExpressionSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public abstract SyntaxToken NewKeyword { get; }

    /// <summary>ArgumentListSyntax representing the list of arguments passed as part of the object creation expression.</summary>
    public abstract ArgumentListSyntax? ArgumentList { get; }

    /// <summary>InitializerExpressionSyntax representing the initializer expression for the object being created.</summary>
    public abstract InitializerExpressionSyntax? Initializer { get; }
}

/// <summary>Class which represents the syntax node for implicit object creation expression.</summary>
internal sealed partial class ImplicitObjectCreationExpressionSyntax : BaseObjectCreationExpressionSyntax
{
    internal readonly SyntaxToken newKeyword;
    internal readonly ArgumentListSyntax argumentList;
    internal readonly InitializerExpressionSyntax? initializer;

    internal ImplicitObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArgumentListSyntax argumentList, InitializerExpressionSyntax? initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal ImplicitObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArgumentListSyntax argumentList, InitializerExpressionSyntax? initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal ImplicitObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArgumentListSyntax argumentList, InitializerExpressionSyntax? initializer)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public override SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>ArgumentListSyntax representing the list of arguments passed as part of the object creation expression.</summary>
    public override ArgumentListSyntax ArgumentList => this.argumentList;
    /// <summary>InitializerExpressionSyntax representing the initializer expression for the object being created.</summary>
    public override InitializerExpressionSyntax? Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.newKeyword,
            1 => this.argumentList,
            2 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ImplicitObjectCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitObjectCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitObjectCreationExpression(this);

    public ImplicitObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ImplicitObjectCreationExpression(newKeyword, argumentList, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ImplicitObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.argumentList, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ImplicitObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.argumentList, this.initializer, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for object creation expression.</summary>
internal sealed partial class ObjectCreationExpressionSyntax : BaseObjectCreationExpressionSyntax
{
    internal readonly SyntaxToken newKeyword;
    internal readonly TypeSyntax type;
    internal readonly ArgumentListSyntax? argumentList;
    internal readonly InitializerExpressionSyntax? initializer;

    internal ObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax? argumentList, InitializerExpressionSyntax? initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal ObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax? argumentList, InitializerExpressionSyntax? initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal ObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax? argumentList, InitializerExpressionSyntax? initializer)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public override SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>TypeSyntax representing the type of the object being created.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>ArgumentListSyntax representing the list of arguments passed as part of the object creation expression.</summary>
    public override ArgumentListSyntax? ArgumentList => this.argumentList;
    /// <summary>InitializerExpressionSyntax representing the initializer expression for the object being created.</summary>
    public override InitializerExpressionSyntax? Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.newKeyword,
            1 => this.type,
            2 => this.argumentList,
            3 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ObjectCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitObjectCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitObjectCreationExpression(this);

    public ObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, TypeSyntax type, ArgumentListSyntax argumentList, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || type != this.Type || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ObjectCreationExpression(newKeyword, type, argumentList, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.argumentList, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.argumentList, this.initializer, GetDiagnostics(), annotations);
}

internal sealed partial class WithExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken withKeyword;
    internal readonly InitializerExpressionSyntax initializer;

    internal WithExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken withKeyword, InitializerExpressionSyntax initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(withKeyword);
        this.withKeyword = withKeyword;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    internal WithExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken withKeyword, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(withKeyword);
        this.withKeyword = withKeyword;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    internal WithExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken withKeyword, InitializerExpressionSyntax initializer)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(withKeyword);
        this.withKeyword = withKeyword;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken WithKeyword => this.withKeyword;
    /// <summary>InitializerExpressionSyntax representing the initializer expression for the with expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.withKeyword,
            2 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.WithExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWithExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWithExpression(this);

    public WithExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken withKeyword, InitializerExpressionSyntax initializer)
    {
        if (expression != this.Expression || withKeyword != this.WithKeyword || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.WithExpression(expression, withKeyword, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new WithExpressionSyntax(this.Kind, this.expression, this.withKeyword, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new WithExpressionSyntax(this.Kind, this.expression, this.withKeyword, this.initializer, GetDiagnostics(), annotations);
}

internal sealed partial class AnonymousObjectMemberDeclaratorSyntax : CSharpSyntaxNode
{
    internal readonly NameEqualsSyntax? nameEquals;
    internal readonly ExpressionSyntax expression;

    internal AnonymousObjectMemberDeclaratorSyntax(SyntaxKind kind, NameEqualsSyntax? nameEquals, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal AnonymousObjectMemberDeclaratorSyntax(SyntaxKind kind, NameEqualsSyntax? nameEquals, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal AnonymousObjectMemberDeclaratorSyntax(SyntaxKind kind, NameEqualsSyntax? nameEquals, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>NameEqualsSyntax representing the optional name of the member being initialized.</summary>
    public NameEqualsSyntax? NameEquals => this.nameEquals;
    /// <summary>ExpressionSyntax representing the value the member is initialized with.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.nameEquals,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AnonymousObjectMemberDeclaratorSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAnonymousObjectMemberDeclarator(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAnonymousObjectMemberDeclarator(this);

    public AnonymousObjectMemberDeclaratorSyntax Update(NameEqualsSyntax nameEquals, ExpressionSyntax expression)
    {
        if (nameEquals != this.NameEquals || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AnonymousObjectMemberDeclarator(nameEquals, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AnonymousObjectMemberDeclaratorSyntax(this.Kind, this.nameEquals, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AnonymousObjectMemberDeclaratorSyntax(this.Kind, this.nameEquals, this.expression, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for anonymous object creation expression.</summary>
internal sealed partial class AnonymousObjectCreationExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken newKeyword;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? initializers;
    internal readonly SyntaxToken closeBraceToken;

    internal AnonymousObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBraceToken, GreenNode? initializers, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal AnonymousObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBraceToken, GreenNode? initializers, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal AnonymousObjectCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBraceToken, GreenNode? initializers, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>SyntaxToken representing the open brace.</summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>SeparatedSyntaxList of AnonymousObjectMemberDeclaratorSyntax representing the list of object member initializers.</summary>
    public CoreSyntax.SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> Initializers => new CoreSyntax.SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.initializers));
    /// <summary>SyntaxToken representing the close brace.</summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.newKeyword,
            1 => this.openBraceToken,
            2 => this.initializers,
            3 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AnonymousObjectCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAnonymousObjectCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAnonymousObjectCreationExpression(this);

    public AnonymousObjectCreationExpressionSyntax Update(SyntaxToken newKeyword, SyntaxToken openBraceToken, CoreSyntax.SeparatedSyntaxList<AnonymousObjectMemberDeclaratorSyntax> initializers, SyntaxToken closeBraceToken)
    {
        if (newKeyword != this.NewKeyword || openBraceToken != this.OpenBraceToken || initializers != this.Initializers || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.AnonymousObjectCreationExpression(newKeyword, openBraceToken, initializers, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AnonymousObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBraceToken, this.initializers, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AnonymousObjectCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBraceToken, this.initializers, this.closeBraceToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for array creation expression.</summary>
internal sealed partial class ArrayCreationExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken newKeyword;
    internal readonly ArrayTypeSyntax type;
    internal readonly InitializerExpressionSyntax? initializer;

    internal ArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax? initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal ArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax? initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal ArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax? initializer)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>ArrayTypeSyntax node representing the type of the array.</summary>
    public ArrayTypeSyntax Type => this.type;
    /// <summary>InitializerExpressionSyntax node representing the initializer of the array creation expression.</summary>
    public InitializerExpressionSyntax? Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.newKeyword,
            1 => this.type,
            2 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ArrayCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrayCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrayCreationExpression(this);

    public ArrayCreationExpressionSyntax Update(SyntaxToken newKeyword, ArrayTypeSyntax type, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || type != this.Type || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ArrayCreationExpression(newKeyword, type, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.type, this.initializer, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for implicit array creation expression.</summary>
internal sealed partial class ImplicitArrayCreationExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken newKeyword;
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? commas;
    internal readonly SyntaxToken closeBracketToken;
    internal readonly InitializerExpressionSyntax initializer;

    internal ImplicitArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBracketToken, GreenNode? commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (commas != null)
        {
            this.AdjustFlagsAndWidth(commas);
            this.commas = commas;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    internal ImplicitArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBracketToken, GreenNode? commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (commas != null)
        {
            this.AdjustFlagsAndWidth(commas);
            this.commas = commas;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    internal ImplicitArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openBracketToken, GreenNode? commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
      : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (commas != null)
        {
            this.AdjustFlagsAndWidth(commas);
            this.commas = commas;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    /// <summary>SyntaxToken representing the new keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>SyntaxToken representing the open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SyntaxList of SyntaxToken representing the commas in the implicit array creation expression.</summary>
    public CoreSyntax.SyntaxList<SyntaxToken> Commas => new CoreSyntax.SyntaxList<SyntaxToken>(this.commas);
    /// <summary>SyntaxToken representing the close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;
    /// <summary>InitializerExpressionSyntax representing the initializer expression of the implicit array creation expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.newKeyword,
            1 => this.openBracketToken,
            2 => this.commas,
            3 => this.closeBracketToken,
            4 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ImplicitArrayCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitArrayCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitArrayCreationExpression(this);

    public ImplicitArrayCreationExpressionSyntax Update(SyntaxToken newKeyword, SyntaxToken openBracketToken, CoreSyntax.SyntaxList<SyntaxToken> commas, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
    {
        if (newKeyword != this.NewKeyword || openBracketToken != this.OpenBracketToken || commas != this.Commas || closeBracketToken != this.CloseBracketToken || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ImplicitArrayCreationExpression(newKeyword, openBracketToken, commas, closeBracketToken, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ImplicitArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBracketToken, this.commas, this.closeBracketToken, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ImplicitArrayCreationExpressionSyntax(this.Kind, this.newKeyword, this.openBracketToken, this.commas, this.closeBracketToken, this.initializer, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for stackalloc array creation expression.</summary>
internal sealed partial class StackAllocArrayCreationExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken stackAllocKeyword;
    internal readonly TypeSyntax type;
    internal readonly InitializerExpressionSyntax? initializer;

    internal StackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax? initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal StackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax? initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal StackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax? initializer)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>SyntaxToken representing the stackalloc keyword.</summary>
    public SyntaxToken StackAllocKeyword => this.stackAllocKeyword;
    /// <summary>TypeSyntax node representing the type of the stackalloc array.</summary>
    public TypeSyntax Type => this.type;
    /// <summary>InitializerExpressionSyntax node representing the initializer of the stackalloc array creation expression.</summary>
    public InitializerExpressionSyntax? Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.stackAllocKeyword,
            1 => this.type,
            2 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.StackAllocArrayCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitStackAllocArrayCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitStackAllocArrayCreationExpression(this);

    public StackAllocArrayCreationExpressionSyntax Update(SyntaxToken stackAllocKeyword, TypeSyntax type, InitializerExpressionSyntax initializer)
    {
        if (stackAllocKeyword != this.StackAllocKeyword || type != this.Type || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.StackAllocArrayCreationExpression(stackAllocKeyword, type, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new StackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.type, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new StackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.type, this.initializer, GetDiagnostics(), annotations);
}

/// <summary>Class which represents the syntax node for implicit stackalloc array creation expression.</summary>
internal sealed partial class ImplicitStackAllocArrayCreationExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken stackAllocKeyword;
    internal readonly SyntaxToken openBracketToken;
    internal readonly SyntaxToken closeBracketToken;
    internal readonly InitializerExpressionSyntax initializer;

    internal ImplicitStackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    internal ImplicitStackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    internal ImplicitStackAllocArrayCreationExpressionSyntax(SyntaxKind kind, SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(stackAllocKeyword);
        this.stackAllocKeyword = stackAllocKeyword;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        this.AdjustFlagsAndWidth(initializer);
        this.initializer = initializer;
    }

    /// <summary>SyntaxToken representing the stackalloc keyword.</summary>
    public SyntaxToken StackAllocKeyword => this.stackAllocKeyword;
    /// <summary>SyntaxToken representing the open bracket.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SyntaxToken representing the close bracket.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;
    /// <summary>InitializerExpressionSyntax representing the initializer expression of the implicit stackalloc array creation expression.</summary>
    public InitializerExpressionSyntax Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.stackAllocKeyword,
            1 => this.openBracketToken,
            2 => this.closeBracketToken,
            3 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ImplicitStackAllocArrayCreationExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitImplicitStackAllocArrayCreationExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitImplicitStackAllocArrayCreationExpression(this);

    public ImplicitStackAllocArrayCreationExpressionSyntax Update(SyntaxToken stackAllocKeyword, SyntaxToken openBracketToken, SyntaxToken closeBracketToken, InitializerExpressionSyntax initializer)
    {
        if (stackAllocKeyword != this.StackAllocKeyword || openBracketToken != this.OpenBracketToken || closeBracketToken != this.CloseBracketToken || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.ImplicitStackAllocArrayCreationExpression(stackAllocKeyword, openBracketToken, closeBracketToken, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ImplicitStackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.openBracketToken, this.closeBracketToken, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ImplicitStackAllocArrayCreationExpressionSyntax(this.Kind, this.stackAllocKeyword, this.openBracketToken, this.closeBracketToken, this.initializer, GetDiagnostics(), annotations);
}

internal sealed partial class CollectionExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? elements;
    internal readonly SyntaxToken closeBracketToken;

    internal CollectionExpressionSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? elements, SyntaxToken closeBracketToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal CollectionExpressionSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? elements, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal CollectionExpressionSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? elements, SyntaxToken closeBracketToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (elements != null)
        {
            this.AdjustFlagsAndWidth(elements);
            this.elements = elements;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>SeparatedSyntaxList of CollectionElementSyntax representing the list of elements in the collection expression.</summary>
    public CoreSyntax.SeparatedSyntaxList<CollectionElementSyntax> Elements => new CoreSyntax.SeparatedSyntaxList<CollectionElementSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.elements));
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.elements,
            2 => this.closeBracketToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CollectionExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCollectionExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCollectionExpression(this);

    public CollectionExpressionSyntax Update(SyntaxToken openBracketToken, CoreSyntax.SeparatedSyntaxList<CollectionElementSyntax> elements, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || elements != this.Elements || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.CollectionExpression(openBracketToken, elements, closeBracketToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CollectionExpressionSyntax(this.Kind, this.openBracketToken, this.elements, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CollectionExpressionSyntax(this.Kind, this.openBracketToken, this.elements, this.closeBracketToken, GetDiagnostics(), annotations);
}

internal abstract partial class CollectionElementSyntax : CSharpSyntaxNode
{
    internal CollectionElementSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal CollectionElementSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

internal sealed partial class ExpressionElementSyntax : CollectionElementSyntax
{
    internal readonly ExpressionSyntax expression;

    internal ExpressionElementSyntax(SyntaxKind kind, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ExpressionElementSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ExpressionElementSyntax(SyntaxKind kind, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.expression : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ExpressionElementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExpressionElement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExpressionElement(this);

    public ExpressionElementSyntax Update(ExpressionSyntax expression)
    {
        if (expression != this.Expression)
        {
            var newNode = SyntaxFactory.ExpressionElement(expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ExpressionElementSyntax(this.Kind, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ExpressionElementSyntax(this.Kind, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class SpreadElementSyntax : CollectionElementSyntax
{
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax expression;

    internal SpreadElementSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal SpreadElementSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal SpreadElementSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken OperatorToken => this.operatorToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operatorToken,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SpreadElementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSpreadElement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSpreadElement(this);

    public SpreadElementSyntax Update(SyntaxToken operatorToken, ExpressionSyntax expression)
    {
        if (operatorToken != this.OperatorToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.SpreadElement(operatorToken, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SpreadElementSyntax(this.Kind, this.operatorToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SpreadElementSyntax(this.Kind, this.operatorToken, this.expression, GetDiagnostics(), annotations);
}

internal abstract partial class QueryClauseSyntax : CSharpSyntaxNode
{
    internal QueryClauseSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal QueryClauseSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

internal abstract partial class SelectOrGroupClauseSyntax : CSharpSyntaxNode
{
    internal SelectOrGroupClauseSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal SelectOrGroupClauseSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

internal sealed partial class QueryExpressionSyntax : ExpressionSyntax
{
    internal readonly FromClauseSyntax fromClause;
    internal readonly QueryBodySyntax body;

    internal QueryExpressionSyntax(SyntaxKind kind, FromClauseSyntax fromClause, QueryBodySyntax body, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(fromClause);
        this.fromClause = fromClause;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    internal QueryExpressionSyntax(SyntaxKind kind, FromClauseSyntax fromClause, QueryBodySyntax body, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(fromClause);
        this.fromClause = fromClause;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    internal QueryExpressionSyntax(SyntaxKind kind, FromClauseSyntax fromClause, QueryBodySyntax body)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(fromClause);
        this.fromClause = fromClause;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    public FromClauseSyntax FromClause => this.fromClause;
    public QueryBodySyntax Body => this.body;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.fromClause,
            1 => this.body,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.QueryExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQueryExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQueryExpression(this);

    public QueryExpressionSyntax Update(FromClauseSyntax fromClause, QueryBodySyntax body)
    {
        if (fromClause != this.FromClause || body != this.Body)
        {
            var newNode = SyntaxFactory.QueryExpression(fromClause, body);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new QueryExpressionSyntax(this.Kind, this.fromClause, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new QueryExpressionSyntax(this.Kind, this.fromClause, this.body, GetDiagnostics(), annotations);
}

internal sealed partial class QueryBodySyntax : CSharpSyntaxNode
{
    internal readonly GreenNode? clauses;
    internal readonly SelectOrGroupClauseSyntax selectOrGroup;
    internal readonly QueryContinuationSyntax? continuation;

    internal QueryBodySyntax(SyntaxKind kind, GreenNode? clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax? continuation, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (clauses != null)
        {
            this.AdjustFlagsAndWidth(clauses);
            this.clauses = clauses;
        }
        this.AdjustFlagsAndWidth(selectOrGroup);
        this.selectOrGroup = selectOrGroup;
        if (continuation != null)
        {
            this.AdjustFlagsAndWidth(continuation);
            this.continuation = continuation;
        }
    }

    internal QueryBodySyntax(SyntaxKind kind, GreenNode? clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax? continuation, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (clauses != null)
        {
            this.AdjustFlagsAndWidth(clauses);
            this.clauses = clauses;
        }
        this.AdjustFlagsAndWidth(selectOrGroup);
        this.selectOrGroup = selectOrGroup;
        if (continuation != null)
        {
            this.AdjustFlagsAndWidth(continuation);
            this.continuation = continuation;
        }
    }

    internal QueryBodySyntax(SyntaxKind kind, GreenNode? clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax? continuation)
      : base(kind)
    {
        this.SlotCount = 3;
        if (clauses != null)
        {
            this.AdjustFlagsAndWidth(clauses);
            this.clauses = clauses;
        }
        this.AdjustFlagsAndWidth(selectOrGroup);
        this.selectOrGroup = selectOrGroup;
        if (continuation != null)
        {
            this.AdjustFlagsAndWidth(continuation);
            this.continuation = continuation;
        }
    }

    public CoreSyntax.SyntaxList<QueryClauseSyntax> Clauses => new CoreSyntax.SyntaxList<QueryClauseSyntax>(this.clauses);
    public SelectOrGroupClauseSyntax SelectOrGroup => this.selectOrGroup;
    public QueryContinuationSyntax? Continuation => this.continuation;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.clauses,
            1 => this.selectOrGroup,
            2 => this.continuation,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.QueryBodySyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQueryBody(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQueryBody(this);

    public QueryBodySyntax Update(CoreSyntax.SyntaxList<QueryClauseSyntax> clauses, SelectOrGroupClauseSyntax selectOrGroup, QueryContinuationSyntax continuation)
    {
        if (clauses != this.Clauses || selectOrGroup != this.SelectOrGroup || continuation != this.Continuation)
        {
            var newNode = SyntaxFactory.QueryBody(clauses, selectOrGroup, continuation);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new QueryBodySyntax(this.Kind, this.clauses, this.selectOrGroup, this.continuation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new QueryBodySyntax(this.Kind, this.clauses, this.selectOrGroup, this.continuation, GetDiagnostics(), annotations);
}

internal sealed partial class FromClauseSyntax : QueryClauseSyntax
{
    internal readonly SyntaxToken fromKeyword;
    internal readonly TypeSyntax? type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax expression;

    internal FromClauseSyntax(SyntaxKind kind, SyntaxToken fromKeyword, TypeSyntax? type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fromKeyword);
        this.fromKeyword = fromKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal FromClauseSyntax(SyntaxKind kind, SyntaxToken fromKeyword, TypeSyntax? type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fromKeyword);
        this.fromKeyword = fromKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal FromClauseSyntax(SyntaxKind kind, SyntaxToken fromKeyword, TypeSyntax? type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(fromKeyword);
        this.fromKeyword = fromKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken FromKeyword => this.fromKeyword;
    public TypeSyntax? Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken InKeyword => this.inKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.fromKeyword,
            1 => this.type,
            2 => this.identifier,
            3 => this.inKeyword,
            4 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FromClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFromClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFromClause(this);

    public FromClauseSyntax Update(SyntaxToken fromKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression)
    {
        if (fromKeyword != this.FromKeyword || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.FromClause(fromKeyword, type, identifier, inKeyword, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FromClauseSyntax(this.Kind, this.fromKeyword, this.type, this.identifier, this.inKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FromClauseSyntax(this.Kind, this.fromKeyword, this.type, this.identifier, this.inKeyword, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class LetClauseSyntax : QueryClauseSyntax
{
    internal readonly SyntaxToken letKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken equalsToken;
    internal readonly ExpressionSyntax expression;

    internal LetClauseSyntax(SyntaxKind kind, SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(letKeyword);
        this.letKeyword = letKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal LetClauseSyntax(SyntaxKind kind, SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(letKeyword);
        this.letKeyword = letKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal LetClauseSyntax(SyntaxKind kind, SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(letKeyword);
        this.letKeyword = letKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken LetKeyword => this.letKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken EqualsToken => this.equalsToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.letKeyword,
            1 => this.identifier,
            2 => this.equalsToken,
            3 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.LetClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLetClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLetClause(this);

    public LetClauseSyntax Update(SyntaxToken letKeyword, SyntaxToken identifier, SyntaxToken equalsToken, ExpressionSyntax expression)
    {
        if (letKeyword != this.LetKeyword || identifier != this.Identifier || equalsToken != this.EqualsToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.LetClause(letKeyword, identifier, equalsToken, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new LetClauseSyntax(this.Kind, this.letKeyword, this.identifier, this.equalsToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new LetClauseSyntax(this.Kind, this.letKeyword, this.identifier, this.equalsToken, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class JoinClauseSyntax : QueryClauseSyntax
{
    internal readonly SyntaxToken joinKeyword;
    internal readonly TypeSyntax? type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax inExpression;
    internal readonly SyntaxToken onKeyword;
    internal readonly ExpressionSyntax leftExpression;
    internal readonly SyntaxToken equalsKeyword;
    internal readonly ExpressionSyntax rightExpression;
    internal readonly JoinIntoClauseSyntax? into;

    internal JoinClauseSyntax(SyntaxKind kind, SyntaxToken joinKeyword, TypeSyntax? type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax? into, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(joinKeyword);
        this.joinKeyword = joinKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(inExpression);
        this.inExpression = inExpression;
        this.AdjustFlagsAndWidth(onKeyword);
        this.onKeyword = onKeyword;
        this.AdjustFlagsAndWidth(leftExpression);
        this.leftExpression = leftExpression;
        this.AdjustFlagsAndWidth(equalsKeyword);
        this.equalsKeyword = equalsKeyword;
        this.AdjustFlagsAndWidth(rightExpression);
        this.rightExpression = rightExpression;
        if (into != null)
        {
            this.AdjustFlagsAndWidth(into);
            this.into = into;
        }
    }

    internal JoinClauseSyntax(SyntaxKind kind, SyntaxToken joinKeyword, TypeSyntax? type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax? into, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(joinKeyword);
        this.joinKeyword = joinKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(inExpression);
        this.inExpression = inExpression;
        this.AdjustFlagsAndWidth(onKeyword);
        this.onKeyword = onKeyword;
        this.AdjustFlagsAndWidth(leftExpression);
        this.leftExpression = leftExpression;
        this.AdjustFlagsAndWidth(equalsKeyword);
        this.equalsKeyword = equalsKeyword;
        this.AdjustFlagsAndWidth(rightExpression);
        this.rightExpression = rightExpression;
        if (into != null)
        {
            this.AdjustFlagsAndWidth(into);
            this.into = into;
        }
    }

    internal JoinClauseSyntax(SyntaxKind kind, SyntaxToken joinKeyword, TypeSyntax? type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax? into)
      : base(kind)
    {
        this.SlotCount = 10;
        this.AdjustFlagsAndWidth(joinKeyword);
        this.joinKeyword = joinKeyword;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(inExpression);
        this.inExpression = inExpression;
        this.AdjustFlagsAndWidth(onKeyword);
        this.onKeyword = onKeyword;
        this.AdjustFlagsAndWidth(leftExpression);
        this.leftExpression = leftExpression;
        this.AdjustFlagsAndWidth(equalsKeyword);
        this.equalsKeyword = equalsKeyword;
        this.AdjustFlagsAndWidth(rightExpression);
        this.rightExpression = rightExpression;
        if (into != null)
        {
            this.AdjustFlagsAndWidth(into);
            this.into = into;
        }
    }

    public SyntaxToken JoinKeyword => this.joinKeyword;
    public TypeSyntax? Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public SyntaxToken InKeyword => this.inKeyword;
    public ExpressionSyntax InExpression => this.inExpression;
    public SyntaxToken OnKeyword => this.onKeyword;
    public ExpressionSyntax LeftExpression => this.leftExpression;
    public SyntaxToken EqualsKeyword => this.equalsKeyword;
    public ExpressionSyntax RightExpression => this.rightExpression;
    public JoinIntoClauseSyntax? Into => this.into;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.joinKeyword,
            1 => this.type,
            2 => this.identifier,
            3 => this.inKeyword,
            4 => this.inExpression,
            5 => this.onKeyword,
            6 => this.leftExpression,
            7 => this.equalsKeyword,
            8 => this.rightExpression,
            9 => this.into,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.JoinClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitJoinClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitJoinClause(this);

    public JoinClauseSyntax Update(SyntaxToken joinKeyword, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax inExpression, SyntaxToken onKeyword, ExpressionSyntax leftExpression, SyntaxToken equalsKeyword, ExpressionSyntax rightExpression, JoinIntoClauseSyntax into)
    {
        if (joinKeyword != this.JoinKeyword || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || inExpression != this.InExpression || onKeyword != this.OnKeyword || leftExpression != this.LeftExpression || equalsKeyword != this.EqualsKeyword || rightExpression != this.RightExpression || into != this.Into)
        {
            var newNode = SyntaxFactory.JoinClause(joinKeyword, type, identifier, inKeyword, inExpression, onKeyword, leftExpression, equalsKeyword, rightExpression, into);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new JoinClauseSyntax(this.Kind, this.joinKeyword, this.type, this.identifier, this.inKeyword, this.inExpression, this.onKeyword, this.leftExpression, this.equalsKeyword, this.rightExpression, this.into, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new JoinClauseSyntax(this.Kind, this.joinKeyword, this.type, this.identifier, this.inKeyword, this.inExpression, this.onKeyword, this.leftExpression, this.equalsKeyword, this.rightExpression, this.into, GetDiagnostics(), annotations);
}

internal sealed partial class JoinIntoClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken intoKeyword;
    internal readonly SyntaxToken identifier;

    internal JoinIntoClauseSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal JoinIntoClauseSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal JoinIntoClauseSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    public SyntaxToken IntoKeyword => this.intoKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.intoKeyword,
            1 => this.identifier,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.JoinIntoClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitJoinIntoClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitJoinIntoClause(this);

    public JoinIntoClauseSyntax Update(SyntaxToken intoKeyword, SyntaxToken identifier)
    {
        if (intoKeyword != this.IntoKeyword || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.JoinIntoClause(intoKeyword, identifier);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new JoinIntoClauseSyntax(this.Kind, this.intoKeyword, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new JoinIntoClauseSyntax(this.Kind, this.intoKeyword, this.identifier, GetDiagnostics(), annotations);
}

internal sealed partial class WhereClauseSyntax : QueryClauseSyntax
{
    internal readonly SyntaxToken whereKeyword;
    internal readonly ExpressionSyntax condition;

    internal WhereClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, ExpressionSyntax condition, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    internal WhereClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, ExpressionSyntax condition, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    internal WhereClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, ExpressionSyntax condition)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    public SyntaxToken WhereKeyword => this.whereKeyword;
    public ExpressionSyntax Condition => this.condition;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.whereKeyword,
            1 => this.condition,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.WhereClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWhereClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWhereClause(this);

    public WhereClauseSyntax Update(SyntaxToken whereKeyword, ExpressionSyntax condition)
    {
        if (whereKeyword != this.WhereKeyword || condition != this.Condition)
        {
            var newNode = SyntaxFactory.WhereClause(whereKeyword, condition);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new WhereClauseSyntax(this.Kind, this.whereKeyword, this.condition, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new WhereClauseSyntax(this.Kind, this.whereKeyword, this.condition, GetDiagnostics(), annotations);
}

internal sealed partial class OrderByClauseSyntax : QueryClauseSyntax
{
    internal readonly SyntaxToken orderByKeyword;
    internal readonly GreenNode? orderings;

    internal OrderByClauseSyntax(SyntaxKind kind, SyntaxToken orderByKeyword, GreenNode? orderings, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(orderByKeyword);
        this.orderByKeyword = orderByKeyword;
        if (orderings != null)
        {
            this.AdjustFlagsAndWidth(orderings);
            this.orderings = orderings;
        }
    }

    internal OrderByClauseSyntax(SyntaxKind kind, SyntaxToken orderByKeyword, GreenNode? orderings, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(orderByKeyword);
        this.orderByKeyword = orderByKeyword;
        if (orderings != null)
        {
            this.AdjustFlagsAndWidth(orderings);
            this.orderings = orderings;
        }
    }

    internal OrderByClauseSyntax(SyntaxKind kind, SyntaxToken orderByKeyword, GreenNode? orderings)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(orderByKeyword);
        this.orderByKeyword = orderByKeyword;
        if (orderings != null)
        {
            this.AdjustFlagsAndWidth(orderings);
            this.orderings = orderings;
        }
    }

    public SyntaxToken OrderByKeyword => this.orderByKeyword;
    public CoreSyntax.SeparatedSyntaxList<OrderingSyntax> Orderings => new CoreSyntax.SeparatedSyntaxList<OrderingSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.orderings));

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.orderByKeyword,
            1 => this.orderings,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.OrderByClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOrderByClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOrderByClause(this);

    public OrderByClauseSyntax Update(SyntaxToken orderByKeyword, CoreSyntax.SeparatedSyntaxList<OrderingSyntax> orderings)
    {
        if (orderByKeyword != this.OrderByKeyword || orderings != this.Orderings)
        {
            var newNode = SyntaxFactory.OrderByClause(orderByKeyword, orderings);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new OrderByClauseSyntax(this.Kind, this.orderByKeyword, this.orderings, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new OrderByClauseSyntax(this.Kind, this.orderByKeyword, this.orderings, GetDiagnostics(), annotations);
}

internal sealed partial class OrderingSyntax : CSharpSyntaxNode
{
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken? ascendingOrDescendingKeyword;

    internal OrderingSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken? ascendingOrDescendingKeyword, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (ascendingOrDescendingKeyword != null)
        {
            this.AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
            this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
        }
    }

    internal OrderingSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken? ascendingOrDescendingKeyword, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (ascendingOrDescendingKeyword != null)
        {
            this.AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
            this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
        }
    }

    internal OrderingSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken? ascendingOrDescendingKeyword)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (ascendingOrDescendingKeyword != null)
        {
            this.AdjustFlagsAndWidth(ascendingOrDescendingKeyword);
            this.ascendingOrDescendingKeyword = ascendingOrDescendingKeyword;
        }
    }

    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken? AscendingOrDescendingKeyword => this.ascendingOrDescendingKeyword;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.ascendingOrDescendingKeyword,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.OrderingSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOrdering(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOrdering(this);

    public OrderingSyntax Update(ExpressionSyntax expression, SyntaxToken ascendingOrDescendingKeyword)
    {
        if (expression != this.Expression || ascendingOrDescendingKeyword != this.AscendingOrDescendingKeyword)
        {
            var newNode = SyntaxFactory.Ordering(this.Kind, expression, ascendingOrDescendingKeyword);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new OrderingSyntax(this.Kind, this.expression, this.ascendingOrDescendingKeyword, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new OrderingSyntax(this.Kind, this.expression, this.ascendingOrDescendingKeyword, GetDiagnostics(), annotations);
}

internal sealed partial class SelectClauseSyntax : SelectOrGroupClauseSyntax
{
    internal readonly SyntaxToken selectKeyword;
    internal readonly ExpressionSyntax expression;

    internal SelectClauseSyntax(SyntaxKind kind, SyntaxToken selectKeyword, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(selectKeyword);
        this.selectKeyword = selectKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal SelectClauseSyntax(SyntaxKind kind, SyntaxToken selectKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(selectKeyword);
        this.selectKeyword = selectKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal SelectClauseSyntax(SyntaxKind kind, SyntaxToken selectKeyword, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(selectKeyword);
        this.selectKeyword = selectKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken SelectKeyword => this.selectKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.selectKeyword,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SelectClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSelectClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSelectClause(this);

    public SelectClauseSyntax Update(SyntaxToken selectKeyword, ExpressionSyntax expression)
    {
        if (selectKeyword != this.SelectKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.SelectClause(selectKeyword, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SelectClauseSyntax(this.Kind, this.selectKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SelectClauseSyntax(this.Kind, this.selectKeyword, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class GroupClauseSyntax : SelectOrGroupClauseSyntax
{
    internal readonly SyntaxToken groupKeyword;
    internal readonly ExpressionSyntax groupExpression;
    internal readonly SyntaxToken byKeyword;
    internal readonly ExpressionSyntax byExpression;

    internal GroupClauseSyntax(SyntaxKind kind, SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(groupKeyword);
        this.groupKeyword = groupKeyword;
        this.AdjustFlagsAndWidth(groupExpression);
        this.groupExpression = groupExpression;
        this.AdjustFlagsAndWidth(byKeyword);
        this.byKeyword = byKeyword;
        this.AdjustFlagsAndWidth(byExpression);
        this.byExpression = byExpression;
    }

    internal GroupClauseSyntax(SyntaxKind kind, SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(groupKeyword);
        this.groupKeyword = groupKeyword;
        this.AdjustFlagsAndWidth(groupExpression);
        this.groupExpression = groupExpression;
        this.AdjustFlagsAndWidth(byKeyword);
        this.byKeyword = byKeyword;
        this.AdjustFlagsAndWidth(byExpression);
        this.byExpression = byExpression;
    }

    internal GroupClauseSyntax(SyntaxKind kind, SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(groupKeyword);
        this.groupKeyword = groupKeyword;
        this.AdjustFlagsAndWidth(groupExpression);
        this.groupExpression = groupExpression;
        this.AdjustFlagsAndWidth(byKeyword);
        this.byKeyword = byKeyword;
        this.AdjustFlagsAndWidth(byExpression);
        this.byExpression = byExpression;
    }

    public SyntaxToken GroupKeyword => this.groupKeyword;
    public ExpressionSyntax GroupExpression => this.groupExpression;
    public SyntaxToken ByKeyword => this.byKeyword;
    public ExpressionSyntax ByExpression => this.byExpression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.groupKeyword,
            1 => this.groupExpression,
            2 => this.byKeyword,
            3 => this.byExpression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.GroupClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGroupClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGroupClause(this);

    public GroupClauseSyntax Update(SyntaxToken groupKeyword, ExpressionSyntax groupExpression, SyntaxToken byKeyword, ExpressionSyntax byExpression)
    {
        if (groupKeyword != this.GroupKeyword || groupExpression != this.GroupExpression || byKeyword != this.ByKeyword || byExpression != this.ByExpression)
        {
            var newNode = SyntaxFactory.GroupClause(groupKeyword, groupExpression, byKeyword, byExpression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new GroupClauseSyntax(this.Kind, this.groupKeyword, this.groupExpression, this.byKeyword, this.byExpression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new GroupClauseSyntax(this.Kind, this.groupKeyword, this.groupExpression, this.byKeyword, this.byExpression, GetDiagnostics(), annotations);
}

internal sealed partial class QueryContinuationSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken intoKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly QueryBodySyntax body;

    internal QueryContinuationSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    internal QueryContinuationSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    internal QueryContinuationSyntax(SyntaxKind kind, SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(intoKeyword);
        this.intoKeyword = intoKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(body);
        this.body = body;
    }

    public SyntaxToken IntoKeyword => this.intoKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public QueryBodySyntax Body => this.body;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.intoKeyword,
            1 => this.identifier,
            2 => this.body,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.QueryContinuationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQueryContinuation(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQueryContinuation(this);

    public QueryContinuationSyntax Update(SyntaxToken intoKeyword, SyntaxToken identifier, QueryBodySyntax body)
    {
        if (intoKeyword != this.IntoKeyword || identifier != this.Identifier || body != this.Body)
        {
            var newNode = SyntaxFactory.QueryContinuation(intoKeyword, identifier, body);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new QueryContinuationSyntax(this.Kind, this.intoKeyword, this.identifier, this.body, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new QueryContinuationSyntax(this.Kind, this.intoKeyword, this.identifier, this.body, GetDiagnostics(), annotations);
}

/// <summary>Class which represents a placeholder in an array size list.</summary>
internal sealed partial class OmittedArraySizeExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken omittedArraySizeExpressionToken;

    internal OmittedArraySizeExpressionSyntax(SyntaxKind kind, SyntaxToken omittedArraySizeExpressionToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
        this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
    }

    internal OmittedArraySizeExpressionSyntax(SyntaxKind kind, SyntaxToken omittedArraySizeExpressionToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
        this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
    }

    internal OmittedArraySizeExpressionSyntax(SyntaxKind kind, SyntaxToken omittedArraySizeExpressionToken)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(omittedArraySizeExpressionToken);
        this.omittedArraySizeExpressionToken = omittedArraySizeExpressionToken;
    }

    /// <summary>SyntaxToken representing the omitted array size expression.</summary>
    public SyntaxToken OmittedArraySizeExpressionToken => this.omittedArraySizeExpressionToken;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.omittedArraySizeExpressionToken : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.OmittedArraySizeExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOmittedArraySizeExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOmittedArraySizeExpression(this);

    public OmittedArraySizeExpressionSyntax Update(SyntaxToken omittedArraySizeExpressionToken)
    {
        if (omittedArraySizeExpressionToken != this.OmittedArraySizeExpressionToken)
        {
            var newNode = SyntaxFactory.OmittedArraySizeExpression(omittedArraySizeExpressionToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new OmittedArraySizeExpressionSyntax(this.Kind, this.omittedArraySizeExpressionToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new OmittedArraySizeExpressionSyntax(this.Kind, this.omittedArraySizeExpressionToken, GetDiagnostics(), annotations);
}

internal sealed partial class InterpolatedStringExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken stringStartToken;
    internal readonly GreenNode? contents;
    internal readonly SyntaxToken stringEndToken;

    internal InterpolatedStringExpressionSyntax(SyntaxKind kind, SyntaxToken stringStartToken, GreenNode? contents, SyntaxToken stringEndToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stringStartToken);
        this.stringStartToken = stringStartToken;
        if (contents != null)
        {
            this.AdjustFlagsAndWidth(contents);
            this.contents = contents;
        }
        this.AdjustFlagsAndWidth(stringEndToken);
        this.stringEndToken = stringEndToken;
    }

    internal InterpolatedStringExpressionSyntax(SyntaxKind kind, SyntaxToken stringStartToken, GreenNode? contents, SyntaxToken stringEndToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stringStartToken);
        this.stringStartToken = stringStartToken;
        if (contents != null)
        {
            this.AdjustFlagsAndWidth(contents);
            this.contents = contents;
        }
        this.AdjustFlagsAndWidth(stringEndToken);
        this.stringEndToken = stringEndToken;
    }

    internal InterpolatedStringExpressionSyntax(SyntaxKind kind, SyntaxToken stringStartToken, GreenNode? contents, SyntaxToken stringEndToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(stringStartToken);
        this.stringStartToken = stringStartToken;
        if (contents != null)
        {
            this.AdjustFlagsAndWidth(contents);
            this.contents = contents;
        }
        this.AdjustFlagsAndWidth(stringEndToken);
        this.stringEndToken = stringEndToken;
    }

    /// <summary>The first part of an interpolated string, <c>$"</c> or <c>$@"</c> or <c>$"""</c></summary>
    public SyntaxToken StringStartToken => this.stringStartToken;
    /// <summary>List of parts of the interpolated string, each one is either a literal part or an interpolation.</summary>
    public CoreSyntax.SyntaxList<InterpolatedStringContentSyntax> Contents => new CoreSyntax.SyntaxList<InterpolatedStringContentSyntax>(this.contents);
    /// <summary>The closing quote of the interpolated string.</summary>
    public SyntaxToken StringEndToken => this.stringEndToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.stringStartToken,
            1 => this.contents,
            2 => this.stringEndToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InterpolatedStringExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolatedStringExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolatedStringExpression(this);

    public InterpolatedStringExpressionSyntax Update(SyntaxToken stringStartToken, CoreSyntax.SyntaxList<InterpolatedStringContentSyntax> contents, SyntaxToken stringEndToken)
    {
        if (stringStartToken != this.StringStartToken || contents != this.Contents || stringEndToken != this.StringEndToken)
        {
            var newNode = SyntaxFactory.InterpolatedStringExpression(stringStartToken, contents, stringEndToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InterpolatedStringExpressionSyntax(this.Kind, this.stringStartToken, this.contents, this.stringEndToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InterpolatedStringExpressionSyntax(this.Kind, this.stringStartToken, this.contents, this.stringEndToken, GetDiagnostics(), annotations);
}

/// <summary>Class which represents a simple pattern-matching expression using the "is" keyword.</summary>
internal sealed partial class IsPatternExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken isKeyword;
    internal readonly PatternSyntax pattern;

    internal IsPatternExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(isKeyword);
        this.isKeyword = isKeyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    internal IsPatternExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(isKeyword);
        this.isKeyword = isKeyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    internal IsPatternExpressionSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(isKeyword);
        this.isKeyword = isKeyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    /// <summary>ExpressionSyntax node representing the expression on the left of the "is" operator.</summary>
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken IsKeyword => this.isKeyword;
    /// <summary>PatternSyntax node representing the pattern on the right of the "is" operator.</summary>
    public PatternSyntax Pattern => this.pattern;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expression,
            1 => this.isKeyword,
            2 => this.pattern,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.IsPatternExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIsPatternExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIsPatternExpression(this);

    public IsPatternExpressionSyntax Update(ExpressionSyntax expression, SyntaxToken isKeyword, PatternSyntax pattern)
    {
        if (expression != this.Expression || isKeyword != this.IsKeyword || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.IsPatternExpression(expression, isKeyword, pattern);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new IsPatternExpressionSyntax(this.Kind, this.expression, this.isKeyword, this.pattern, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new IsPatternExpressionSyntax(this.Kind, this.expression, this.isKeyword, this.pattern, GetDiagnostics(), annotations);
}

internal sealed partial class ThrowExpressionSyntax : ExpressionSyntax
{
    internal readonly SyntaxToken throwKeyword;
    internal readonly ExpressionSyntax expression;

    internal ThrowExpressionSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ThrowExpressionSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ThrowExpressionSyntax(SyntaxKind kind, SyntaxToken throwKeyword, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken ThrowKeyword => this.throwKeyword;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.throwKeyword,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ThrowExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitThrowExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitThrowExpression(this);

    public ThrowExpressionSyntax Update(SyntaxToken throwKeyword, ExpressionSyntax expression)
    {
        if (throwKeyword != this.ThrowKeyword || expression != this.Expression)
        {
            var newNode = SyntaxFactory.ThrowExpression(throwKeyword, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ThrowExpressionSyntax(this.Kind, this.throwKeyword, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ThrowExpressionSyntax(this.Kind, this.throwKeyword, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class WhenClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken whenKeyword;
    internal readonly ExpressionSyntax condition;

    internal WhenClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, ExpressionSyntax condition, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    internal WhenClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, ExpressionSyntax condition, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    internal WhenClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, ExpressionSyntax condition)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
    }

    public SyntaxToken WhenKeyword => this.whenKeyword;
    public ExpressionSyntax Condition => this.condition;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.whenKeyword,
            1 => this.condition,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.WhenClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWhenClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWhenClause(this);

    public WhenClauseSyntax Update(SyntaxToken whenKeyword, ExpressionSyntax condition)
    {
        if (whenKeyword != this.WhenKeyword || condition != this.Condition)
        {
            var newNode = SyntaxFactory.WhenClause(whenKeyword, condition);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new WhenClauseSyntax(this.Kind, this.whenKeyword, this.condition, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new WhenClauseSyntax(this.Kind, this.whenKeyword, this.condition, GetDiagnostics(), annotations);
}

internal abstract partial class PatternSyntax : ExpressionOrPatternSyntax
{
    internal PatternSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal PatternSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

internal sealed partial class DiscardPatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken underscoreToken;

    internal DiscardPatternSyntax(SyntaxKind kind, SyntaxToken underscoreToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    internal DiscardPatternSyntax(SyntaxKind kind, SyntaxToken underscoreToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    internal DiscardPatternSyntax(SyntaxKind kind, SyntaxToken underscoreToken)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    public SyntaxToken UnderscoreToken => this.underscoreToken;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.underscoreToken : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DiscardPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDiscardPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDiscardPattern(this);

    public DiscardPatternSyntax Update(SyntaxToken underscoreToken)
    {
        if (underscoreToken != this.UnderscoreToken)
        {
            var newNode = SyntaxFactory.DiscardPattern(underscoreToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DiscardPatternSyntax(this.Kind, this.underscoreToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DiscardPatternSyntax(this.Kind, this.underscoreToken, GetDiagnostics(), annotations);
}

internal sealed partial class DeclarationPatternSyntax : PatternSyntax
{
    internal readonly TypeSyntax type;
    internal readonly VariableDesignationSyntax designation;

    internal DeclarationPatternSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    internal DeclarationPatternSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    internal DeclarationPatternSyntax(SyntaxKind kind, TypeSyntax type, VariableDesignationSyntax designation)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    public TypeSyntax Type => this.type;
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.type,
            1 => this.designation,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DeclarationPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDeclarationPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDeclarationPattern(this);

    public DeclarationPatternSyntax Update(TypeSyntax type, VariableDesignationSyntax designation)
    {
        if (type != this.Type || designation != this.Designation)
        {
            var newNode = SyntaxFactory.DeclarationPattern(type, designation);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DeclarationPatternSyntax(this.Kind, this.type, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DeclarationPatternSyntax(this.Kind, this.type, this.designation, GetDiagnostics(), annotations);
}

internal sealed partial class VarPatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken varKeyword;
    internal readonly VariableDesignationSyntax designation;

    internal VarPatternSyntax(SyntaxKind kind, SyntaxToken varKeyword, VariableDesignationSyntax designation, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(varKeyword);
        this.varKeyword = varKeyword;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    internal VarPatternSyntax(SyntaxKind kind, SyntaxToken varKeyword, VariableDesignationSyntax designation, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(varKeyword);
        this.varKeyword = varKeyword;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    internal VarPatternSyntax(SyntaxKind kind, SyntaxToken varKeyword, VariableDesignationSyntax designation)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(varKeyword);
        this.varKeyword = varKeyword;
        this.AdjustFlagsAndWidth(designation);
        this.designation = designation;
    }

    public SyntaxToken VarKeyword => this.varKeyword;
    public VariableDesignationSyntax Designation => this.designation;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.varKeyword,
            1 => this.designation,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.VarPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitVarPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitVarPattern(this);

    public VarPatternSyntax Update(SyntaxToken varKeyword, VariableDesignationSyntax designation)
    {
        if (varKeyword != this.VarKeyword || designation != this.Designation)
        {
            var newNode = SyntaxFactory.VarPattern(varKeyword, designation);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new VarPatternSyntax(this.Kind, this.varKeyword, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new VarPatternSyntax(this.Kind, this.varKeyword, this.designation, GetDiagnostics(), annotations);
}

internal sealed partial class RecursivePatternSyntax : PatternSyntax
{
    internal readonly TypeSyntax? type;
    internal readonly PositionalPatternClauseSyntax? positionalPatternClause;
    internal readonly PropertyPatternClauseSyntax? propertyPatternClause;
    internal readonly VariableDesignationSyntax? designation;

    internal RecursivePatternSyntax(SyntaxKind kind, TypeSyntax? type, PositionalPatternClauseSyntax? positionalPatternClause, PropertyPatternClauseSyntax? propertyPatternClause, VariableDesignationSyntax? designation, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        if (positionalPatternClause != null)
        {
            this.AdjustFlagsAndWidth(positionalPatternClause);
            this.positionalPatternClause = positionalPatternClause;
        }
        if (propertyPatternClause != null)
        {
            this.AdjustFlagsAndWidth(propertyPatternClause);
            this.propertyPatternClause = propertyPatternClause;
        }
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    internal RecursivePatternSyntax(SyntaxKind kind, TypeSyntax? type, PositionalPatternClauseSyntax? positionalPatternClause, PropertyPatternClauseSyntax? propertyPatternClause, VariableDesignationSyntax? designation, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        if (positionalPatternClause != null)
        {
            this.AdjustFlagsAndWidth(positionalPatternClause);
            this.positionalPatternClause = positionalPatternClause;
        }
        if (propertyPatternClause != null)
        {
            this.AdjustFlagsAndWidth(propertyPatternClause);
            this.propertyPatternClause = propertyPatternClause;
        }
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    internal RecursivePatternSyntax(SyntaxKind kind, TypeSyntax? type, PositionalPatternClauseSyntax? positionalPatternClause, PropertyPatternClauseSyntax? propertyPatternClause, VariableDesignationSyntax? designation)
      : base(kind)
    {
        this.SlotCount = 4;
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        if (positionalPatternClause != null)
        {
            this.AdjustFlagsAndWidth(positionalPatternClause);
            this.positionalPatternClause = positionalPatternClause;
        }
        if (propertyPatternClause != null)
        {
            this.AdjustFlagsAndWidth(propertyPatternClause);
            this.propertyPatternClause = propertyPatternClause;
        }
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    public TypeSyntax? Type => this.type;
    public PositionalPatternClauseSyntax? PositionalPatternClause => this.positionalPatternClause;
    public PropertyPatternClauseSyntax? PropertyPatternClause => this.propertyPatternClause;
    public VariableDesignationSyntax? Designation => this.designation;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.type,
            1 => this.positionalPatternClause,
            2 => this.propertyPatternClause,
            3 => this.designation,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RecursivePatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRecursivePattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRecursivePattern(this);

    public RecursivePatternSyntax Update(TypeSyntax type, PositionalPatternClauseSyntax positionalPatternClause, PropertyPatternClauseSyntax propertyPatternClause, VariableDesignationSyntax designation)
    {
        if (type != this.Type || positionalPatternClause != this.PositionalPatternClause || propertyPatternClause != this.PropertyPatternClause || designation != this.Designation)
        {
            var newNode = SyntaxFactory.RecursivePattern(type, positionalPatternClause, propertyPatternClause, designation);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RecursivePatternSyntax(this.Kind, this.type, this.positionalPatternClause, this.propertyPatternClause, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RecursivePatternSyntax(this.Kind, this.type, this.positionalPatternClause, this.propertyPatternClause, this.designation, GetDiagnostics(), annotations);
}

internal sealed partial class PositionalPatternClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? subpatterns;
    internal readonly SyntaxToken closeParenToken;

    internal PositionalPatternClauseSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? subpatterns, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal PositionalPatternClauseSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? subpatterns, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal PositionalPatternClauseSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? subpatterns, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public CoreSyntax.SeparatedSyntaxList<SubpatternSyntax> Subpatterns => new CoreSyntax.SeparatedSyntaxList<SubpatternSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.subpatterns));
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.subpatterns,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PositionalPatternClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPositionalPatternClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPositionalPatternClause(this);

    public PositionalPatternClauseSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<SubpatternSyntax> subpatterns, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || subpatterns != this.Subpatterns || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.PositionalPatternClause(openParenToken, subpatterns, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PositionalPatternClauseSyntax(this.Kind, this.openParenToken, this.subpatterns, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PositionalPatternClauseSyntax(this.Kind, this.openParenToken, this.subpatterns, this.closeParenToken, GetDiagnostics(), annotations);
}

internal sealed partial class PropertyPatternClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? subpatterns;
    internal readonly SyntaxToken closeBraceToken;

    internal PropertyPatternClauseSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? subpatterns, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal PropertyPatternClauseSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? subpatterns, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal PropertyPatternClauseSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? subpatterns, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (subpatterns != null)
        {
            this.AdjustFlagsAndWidth(subpatterns);
            this.subpatterns = subpatterns;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public CoreSyntax.SeparatedSyntaxList<SubpatternSyntax> Subpatterns => new CoreSyntax.SeparatedSyntaxList<SubpatternSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.subpatterns));
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBraceToken,
            1 => this.subpatterns,
            2 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PropertyPatternClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPropertyPatternClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPropertyPatternClause(this);

    public PropertyPatternClauseSyntax Update(SyntaxToken openBraceToken, CoreSyntax.SeparatedSyntaxList<SubpatternSyntax> subpatterns, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || subpatterns != this.Subpatterns || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.PropertyPatternClause(openBraceToken, subpatterns, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PropertyPatternClauseSyntax(this.Kind, this.openBraceToken, this.subpatterns, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PropertyPatternClauseSyntax(this.Kind, this.openBraceToken, this.subpatterns, this.closeBraceToken, GetDiagnostics(), annotations);
}

internal sealed partial class SubpatternSyntax : CSharpSyntaxNode
{
    internal readonly BaseExpressionColonSyntax? expressionColon;
    internal readonly PatternSyntax pattern;

    internal SubpatternSyntax(SyntaxKind kind, BaseExpressionColonSyntax? expressionColon, PatternSyntax pattern, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (expressionColon != null)
        {
            this.AdjustFlagsAndWidth(expressionColon);
            this.expressionColon = expressionColon;
        }
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    internal SubpatternSyntax(SyntaxKind kind, BaseExpressionColonSyntax? expressionColon, PatternSyntax pattern, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (expressionColon != null)
        {
            this.AdjustFlagsAndWidth(expressionColon);
            this.expressionColon = expressionColon;
        }
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    internal SubpatternSyntax(SyntaxKind kind, BaseExpressionColonSyntax? expressionColon, PatternSyntax pattern)
      : base(kind)
    {
        this.SlotCount = 2;
        if (expressionColon != null)
        {
            this.AdjustFlagsAndWidth(expressionColon);
            this.expressionColon = expressionColon;
        }
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    public BaseExpressionColonSyntax? ExpressionColon => this.expressionColon;
    public PatternSyntax Pattern => this.pattern;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.expressionColon,
            1 => this.pattern,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SubpatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSubpattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSubpattern(this);

    public SubpatternSyntax Update(BaseExpressionColonSyntax expressionColon, PatternSyntax pattern)
    {
        if (expressionColon != this.ExpressionColon || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.Subpattern(expressionColon, pattern);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SubpatternSyntax(this.Kind, this.expressionColon, this.pattern, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SubpatternSyntax(this.Kind, this.expressionColon, this.pattern, GetDiagnostics(), annotations);
}

internal sealed partial class ConstantPatternSyntax : PatternSyntax
{
    internal readonly ExpressionSyntax expression;

    internal ConstantPatternSyntax(SyntaxKind kind, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ConstantPatternSyntax(SyntaxKind kind, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ConstantPatternSyntax(SyntaxKind kind, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>ExpressionSyntax node representing the constant expression.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.expression : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConstantPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstantPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstantPattern(this);

    public ConstantPatternSyntax Update(ExpressionSyntax expression)
    {
        if (expression != this.Expression)
        {
            var newNode = SyntaxFactory.ConstantPattern(expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConstantPatternSyntax(this.Kind, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConstantPatternSyntax(this.Kind, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class ParenthesizedPatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly PatternSyntax pattern;
    internal readonly SyntaxToken closeParenToken;

    internal ParenthesizedPatternSyntax(SyntaxKind kind, SyntaxToken openParenToken, PatternSyntax pattern, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParenthesizedPatternSyntax(SyntaxKind kind, SyntaxToken openParenToken, PatternSyntax pattern, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParenthesizedPatternSyntax(SyntaxKind kind, SyntaxToken openParenToken, PatternSyntax pattern, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public PatternSyntax Pattern => this.pattern;
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.pattern,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ParenthesizedPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedPattern(this);

    public ParenthesizedPatternSyntax Update(SyntaxToken openParenToken, PatternSyntax pattern, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || pattern != this.Pattern || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedPattern(openParenToken, pattern, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ParenthesizedPatternSyntax(this.Kind, this.openParenToken, this.pattern, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ParenthesizedPatternSyntax(this.Kind, this.openParenToken, this.pattern, this.closeParenToken, GetDiagnostics(), annotations);
}

internal sealed partial class RelationalPatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken operatorToken;
    internal readonly ExpressionSyntax expression;

    internal RelationalPatternSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal RelationalPatternSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal RelationalPatternSyntax(SyntaxKind kind, SyntaxToken operatorToken, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    /// <summary>SyntaxToken representing the operator of the relational pattern.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operatorToken,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RelationalPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRelationalPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRelationalPattern(this);

    public RelationalPatternSyntax Update(SyntaxToken operatorToken, ExpressionSyntax expression)
    {
        if (operatorToken != this.OperatorToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.RelationalPattern(operatorToken, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RelationalPatternSyntax(this.Kind, this.operatorToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RelationalPatternSyntax(this.Kind, this.operatorToken, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class TypePatternSyntax : PatternSyntax
{
    internal readonly TypeSyntax type;

    internal TypePatternSyntax(SyntaxKind kind, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal TypePatternSyntax(SyntaxKind kind, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal TypePatternSyntax(SyntaxKind kind, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    /// <summary>The type for the type pattern.</summary>
    public TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.type : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypePatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypePattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypePattern(this);

    public TypePatternSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.TypePattern(type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypePatternSyntax(this.Kind, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypePatternSyntax(this.Kind, this.type, GetDiagnostics(), annotations);
}

internal sealed partial class BinaryPatternSyntax : PatternSyntax
{
    internal readonly PatternSyntax left;
    internal readonly SyntaxToken operatorToken;
    internal readonly PatternSyntax right;

    internal BinaryPatternSyntax(SyntaxKind kind, PatternSyntax left, SyntaxToken operatorToken, PatternSyntax right, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal BinaryPatternSyntax(SyntaxKind kind, PatternSyntax left, SyntaxToken operatorToken, PatternSyntax right, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    internal BinaryPatternSyntax(SyntaxKind kind, PatternSyntax left, SyntaxToken operatorToken, PatternSyntax right)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(left);
        this.left = left;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(right);
        this.right = right;
    }

    public PatternSyntax Left => this.left;
    public SyntaxToken OperatorToken => this.operatorToken;
    public PatternSyntax Right => this.right;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.left,
            1 => this.operatorToken,
            2 => this.right,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BinaryPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBinaryPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBinaryPattern(this);

    public BinaryPatternSyntax Update(PatternSyntax left, SyntaxToken operatorToken, PatternSyntax right)
    {
        if (left != this.Left || operatorToken != this.OperatorToken || right != this.Right)
        {
            var newNode = SyntaxFactory.BinaryPattern(this.Kind, left, operatorToken, right);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BinaryPatternSyntax(this.Kind, this.left, this.operatorToken, this.right, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BinaryPatternSyntax(this.Kind, this.left, this.operatorToken, this.right, GetDiagnostics(), annotations);
}

internal sealed partial class UnaryPatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken operatorToken;
    internal readonly PatternSyntax pattern;

    internal UnaryPatternSyntax(SyntaxKind kind, SyntaxToken operatorToken, PatternSyntax pattern, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    internal UnaryPatternSyntax(SyntaxKind kind, SyntaxToken operatorToken, PatternSyntax pattern, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    internal UnaryPatternSyntax(SyntaxKind kind, SyntaxToken operatorToken, PatternSyntax pattern)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
    }

    public SyntaxToken OperatorToken => this.operatorToken;
    public PatternSyntax Pattern => this.pattern;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operatorToken,
            1 => this.pattern,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.UnaryPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUnaryPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUnaryPattern(this);

    public UnaryPatternSyntax Update(SyntaxToken operatorToken, PatternSyntax pattern)
    {
        if (operatorToken != this.OperatorToken || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.UnaryPattern(operatorToken, pattern);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new UnaryPatternSyntax(this.Kind, this.operatorToken, this.pattern, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new UnaryPatternSyntax(this.Kind, this.operatorToken, this.pattern, GetDiagnostics(), annotations);
}

internal sealed partial class ListPatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? patterns;
    internal readonly SyntaxToken closeBracketToken;
    internal readonly VariableDesignationSyntax? designation;

    internal ListPatternSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? patterns, SyntaxToken closeBracketToken, VariableDesignationSyntax? designation, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (patterns != null)
        {
            this.AdjustFlagsAndWidth(patterns);
            this.patterns = patterns;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    internal ListPatternSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? patterns, SyntaxToken closeBracketToken, VariableDesignationSyntax? designation, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (patterns != null)
        {
            this.AdjustFlagsAndWidth(patterns);
            this.patterns = patterns;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    internal ListPatternSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? patterns, SyntaxToken closeBracketToken, VariableDesignationSyntax? designation)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (patterns != null)
        {
            this.AdjustFlagsAndWidth(patterns);
            this.patterns = patterns;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
        if (designation != null)
        {
            this.AdjustFlagsAndWidth(designation);
            this.designation = designation;
        }
    }

    public SyntaxToken OpenBracketToken => this.openBracketToken;
    public CoreSyntax.SeparatedSyntaxList<PatternSyntax> Patterns => new CoreSyntax.SeparatedSyntaxList<PatternSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.patterns));
    public SyntaxToken CloseBracketToken => this.closeBracketToken;
    public VariableDesignationSyntax? Designation => this.designation;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.patterns,
            2 => this.closeBracketToken,
            3 => this.designation,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ListPatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitListPattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitListPattern(this);

    public ListPatternSyntax Update(SyntaxToken openBracketToken, CoreSyntax.SeparatedSyntaxList<PatternSyntax> patterns, SyntaxToken closeBracketToken, VariableDesignationSyntax designation)
    {
        if (openBracketToken != this.OpenBracketToken || patterns != this.Patterns || closeBracketToken != this.CloseBracketToken || designation != this.Designation)
        {
            var newNode = SyntaxFactory.ListPattern(openBracketToken, patterns, closeBracketToken, designation);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ListPatternSyntax(this.Kind, this.openBracketToken, this.patterns, this.closeBracketToken, this.designation, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ListPatternSyntax(this.Kind, this.openBracketToken, this.patterns, this.closeBracketToken, this.designation, GetDiagnostics(), annotations);
}

internal sealed partial class SlicePatternSyntax : PatternSyntax
{
    internal readonly SyntaxToken dotDotToken;
    internal readonly PatternSyntax? pattern;

    internal SlicePatternSyntax(SyntaxKind kind, SyntaxToken dotDotToken, PatternSyntax? pattern, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(dotDotToken);
        this.dotDotToken = dotDotToken;
        if (pattern != null)
        {
            this.AdjustFlagsAndWidth(pattern);
            this.pattern = pattern;
        }
    }

    internal SlicePatternSyntax(SyntaxKind kind, SyntaxToken dotDotToken, PatternSyntax? pattern, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(dotDotToken);
        this.dotDotToken = dotDotToken;
        if (pattern != null)
        {
            this.AdjustFlagsAndWidth(pattern);
            this.pattern = pattern;
        }
    }

    internal SlicePatternSyntax(SyntaxKind kind, SyntaxToken dotDotToken, PatternSyntax? pattern)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(dotDotToken);
        this.dotDotToken = dotDotToken;
        if (pattern != null)
        {
            this.AdjustFlagsAndWidth(pattern);
            this.pattern = pattern;
        }
    }

    public SyntaxToken DotDotToken => this.dotDotToken;
    public PatternSyntax? Pattern => this.pattern;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.dotDotToken,
            1 => this.pattern,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SlicePatternSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSlicePattern(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSlicePattern(this);

    public SlicePatternSyntax Update(SyntaxToken dotDotToken, PatternSyntax pattern)
    {
        if (dotDotToken != this.DotDotToken || pattern != this.Pattern)
        {
            var newNode = SyntaxFactory.SlicePattern(dotDotToken, pattern);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SlicePatternSyntax(this.Kind, this.dotDotToken, this.pattern, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SlicePatternSyntax(this.Kind, this.dotDotToken, this.pattern, GetDiagnostics(), annotations);
}

internal abstract partial class InterpolatedStringContentSyntax : CSharpSyntaxNode
{
    internal InterpolatedStringContentSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal InterpolatedStringContentSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

internal sealed partial class InterpolatedStringTextSyntax : InterpolatedStringContentSyntax
{
    internal readonly SyntaxToken textToken;

    internal InterpolatedStringTextSyntax(SyntaxKind kind, SyntaxToken textToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(textToken);
        this.textToken = textToken;
    }

    internal InterpolatedStringTextSyntax(SyntaxKind kind, SyntaxToken textToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(textToken);
        this.textToken = textToken;
    }

    internal InterpolatedStringTextSyntax(SyntaxKind kind, SyntaxToken textToken)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(textToken);
        this.textToken = textToken;
    }

    /// <summary>The text contents of a part of the interpolated string.</summary>
    public SyntaxToken TextToken => this.textToken;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.textToken : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InterpolatedStringTextSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolatedStringText(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolatedStringText(this);

    public InterpolatedStringTextSyntax Update(SyntaxToken textToken)
    {
        if (textToken != this.TextToken)
        {
            var newNode = SyntaxFactory.InterpolatedStringText(textToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InterpolatedStringTextSyntax(this.Kind, this.textToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InterpolatedStringTextSyntax(this.Kind, this.textToken, GetDiagnostics(), annotations);
}

internal sealed partial class InterpolationSyntax : InterpolatedStringContentSyntax
{
    internal readonly SyntaxToken openBraceToken;
    internal readonly ExpressionSyntax expression;
    internal readonly InterpolationAlignmentClauseSyntax? alignmentClause;
    internal readonly InterpolationFormatClauseSyntax? formatClause;
    internal readonly SyntaxToken closeBraceToken;

    internal InterpolationSyntax(SyntaxKind kind, SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax? alignmentClause, InterpolationFormatClauseSyntax? formatClause, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (alignmentClause != null)
        {
            this.AdjustFlagsAndWidth(alignmentClause);
            this.alignmentClause = alignmentClause;
        }
        if (formatClause != null)
        {
            this.AdjustFlagsAndWidth(formatClause);
            this.formatClause = formatClause;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal InterpolationSyntax(SyntaxKind kind, SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax? alignmentClause, InterpolationFormatClauseSyntax? formatClause, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (alignmentClause != null)
        {
            this.AdjustFlagsAndWidth(alignmentClause);
            this.alignmentClause = alignmentClause;
        }
        if (formatClause != null)
        {
            this.AdjustFlagsAndWidth(formatClause);
            this.formatClause = formatClause;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal InterpolationSyntax(SyntaxKind kind, SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax? alignmentClause, InterpolationFormatClauseSyntax? formatClause, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (alignmentClause != null)
        {
            this.AdjustFlagsAndWidth(alignmentClause);
            this.alignmentClause = alignmentClause;
        }
        if (formatClause != null)
        {
            this.AdjustFlagsAndWidth(formatClause);
            this.formatClause = formatClause;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    /// <summary>This could be a single <c>{</c> or multiple in a row (in the case of an interpolation in a raw interpolated string).</summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public ExpressionSyntax Expression => this.expression;
    public InterpolationAlignmentClauseSyntax? AlignmentClause => this.alignmentClause;
    public InterpolationFormatClauseSyntax? FormatClause => this.formatClause;
    /// <summary>
    /// This could be a single <c>}</c> or multiple in a row (in the case of an interpolation in a raw interpolated string).
    /// </summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBraceToken,
            1 => this.expression,
            2 => this.alignmentClause,
            3 => this.formatClause,
            4 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InterpolationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolation(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolation(this);

    public InterpolationSyntax Update(SyntaxToken openBraceToken, ExpressionSyntax expression, InterpolationAlignmentClauseSyntax alignmentClause, InterpolationFormatClauseSyntax formatClause, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || expression != this.Expression || alignmentClause != this.AlignmentClause || formatClause != this.FormatClause || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.Interpolation(openBraceToken, expression, alignmentClause, formatClause, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InterpolationSyntax(this.Kind, this.openBraceToken, this.expression, this.alignmentClause, this.formatClause, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InterpolationSyntax(this.Kind, this.openBraceToken, this.expression, this.alignmentClause, this.formatClause, this.closeBraceToken, GetDiagnostics(), annotations);
}

internal sealed partial class InterpolationAlignmentClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken commaToken;
    internal readonly ExpressionSyntax value;

    internal InterpolationAlignmentClauseSyntax(SyntaxKind kind, SyntaxToken commaToken, ExpressionSyntax value, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(commaToken);
        this.commaToken = commaToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    internal InterpolationAlignmentClauseSyntax(SyntaxKind kind, SyntaxToken commaToken, ExpressionSyntax value, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(commaToken);
        this.commaToken = commaToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    internal InterpolationAlignmentClauseSyntax(SyntaxKind kind, SyntaxToken commaToken, ExpressionSyntax value)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(commaToken);
        this.commaToken = commaToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    public SyntaxToken CommaToken => this.commaToken;
    public ExpressionSyntax Value => this.value;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.commaToken,
            1 => this.value,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InterpolationAlignmentClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolationAlignmentClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolationAlignmentClause(this);

    public InterpolationAlignmentClauseSyntax Update(SyntaxToken commaToken, ExpressionSyntax value)
    {
        if (commaToken != this.CommaToken || value != this.Value)
        {
            var newNode = SyntaxFactory.InterpolationAlignmentClause(commaToken, value);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InterpolationAlignmentClauseSyntax(this.Kind, this.commaToken, this.value, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InterpolationAlignmentClauseSyntax(this.Kind, this.commaToken, this.value, GetDiagnostics(), annotations);
}

internal sealed partial class InterpolationFormatClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken colonToken;
    internal readonly SyntaxToken formatStringToken;

    internal InterpolationFormatClauseSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken formatStringToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(formatStringToken);
        this.formatStringToken = formatStringToken;
    }

    internal InterpolationFormatClauseSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken formatStringToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(formatStringToken);
        this.formatStringToken = formatStringToken;
    }

    internal InterpolationFormatClauseSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken formatStringToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(formatStringToken);
        this.formatStringToken = formatStringToken;
    }

    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>The text contents of the format specifier for an interpolation.</summary>
    public SyntaxToken FormatStringToken => this.formatStringToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.colonToken,
            1 => this.formatStringToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InterpolationFormatClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterpolationFormatClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterpolationFormatClause(this);

    public InterpolationFormatClauseSyntax Update(SyntaxToken colonToken, SyntaxToken formatStringToken)
    {
        if (colonToken != this.ColonToken || formatStringToken != this.FormatStringToken)
        {
            var newNode = SyntaxFactory.InterpolationFormatClause(colonToken, formatStringToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InterpolationFormatClauseSyntax(this.Kind, this.colonToken, this.formatStringToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InterpolationFormatClauseSyntax(this.Kind, this.colonToken, this.formatStringToken, GetDiagnostics(), annotations);
}

internal sealed partial class GlobalStatementSyntax : MemberDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly StatementSyntax statement;

    internal GlobalStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal GlobalStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal GlobalStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.GlobalStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGlobalStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGlobalStatement(this);

    public GlobalStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || statement != this.Statement)
        {
            var newNode = SyntaxFactory.GlobalStatement(attributeLists, modifiers, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new GlobalStatementSyntax(this.Kind, this.attributeLists, this.modifiers, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new GlobalStatementSyntax(this.Kind, this.attributeLists, this.modifiers, this.statement, GetDiagnostics(), annotations);
}

/// <summary>Represents the base class for all statements syntax classes.</summary>
internal abstract partial class StatementSyntax : CSharpSyntaxNode
{
    internal StatementSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal StatementSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists { get; }
}

internal sealed partial class BlockSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? statements;
    internal readonly SyntaxToken closeBraceToken;

    internal BlockSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken openBraceToken, GreenNode? statements, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal BlockSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken openBraceToken, GreenNode? statements, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal BlockSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken openBraceToken, GreenNode? statements, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public CoreSyntax.SyntaxList<StatementSyntax> Statements => new CoreSyntax.SyntaxList<StatementSyntax>(this.statements);
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.openBraceToken,
            2 => this.statements,
            3 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BlockSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBlock(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBlock(this);

    public BlockSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<StatementSyntax> statements, SyntaxToken closeBraceToken)
    {
        if (attributeLists != this.AttributeLists || openBraceToken != this.OpenBraceToken || statements != this.Statements || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.Block(attributeLists, openBraceToken, statements, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BlockSyntax(this.Kind, this.attributeLists, this.openBraceToken, this.statements, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BlockSyntax(this.Kind, this.attributeLists, this.openBraceToken, this.statements, this.closeBraceToken, GetDiagnostics(), annotations);
}

internal sealed partial class LocalFunctionStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax returnType;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax parameterList;
    internal readonly GreenNode? constraintClauses;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal LocalFunctionStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal LocalFunctionStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal LocalFunctionStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public TypeSyntax ReturnType => this.returnType;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    public ParameterListSyntax ParameterList => this.parameterList;
    public CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public BlockSyntax? Body => this.body;
    public ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.returnType,
            3 => this.identifier,
            4 => this.typeParameterList,
            5 => this.parameterList,
            6 => this.constraintClauses,
            7 => this.body,
            8 => this.expressionBody,
            9 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.LocalFunctionStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLocalFunctionStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLocalFunctionStatement(this);

    public LocalFunctionStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.LocalFunctionStatement(attributeLists, modifiers, returnType, identifier, typeParameterList, parameterList, constraintClauses, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new LocalFunctionStatementSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new LocalFunctionStatementSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class LocalDeclarationStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken? awaitKeyword;
    internal readonly SyntaxToken? usingKeyword;
    internal readonly GreenNode? modifiers;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken semicolonToken;

    internal LocalDeclarationStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken? usingKeyword, GreenNode? modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        if (usingKeyword != null)
        {
            this.AdjustFlagsAndWidth(usingKeyword);
            this.usingKeyword = usingKeyword;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal LocalDeclarationStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken? usingKeyword, GreenNode? modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        if (usingKeyword != null)
        {
            this.AdjustFlagsAndWidth(usingKeyword);
            this.usingKeyword = usingKeyword;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal LocalDeclarationStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken? usingKeyword, GreenNode? modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        if (usingKeyword != null)
        {
            this.AdjustFlagsAndWidth(usingKeyword);
            this.usingKeyword = usingKeyword;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken? AwaitKeyword => this.awaitKeyword;
    public SyntaxToken? UsingKeyword => this.usingKeyword;
    /// <summary>Gets the modifier list.</summary>
    public CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public VariableDeclarationSyntax Declaration => this.declaration;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.awaitKeyword,
            2 => this.usingKeyword,
            3 => this.modifiers,
            4 => this.declaration,
            5 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.LocalDeclarationStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLocalDeclarationStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLocalDeclarationStatement(this);

    public LocalDeclarationStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, CoreSyntax.SyntaxList<SyntaxToken> modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || awaitKeyword != this.AwaitKeyword || usingKeyword != this.UsingKeyword || modifiers != this.Modifiers || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.LocalDeclarationStatement(attributeLists, awaitKeyword, usingKeyword, modifiers, declaration, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new LocalDeclarationStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.usingKeyword, this.modifiers, this.declaration, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new LocalDeclarationStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.usingKeyword, this.modifiers, this.declaration, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class VariableDeclarationSyntax : CSharpSyntaxNode
{
    internal readonly TypeSyntax type;
    internal readonly GreenNode? variables;

    internal VariableDeclarationSyntax(SyntaxKind kind, TypeSyntax type, GreenNode? variables, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
    }

    internal VariableDeclarationSyntax(SyntaxKind kind, TypeSyntax type, GreenNode? variables, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
    }

    internal VariableDeclarationSyntax(SyntaxKind kind, TypeSyntax type, GreenNode? variables)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
    }

    public TypeSyntax Type => this.type;
    public CoreSyntax.SeparatedSyntaxList<VariableDeclaratorSyntax> Variables => new CoreSyntax.SeparatedSyntaxList<VariableDeclaratorSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.variables));

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.type,
            1 => this.variables,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.VariableDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitVariableDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitVariableDeclaration(this);

    public VariableDeclarationSyntax Update(TypeSyntax type, CoreSyntax.SeparatedSyntaxList<VariableDeclaratorSyntax> variables)
    {
        if (type != this.Type || variables != this.Variables)
        {
            var newNode = SyntaxFactory.VariableDeclaration(type, variables);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new VariableDeclarationSyntax(this.Kind, this.type, this.variables, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new VariableDeclarationSyntax(this.Kind, this.type, this.variables, GetDiagnostics(), annotations);
}

internal sealed partial class VariableDeclaratorSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken identifier;
    internal readonly BracketedArgumentListSyntax? argumentList;
    internal readonly EqualsValueClauseSyntax? initializer;

    internal VariableDeclaratorSyntax(SyntaxKind kind, SyntaxToken identifier, BracketedArgumentListSyntax? argumentList, EqualsValueClauseSyntax? initializer, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal VariableDeclaratorSyntax(SyntaxKind kind, SyntaxToken identifier, BracketedArgumentListSyntax? argumentList, EqualsValueClauseSyntax? initializer, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    internal VariableDeclaratorSyntax(SyntaxKind kind, SyntaxToken identifier, BracketedArgumentListSyntax? argumentList, EqualsValueClauseSyntax? initializer)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public BracketedArgumentListSyntax? ArgumentList => this.argumentList;
    public EqualsValueClauseSyntax? Initializer => this.initializer;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.identifier,
            1 => this.argumentList,
            2 => this.initializer,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.VariableDeclaratorSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitVariableDeclarator(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitVariableDeclarator(this);

    public VariableDeclaratorSyntax Update(SyntaxToken identifier, BracketedArgumentListSyntax argumentList, EqualsValueClauseSyntax initializer)
    {
        if (identifier != this.Identifier || argumentList != this.ArgumentList || initializer != this.Initializer)
        {
            var newNode = SyntaxFactory.VariableDeclarator(identifier, argumentList, initializer);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new VariableDeclaratorSyntax(this.Kind, this.identifier, this.argumentList, this.initializer, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new VariableDeclaratorSyntax(this.Kind, this.identifier, this.argumentList, this.initializer, GetDiagnostics(), annotations);
}

internal sealed partial class EqualsValueClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken equalsToken;
    internal readonly ExpressionSyntax value;

    internal EqualsValueClauseSyntax(SyntaxKind kind, SyntaxToken equalsToken, ExpressionSyntax value, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    internal EqualsValueClauseSyntax(SyntaxKind kind, SyntaxToken equalsToken, ExpressionSyntax value, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    internal EqualsValueClauseSyntax(SyntaxKind kind, SyntaxToken equalsToken, ExpressionSyntax value)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
    }

    public SyntaxToken EqualsToken => this.equalsToken;
    public ExpressionSyntax Value => this.value;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.equalsToken,
            1 => this.value,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.EqualsValueClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEqualsValueClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEqualsValueClause(this);

    public EqualsValueClauseSyntax Update(SyntaxToken equalsToken, ExpressionSyntax value)
    {
        if (equalsToken != this.EqualsToken || value != this.Value)
        {
            var newNode = SyntaxFactory.EqualsValueClause(equalsToken, value);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new EqualsValueClauseSyntax(this.Kind, this.equalsToken, this.value, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new EqualsValueClauseSyntax(this.Kind, this.equalsToken, this.value, GetDiagnostics(), annotations);
}

internal abstract partial class VariableDesignationSyntax : CSharpSyntaxNode
{
    internal VariableDesignationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal VariableDesignationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

internal sealed partial class SingleVariableDesignationSyntax : VariableDesignationSyntax
{
    internal readonly SyntaxToken identifier;

    internal SingleVariableDesignationSyntax(SyntaxKind kind, SyntaxToken identifier, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal SingleVariableDesignationSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal SingleVariableDesignationSyntax(SyntaxKind kind, SyntaxToken identifier)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.identifier : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SingleVariableDesignationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSingleVariableDesignation(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSingleVariableDesignation(this);

    public SingleVariableDesignationSyntax Update(SyntaxToken identifier)
    {
        if (identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.SingleVariableDesignation(identifier);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SingleVariableDesignationSyntax(this.Kind, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SingleVariableDesignationSyntax(this.Kind, this.identifier, GetDiagnostics(), annotations);
}

internal sealed partial class DiscardDesignationSyntax : VariableDesignationSyntax
{
    internal readonly SyntaxToken underscoreToken;

    internal DiscardDesignationSyntax(SyntaxKind kind, SyntaxToken underscoreToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    internal DiscardDesignationSyntax(SyntaxKind kind, SyntaxToken underscoreToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    internal DiscardDesignationSyntax(SyntaxKind kind, SyntaxToken underscoreToken)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(underscoreToken);
        this.underscoreToken = underscoreToken;
    }

    public SyntaxToken UnderscoreToken => this.underscoreToken;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.underscoreToken : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DiscardDesignationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDiscardDesignation(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDiscardDesignation(this);

    public DiscardDesignationSyntax Update(SyntaxToken underscoreToken)
    {
        if (underscoreToken != this.UnderscoreToken)
        {
            var newNode = SyntaxFactory.DiscardDesignation(underscoreToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DiscardDesignationSyntax(this.Kind, this.underscoreToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DiscardDesignationSyntax(this.Kind, this.underscoreToken, GetDiagnostics(), annotations);
}

internal sealed partial class ParenthesizedVariableDesignationSyntax : VariableDesignationSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? variables;
    internal readonly SyntaxToken closeParenToken;

    internal ParenthesizedVariableDesignationSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? variables, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParenthesizedVariableDesignationSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? variables, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParenthesizedVariableDesignationSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? variables, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (variables != null)
        {
            this.AdjustFlagsAndWidth(variables);
            this.variables = variables;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public CoreSyntax.SeparatedSyntaxList<VariableDesignationSyntax> Variables => new CoreSyntax.SeparatedSyntaxList<VariableDesignationSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.variables));
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.variables,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ParenthesizedVariableDesignationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParenthesizedVariableDesignation(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParenthesizedVariableDesignation(this);

    public ParenthesizedVariableDesignationSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<VariableDesignationSyntax> variables, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || variables != this.Variables || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParenthesizedVariableDesignation(openParenToken, variables, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ParenthesizedVariableDesignationSyntax(this.Kind, this.openParenToken, this.variables, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ParenthesizedVariableDesignationSyntax(this.Kind, this.openParenToken, this.variables, this.closeParenToken, GetDiagnostics(), annotations);
}

internal sealed partial class ExpressionStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken semicolonToken;

    internal ExpressionStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, ExpressionSyntax expression, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ExpressionStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, ExpressionSyntax expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ExpressionStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, ExpressionSyntax expression, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.expression,
            2 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ExpressionStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExpressionStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExpressionStatement(this);

    public ExpressionStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ExpressionStatement(attributeLists, expression, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ExpressionStatementSyntax(this.Kind, this.attributeLists, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ExpressionStatementSyntax(this.Kind, this.attributeLists, this.expression, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class EmptyStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken semicolonToken;

    internal EmptyStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal EmptyStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal EmptyStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 2;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.EmptyStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEmptyStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEmptyStatement(this);

    public EmptyStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EmptyStatement(attributeLists, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new EmptyStatementSyntax(this.Kind, this.attributeLists, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new EmptyStatementSyntax(this.Kind, this.attributeLists, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Represents a labeled statement syntax.</summary>
internal sealed partial class LabeledStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken colonToken;
    internal readonly StatementSyntax statement;

    internal LabeledStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal LabeledStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal LabeledStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    /// <summary>Gets a SyntaxToken that represents the colon following the statement's label.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.identifier,
            2 => this.colonToken,
            3 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.LabeledStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLabeledStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLabeledStatement(this);

    public LabeledStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken identifier, SyntaxToken colonToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || identifier != this.Identifier || colonToken != this.ColonToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.LabeledStatement(attributeLists, identifier, colonToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new LabeledStatementSyntax(this.Kind, this.attributeLists, this.identifier, this.colonToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new LabeledStatementSyntax(this.Kind, this.attributeLists, this.identifier, this.colonToken, this.statement, GetDiagnostics(), annotations);
}

/// <summary>
/// Represents a goto statement syntax
/// </summary>
internal sealed partial class GotoStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken gotoKeyword;
    internal readonly SyntaxToken? caseOrDefaultKeyword;
    internal readonly ExpressionSyntax? expression;
    internal readonly SyntaxToken semicolonToken;

    internal GotoStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken gotoKeyword, SyntaxToken? caseOrDefaultKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(gotoKeyword);
        this.gotoKeyword = gotoKeyword;
        if (caseOrDefaultKeyword != null)
        {
            this.AdjustFlagsAndWidth(caseOrDefaultKeyword);
            this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal GotoStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken gotoKeyword, SyntaxToken? caseOrDefaultKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(gotoKeyword);
        this.gotoKeyword = gotoKeyword;
        if (caseOrDefaultKeyword != null)
        {
            this.AdjustFlagsAndWidth(caseOrDefaultKeyword);
            this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal GotoStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken gotoKeyword, SyntaxToken? caseOrDefaultKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(gotoKeyword);
        this.gotoKeyword = gotoKeyword;
        if (caseOrDefaultKeyword != null)
        {
            this.AdjustFlagsAndWidth(caseOrDefaultKeyword);
            this.caseOrDefaultKeyword = caseOrDefaultKeyword;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>
    /// Gets a SyntaxToken that represents the goto keyword.
    /// </summary>
    public SyntaxToken GotoKeyword => this.gotoKeyword;
    /// <summary>
    /// Gets a SyntaxToken that represents the case or default keywords if any exists.
    /// </summary>
    public SyntaxToken? CaseOrDefaultKeyword => this.caseOrDefaultKeyword;
    /// <summary>
    /// Gets a constant expression for a goto case statement.
    /// </summary>
    public ExpressionSyntax? Expression => this.expression;
    /// <summary>
    /// Gets a SyntaxToken that represents the semi-colon at the end of the statement.
    /// </summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.gotoKeyword,
            2 => this.caseOrDefaultKeyword,
            3 => this.expression,
            4 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.GotoStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitGotoStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitGotoStatement(this);

    public GotoStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken gotoKeyword, SyntaxToken caseOrDefaultKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || gotoKeyword != this.GotoKeyword || caseOrDefaultKeyword != this.CaseOrDefaultKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.GotoStatement(this.Kind, attributeLists, gotoKeyword, caseOrDefaultKeyword, expression, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new GotoStatementSyntax(this.Kind, this.attributeLists, this.gotoKeyword, this.caseOrDefaultKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new GotoStatementSyntax(this.Kind, this.attributeLists, this.gotoKeyword, this.caseOrDefaultKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class BreakStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken breakKeyword;
    internal readonly SyntaxToken semicolonToken;

    internal BreakStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken breakKeyword, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(breakKeyword);
        this.breakKeyword = breakKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal BreakStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken breakKeyword, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(breakKeyword);
        this.breakKeyword = breakKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal BreakStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken breakKeyword, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(breakKeyword);
        this.breakKeyword = breakKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken BreakKeyword => this.breakKeyword;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.breakKeyword,
            2 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BreakStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBreakStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBreakStatement(this);

    public BreakStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken breakKeyword, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || breakKeyword != this.BreakKeyword || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.BreakStatement(attributeLists, breakKeyword, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BreakStatementSyntax(this.Kind, this.attributeLists, this.breakKeyword, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BreakStatementSyntax(this.Kind, this.attributeLists, this.breakKeyword, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class ContinueStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken continueKeyword;
    internal readonly SyntaxToken semicolonToken;

    internal ContinueStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken continueKeyword, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(continueKeyword);
        this.continueKeyword = continueKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ContinueStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken continueKeyword, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(continueKeyword);
        this.continueKeyword = continueKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ContinueStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken continueKeyword, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(continueKeyword);
        this.continueKeyword = continueKeyword;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken ContinueKeyword => this.continueKeyword;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.continueKeyword,
            2 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ContinueStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitContinueStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitContinueStatement(this);

    public ContinueStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken continueKeyword, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || continueKeyword != this.ContinueKeyword || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ContinueStatement(attributeLists, continueKeyword, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ContinueStatementSyntax(this.Kind, this.attributeLists, this.continueKeyword, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ContinueStatementSyntax(this.Kind, this.attributeLists, this.continueKeyword, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class ReturnStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken returnKeyword;
    internal readonly ExpressionSyntax? expression;
    internal readonly SyntaxToken semicolonToken;

    internal ReturnStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken returnKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(returnKeyword);
        this.returnKeyword = returnKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ReturnStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken returnKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(returnKeyword);
        this.returnKeyword = returnKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ReturnStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken returnKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(returnKeyword);
        this.returnKeyword = returnKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken ReturnKeyword => this.returnKeyword;
    public ExpressionSyntax? Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.returnKeyword,
            2 => this.expression,
            3 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ReturnStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitReturnStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitReturnStatement(this);

    public ReturnStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken returnKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || returnKeyword != this.ReturnKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ReturnStatement(attributeLists, returnKeyword, expression, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ReturnStatementSyntax(this.Kind, this.attributeLists, this.returnKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ReturnStatementSyntax(this.Kind, this.attributeLists, this.returnKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class ThrowStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken throwKeyword;
    internal readonly ExpressionSyntax? expression;
    internal readonly SyntaxToken semicolonToken;

    internal ThrowStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken throwKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ThrowStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken throwKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ThrowStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken throwKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(throwKeyword);
        this.throwKeyword = throwKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken ThrowKeyword => this.throwKeyword;
    public ExpressionSyntax? Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.throwKeyword,
            2 => this.expression,
            3 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ThrowStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitThrowStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitThrowStatement(this);

    public ThrowStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken throwKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || throwKeyword != this.ThrowKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ThrowStatement(attributeLists, throwKeyword, expression, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ThrowStatementSyntax(this.Kind, this.attributeLists, this.throwKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ThrowStatementSyntax(this.Kind, this.attributeLists, this.throwKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class YieldStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken yieldKeyword;
    internal readonly SyntaxToken returnOrBreakKeyword;
    internal readonly ExpressionSyntax? expression;
    internal readonly SyntaxToken semicolonToken;

    internal YieldStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(yieldKeyword);
        this.yieldKeyword = yieldKeyword;
        this.AdjustFlagsAndWidth(returnOrBreakKeyword);
        this.returnOrBreakKeyword = returnOrBreakKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal YieldStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(yieldKeyword);
        this.yieldKeyword = yieldKeyword;
        this.AdjustFlagsAndWidth(returnOrBreakKeyword);
        this.returnOrBreakKeyword = returnOrBreakKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal YieldStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax? expression, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(yieldKeyword);
        this.yieldKeyword = yieldKeyword;
        this.AdjustFlagsAndWidth(returnOrBreakKeyword);
        this.returnOrBreakKeyword = returnOrBreakKeyword;
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken YieldKeyword => this.yieldKeyword;
    public SyntaxToken ReturnOrBreakKeyword => this.returnOrBreakKeyword;
    public ExpressionSyntax? Expression => this.expression;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.yieldKeyword,
            2 => this.returnOrBreakKeyword,
            3 => this.expression,
            4 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.YieldStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitYieldStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitYieldStatement(this);

    public YieldStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken yieldKeyword, SyntaxToken returnOrBreakKeyword, ExpressionSyntax expression, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || yieldKeyword != this.YieldKeyword || returnOrBreakKeyword != this.ReturnOrBreakKeyword || expression != this.Expression || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.YieldStatement(this.Kind, attributeLists, yieldKeyword, returnOrBreakKeyword, expression, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new YieldStatementSyntax(this.Kind, this.attributeLists, this.yieldKeyword, this.returnOrBreakKeyword, this.expression, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new YieldStatementSyntax(this.Kind, this.attributeLists, this.yieldKeyword, this.returnOrBreakKeyword, this.expression, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class WhileStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken whileKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal WhileStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal WhileStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal WhileStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken WhileKeyword => this.whileKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax Condition => this.condition;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.whileKeyword,
            2 => this.openParenToken,
            3 => this.condition,
            4 => this.closeParenToken,
            5 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.WhileStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitWhileStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitWhileStatement(this);

    public WhileStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || whileKeyword != this.WhileKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.WhileStatement(attributeLists, whileKeyword, openParenToken, condition, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new WhileStatementSyntax(this.Kind, this.attributeLists, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new WhileStatementSyntax(this.Kind, this.attributeLists, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

internal sealed partial class DoStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken doKeyword;
    internal readonly StatementSyntax statement;
    internal readonly SyntaxToken whileKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken closeParenToken;
    internal readonly SyntaxToken semicolonToken;

    internal DoStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(doKeyword);
        this.doKeyword = doKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal DoStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(doKeyword);
        this.doKeyword = doKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal DoStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(doKeyword);
        this.doKeyword = doKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        this.AdjustFlagsAndWidth(whileKeyword);
        this.whileKeyword = whileKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken DoKeyword => this.doKeyword;
    public StatementSyntax Statement => this.statement;
    public SyntaxToken WhileKeyword => this.whileKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax Condition => this.condition;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.doKeyword,
            2 => this.statement,
            3 => this.whileKeyword,
            4 => this.openParenToken,
            5 => this.condition,
            6 => this.closeParenToken,
            7 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DoStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDoStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDoStatement(this);

    public DoStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken doKeyword, StatementSyntax statement, SyntaxToken whileKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || doKeyword != this.DoKeyword || statement != this.Statement || whileKeyword != this.WhileKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DoStatement(attributeLists, doKeyword, statement, whileKeyword, openParenToken, condition, closeParenToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DoStatementSyntax(this.Kind, this.attributeLists, this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DoStatementSyntax(this.Kind, this.attributeLists, this.doKeyword, this.statement, this.whileKeyword, this.openParenToken, this.condition, this.closeParenToken, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class ForStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken forKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly VariableDeclarationSyntax? declaration;
    internal readonly GreenNode? initializers;
    internal readonly SyntaxToken firstSemicolonToken;
    internal readonly ExpressionSyntax? condition;
    internal readonly SyntaxToken secondSemicolonToken;
    internal readonly GreenNode? incrementors;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal ForStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax? declaration, GreenNode? initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax? condition, SyntaxToken secondSemicolonToken, GreenNode? incrementors, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(forKeyword);
        this.forKeyword = forKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(firstSemicolonToken);
        this.firstSemicolonToken = firstSemicolonToken;
        if (condition != null)
        {
            this.AdjustFlagsAndWidth(condition);
            this.condition = condition;
        }
        this.AdjustFlagsAndWidth(secondSemicolonToken);
        this.secondSemicolonToken = secondSemicolonToken;
        if (incrementors != null)
        {
            this.AdjustFlagsAndWidth(incrementors);
            this.incrementors = incrementors;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ForStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax? declaration, GreenNode? initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax? condition, SyntaxToken secondSemicolonToken, GreenNode? incrementors, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(forKeyword);
        this.forKeyword = forKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(firstSemicolonToken);
        this.firstSemicolonToken = firstSemicolonToken;
        if (condition != null)
        {
            this.AdjustFlagsAndWidth(condition);
            this.condition = condition;
        }
        this.AdjustFlagsAndWidth(secondSemicolonToken);
        this.secondSemicolonToken = secondSemicolonToken;
        if (incrementors != null)
        {
            this.AdjustFlagsAndWidth(incrementors);
            this.incrementors = incrementors;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ForStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax? declaration, GreenNode? initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax? condition, SyntaxToken secondSemicolonToken, GreenNode? incrementors, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(forKeyword);
        this.forKeyword = forKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (initializers != null)
        {
            this.AdjustFlagsAndWidth(initializers);
            this.initializers = initializers;
        }
        this.AdjustFlagsAndWidth(firstSemicolonToken);
        this.firstSemicolonToken = firstSemicolonToken;
        if (condition != null)
        {
            this.AdjustFlagsAndWidth(condition);
            this.condition = condition;
        }
        this.AdjustFlagsAndWidth(secondSemicolonToken);
        this.secondSemicolonToken = secondSemicolonToken;
        if (incrementors != null)
        {
            this.AdjustFlagsAndWidth(incrementors);
            this.incrementors = incrementors;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken ForKeyword => this.forKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public VariableDeclarationSyntax? Declaration => this.declaration;
    public CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> Initializers => new CoreSyntax.SeparatedSyntaxList<ExpressionSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.initializers));
    public SyntaxToken FirstSemicolonToken => this.firstSemicolonToken;
    public ExpressionSyntax? Condition => this.condition;
    public SyntaxToken SecondSemicolonToken => this.secondSemicolonToken;
    public CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> Incrementors => new CoreSyntax.SeparatedSyntaxList<ExpressionSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.incrementors));
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.forKeyword,
            2 => this.openParenToken,
            3 => this.declaration,
            4 => this.initializers,
            5 => this.firstSemicolonToken,
            6 => this.condition,
            7 => this.secondSemicolonToken,
            8 => this.incrementors,
            9 => this.closeParenToken,
            10 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ForStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitForStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitForStatement(this);

    public ForStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken forKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> initializers, SyntaxToken firstSemicolonToken, ExpressionSyntax condition, SyntaxToken secondSemicolonToken, CoreSyntax.SeparatedSyntaxList<ExpressionSyntax> incrementors, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || forKeyword != this.ForKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || initializers != this.Initializers || firstSemicolonToken != this.FirstSemicolonToken || condition != this.Condition || secondSemicolonToken != this.SecondSemicolonToken || incrementors != this.Incrementors || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForStatement(attributeLists, forKeyword, openParenToken, declaration, initializers, firstSemicolonToken, condition, secondSemicolonToken, incrementors, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ForStatementSyntax(this.Kind, this.attributeLists, this.forKeyword, this.openParenToken, this.declaration, this.initializers, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementors, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ForStatementSyntax(this.Kind, this.attributeLists, this.forKeyword, this.openParenToken, this.declaration, this.initializers, this.firstSemicolonToken, this.condition, this.secondSemicolonToken, this.incrementors, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

internal abstract partial class CommonForEachStatementSyntax : StatementSyntax
{
    internal CommonForEachStatementSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal CommonForEachStatementSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract SyntaxToken? AwaitKeyword { get; }

    public abstract SyntaxToken ForEachKeyword { get; }

    public abstract SyntaxToken OpenParenToken { get; }

    public abstract SyntaxToken InKeyword { get; }

    public abstract ExpressionSyntax Expression { get; }

    public abstract SyntaxToken CloseParenToken { get; }

    public abstract StatementSyntax Statement { get; }
}

internal sealed partial class ForEachStatementSyntax : CommonForEachStatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken? awaitKeyword;
    internal readonly SyntaxToken forEachKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal ForEachStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ForEachStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ForEachStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override SyntaxToken? AwaitKeyword => this.awaitKeyword;
    public override SyntaxToken ForEachKeyword => this.forEachKeyword;
    public override SyntaxToken OpenParenToken => this.openParenToken;
    public TypeSyntax Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override SyntaxToken InKeyword => this.inKeyword;
    public override ExpressionSyntax Expression => this.expression;
    public override SyntaxToken CloseParenToken => this.closeParenToken;
    public override StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.awaitKeyword,
            2 => this.forEachKeyword,
            3 => this.openParenToken,
            4 => this.type,
            5 => this.identifier,
            6 => this.inKeyword,
            7 => this.expression,
            8 => this.closeParenToken,
            9 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ForEachStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitForEachStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitForEachStatement(this);

    public ForEachStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || awaitKeyword != this.AwaitKeyword || forEachKeyword != this.ForEachKeyword || openParenToken != this.OpenParenToken || type != this.Type || identifier != this.Identifier || inKeyword != this.InKeyword || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForEachStatement(attributeLists, awaitKeyword, forEachKeyword, openParenToken, type, identifier, inKeyword, expression, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ForEachStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.type, this.identifier, this.inKeyword, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ForEachStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.type, this.identifier, this.inKeyword, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

internal sealed partial class ForEachVariableStatementSyntax : CommonForEachStatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken? awaitKeyword;
    internal readonly SyntaxToken forEachKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax variable;
    internal readonly SyntaxToken inKeyword;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal ForEachVariableStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(variable);
        this.variable = variable;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ForEachVariableStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(variable);
        this.variable = variable;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ForEachVariableStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(forEachKeyword);
        this.forEachKeyword = forEachKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(variable);
        this.variable = variable;
        this.AdjustFlagsAndWidth(inKeyword);
        this.inKeyword = inKeyword;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override SyntaxToken? AwaitKeyword => this.awaitKeyword;
    public override SyntaxToken ForEachKeyword => this.forEachKeyword;
    public override SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>
    /// The variable(s) of the loop. In correct code this is a tuple
    /// literal, declaration expression with a tuple designator, or
    /// a discard syntax in the form of a simple identifier. In broken
    /// code it could be something else.
    /// </summary>
    public ExpressionSyntax Variable => this.variable;
    public override SyntaxToken InKeyword => this.inKeyword;
    public override ExpressionSyntax Expression => this.expression;
    public override SyntaxToken CloseParenToken => this.closeParenToken;
    public override StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.awaitKeyword,
            2 => this.forEachKeyword,
            3 => this.openParenToken,
            4 => this.variable,
            5 => this.inKeyword,
            6 => this.expression,
            7 => this.closeParenToken,
            8 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ForEachVariableStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitForEachVariableStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitForEachVariableStatement(this);

    public ForEachVariableStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken awaitKeyword, SyntaxToken forEachKeyword, SyntaxToken openParenToken, ExpressionSyntax variable, SyntaxToken inKeyword, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || awaitKeyword != this.AwaitKeyword || forEachKeyword != this.ForEachKeyword || openParenToken != this.OpenParenToken || variable != this.Variable || inKeyword != this.InKeyword || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ForEachVariableStatement(attributeLists, awaitKeyword, forEachKeyword, openParenToken, variable, inKeyword, expression, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ForEachVariableStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.variable, this.inKeyword, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ForEachVariableStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.forEachKeyword, this.openParenToken, this.variable, this.inKeyword, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

internal sealed partial class UsingStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken? awaitKeyword;
    internal readonly SyntaxToken usingKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly VariableDeclarationSyntax? declaration;
    internal readonly ExpressionSyntax? expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal UsingStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax? declaration, ExpressionSyntax? expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal UsingStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax? declaration, ExpressionSyntax? expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal UsingStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax? declaration, ExpressionSyntax? expression, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (awaitKeyword != null)
        {
            this.AdjustFlagsAndWidth(awaitKeyword);
            this.awaitKeyword = awaitKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (expression != null)
        {
            this.AdjustFlagsAndWidth(expression);
            this.expression = expression;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken? AwaitKeyword => this.awaitKeyword;
    public SyntaxToken UsingKeyword => this.usingKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public VariableDeclarationSyntax? Declaration => this.declaration;
    public ExpressionSyntax? Expression => this.expression;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.awaitKeyword,
            2 => this.usingKeyword,
            3 => this.openParenToken,
            4 => this.declaration,
            5 => this.expression,
            6 => this.closeParenToken,
            7 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.UsingStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUsingStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUsingStatement(this);

    public UsingStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken awaitKeyword, SyntaxToken usingKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || awaitKeyword != this.AwaitKeyword || usingKeyword != this.UsingKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.UsingStatement(attributeLists, awaitKeyword, usingKeyword, openParenToken, declaration, expression, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new UsingStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.usingKeyword, this.openParenToken, this.declaration, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new UsingStatementSyntax(this.Kind, this.attributeLists, this.awaitKeyword, this.usingKeyword, this.openParenToken, this.declaration, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

internal sealed partial class FixedStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken fixedKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal FixedStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(fixedKeyword);
        this.fixedKeyword = fixedKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal FixedStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(fixedKeyword);
        this.fixedKeyword = fixedKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal FixedStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(fixedKeyword);
        this.fixedKeyword = fixedKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken FixedKeyword => this.fixedKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public VariableDeclarationSyntax Declaration => this.declaration;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.fixedKeyword,
            2 => this.openParenToken,
            3 => this.declaration,
            4 => this.closeParenToken,
            5 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FixedStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFixedStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFixedStatement(this);

    public FixedStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken fixedKeyword, SyntaxToken openParenToken, VariableDeclarationSyntax declaration, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || fixedKeyword != this.FixedKeyword || openParenToken != this.OpenParenToken || declaration != this.Declaration || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.FixedStatement(attributeLists, fixedKeyword, openParenToken, declaration, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FixedStatementSyntax(this.Kind, this.attributeLists, this.fixedKeyword, this.openParenToken, this.declaration, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FixedStatementSyntax(this.Kind, this.attributeLists, this.fixedKeyword, this.openParenToken, this.declaration, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

internal sealed partial class CheckedStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken keyword;
    internal readonly BlockSyntax block;

    internal CheckedStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken keyword, BlockSyntax block, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal CheckedStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken keyword, BlockSyntax block, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal CheckedStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken keyword, BlockSyntax block)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken Keyword => this.keyword;
    public BlockSyntax Block => this.block;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.keyword,
            2 => this.block,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CheckedStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCheckedStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCheckedStatement(this);

    public CheckedStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken keyword, BlockSyntax block)
    {
        if (attributeLists != this.AttributeLists || keyword != this.Keyword || block != this.Block)
        {
            var newNode = SyntaxFactory.CheckedStatement(this.Kind, attributeLists, keyword, block);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CheckedStatementSyntax(this.Kind, this.attributeLists, this.keyword, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CheckedStatementSyntax(this.Kind, this.attributeLists, this.keyword, this.block, GetDiagnostics(), annotations);
}

internal sealed partial class UnsafeStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken unsafeKeyword;
    internal readonly BlockSyntax block;

    internal UnsafeStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken unsafeKeyword, BlockSyntax block, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(unsafeKeyword);
        this.unsafeKeyword = unsafeKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal UnsafeStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken unsafeKeyword, BlockSyntax block, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(unsafeKeyword);
        this.unsafeKeyword = unsafeKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal UnsafeStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken unsafeKeyword, BlockSyntax block)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(unsafeKeyword);
        this.unsafeKeyword = unsafeKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken UnsafeKeyword => this.unsafeKeyword;
    public BlockSyntax Block => this.block;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.unsafeKeyword,
            2 => this.block,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.UnsafeStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUnsafeStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUnsafeStatement(this);

    public UnsafeStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken unsafeKeyword, BlockSyntax block)
    {
        if (attributeLists != this.AttributeLists || unsafeKeyword != this.UnsafeKeyword || block != this.Block)
        {
            var newNode = SyntaxFactory.UnsafeStatement(attributeLists, unsafeKeyword, block);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new UnsafeStatementSyntax(this.Kind, this.attributeLists, this.unsafeKeyword, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new UnsafeStatementSyntax(this.Kind, this.attributeLists, this.unsafeKeyword, this.block, GetDiagnostics(), annotations);
}

internal sealed partial class LockStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken lockKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;

    internal LockStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(lockKeyword);
        this.lockKeyword = lockKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal LockStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(lockKeyword);
        this.lockKeyword = lockKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal LockStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(lockKeyword);
        this.lockKeyword = lockKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken LockKeyword => this.lockKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax Expression => this.expression;
    public SyntaxToken CloseParenToken => this.closeParenToken;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.lockKeyword,
            2 => this.openParenToken,
            3 => this.expression,
            4 => this.closeParenToken,
            5 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.LockStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitLockStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitLockStatement(this);

    public LockStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken lockKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, StatementSyntax statement)
    {
        if (attributeLists != this.AttributeLists || lockKeyword != this.LockKeyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken || statement != this.Statement)
        {
            var newNode = SyntaxFactory.LockStatement(attributeLists, lockKeyword, openParenToken, expression, closeParenToken, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new LockStatementSyntax(this.Kind, this.attributeLists, this.lockKeyword, this.openParenToken, this.expression, this.closeParenToken, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new LockStatementSyntax(this.Kind, this.attributeLists, this.lockKeyword, this.openParenToken, this.expression, this.closeParenToken, this.statement, GetDiagnostics(), annotations);
}

/// <summary>
/// Represents an if statement syntax.
/// </summary>
internal sealed partial class IfStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken ifKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax condition;
    internal readonly SyntaxToken closeParenToken;
    internal readonly StatementSyntax statement;
    internal readonly ElseClauseSyntax? @else;

    internal IfStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax? @else, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 7;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(ifKeyword);
        this.ifKeyword = ifKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        if (@else != null)
        {
            this.AdjustFlagsAndWidth(@else);
            this.@else = @else;
        }
    }

    internal IfStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax? @else, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 7;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(ifKeyword);
        this.ifKeyword = ifKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        if (@else != null)
        {
            this.AdjustFlagsAndWidth(@else);
            this.@else = @else;
        }
    }

    internal IfStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax? @else)
      : base(kind)
    {
        this.SlotCount = 7;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(ifKeyword);
        this.ifKeyword = ifKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(condition);
        this.condition = condition;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
        if (@else != null)
        {
            this.AdjustFlagsAndWidth(@else);
            this.@else = @else;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>
    /// Gets a SyntaxToken that represents the if keyword.
    /// </summary>
    public SyntaxToken IfKeyword => this.ifKeyword;
    /// <summary>
    /// Gets a SyntaxToken that represents the open parenthesis before the if statement's condition expression.
    /// </summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>
    /// Gets an ExpressionSyntax that represents the condition of the if statement.
    /// </summary>
    public ExpressionSyntax Condition => this.condition;
    /// <summary>
    /// Gets a SyntaxToken that represents the close parenthesis after the if statement's condition expression.
    /// </summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;
    /// <summary>
    /// Gets a StatementSyntax the represents the statement to be executed when the condition is true.
    /// </summary>
    public StatementSyntax Statement => this.statement;
    /// <summary>
    /// Gets an ElseClauseSyntax that represents the statement to be executed when the condition is false if such statement exists.
    /// </summary>
    public ElseClauseSyntax? Else => this.@else;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.ifKeyword,
            2 => this.openParenToken,
            3 => this.condition,
            4 => this.closeParenToken,
            5 => this.statement,
            6 => this.@else,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.IfStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIfStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIfStatement(this);

    public IfStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken ifKeyword, SyntaxToken openParenToken, ExpressionSyntax condition, SyntaxToken closeParenToken, StatementSyntax statement, ElseClauseSyntax @else)
    {
        if (attributeLists != this.AttributeLists || ifKeyword != this.IfKeyword || openParenToken != this.OpenParenToken || condition != this.Condition || closeParenToken != this.CloseParenToken || statement != this.Statement || @else != this.Else)
        {
            var newNode = SyntaxFactory.IfStatement(attributeLists, ifKeyword, openParenToken, condition, closeParenToken, statement, @else);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new IfStatementSyntax(this.Kind, this.attributeLists, this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, this.@else, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new IfStatementSyntax(this.Kind, this.attributeLists, this.ifKeyword, this.openParenToken, this.condition, this.closeParenToken, this.statement, this.@else, GetDiagnostics(), annotations);
}

/// <summary>Represents an else statement syntax.</summary>
internal sealed partial class ElseClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken elseKeyword;
    internal readonly StatementSyntax statement;

    internal ElseClauseSyntax(SyntaxKind kind, SyntaxToken elseKeyword, StatementSyntax statement, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elseKeyword);
        this.elseKeyword = elseKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ElseClauseSyntax(SyntaxKind kind, SyntaxToken elseKeyword, StatementSyntax statement, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elseKeyword);
        this.elseKeyword = elseKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    internal ElseClauseSyntax(SyntaxKind kind, SyntaxToken elseKeyword, StatementSyntax statement)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(elseKeyword);
        this.elseKeyword = elseKeyword;
        this.AdjustFlagsAndWidth(statement);
        this.statement = statement;
    }

    /// <summary>
    /// Gets a syntax token
    /// </summary>
    public SyntaxToken ElseKeyword => this.elseKeyword;
    public StatementSyntax Statement => this.statement;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.elseKeyword,
            1 => this.statement,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ElseClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitElseClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitElseClause(this);

    public ElseClauseSyntax Update(SyntaxToken elseKeyword, StatementSyntax statement)
    {
        if (elseKeyword != this.ElseKeyword || statement != this.Statement)
        {
            var newNode = SyntaxFactory.ElseClause(elseKeyword, statement);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ElseClauseSyntax(this.Kind, this.elseKeyword, this.statement, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ElseClauseSyntax(this.Kind, this.elseKeyword, this.statement, GetDiagnostics(), annotations);
}

/// <summary>Represents a switch statement syntax.</summary>
internal sealed partial class SwitchStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken switchKeyword;
    internal readonly SyntaxToken? openParenToken;
    internal readonly ExpressionSyntax expression;
    internal readonly SyntaxToken? closeParenToken;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? sections;
    internal readonly SyntaxToken closeBraceToken;

    internal SwitchStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken switchKeyword, SyntaxToken? openParenToken, ExpressionSyntax expression, SyntaxToken? closeParenToken, SyntaxToken openBraceToken, GreenNode? sections, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        if (openParenToken != null)
        {
            this.AdjustFlagsAndWidth(openParenToken);
            this.openParenToken = openParenToken;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (closeParenToken != null)
        {
            this.AdjustFlagsAndWidth(closeParenToken);
            this.closeParenToken = closeParenToken;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (sections != null)
        {
            this.AdjustFlagsAndWidth(sections);
            this.sections = sections;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal SwitchStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken switchKeyword, SyntaxToken? openParenToken, ExpressionSyntax expression, SyntaxToken? closeParenToken, SyntaxToken openBraceToken, GreenNode? sections, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        if (openParenToken != null)
        {
            this.AdjustFlagsAndWidth(openParenToken);
            this.openParenToken = openParenToken;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (closeParenToken != null)
        {
            this.AdjustFlagsAndWidth(closeParenToken);
            this.closeParenToken = closeParenToken;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (sections != null)
        {
            this.AdjustFlagsAndWidth(sections);
            this.sections = sections;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal SwitchStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken switchKeyword, SyntaxToken? openParenToken, ExpressionSyntax expression, SyntaxToken? closeParenToken, SyntaxToken openBraceToken, GreenNode? sections, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        if (openParenToken != null)
        {
            this.AdjustFlagsAndWidth(openParenToken);
            this.openParenToken = openParenToken;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
        if (closeParenToken != null)
        {
            this.AdjustFlagsAndWidth(closeParenToken);
            this.closeParenToken = closeParenToken;
        }
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (sections != null)
        {
            this.AdjustFlagsAndWidth(sections);
            this.sections = sections;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>
    /// Gets a SyntaxToken that represents the switch keyword.
    /// </summary>
    public SyntaxToken SwitchKeyword => this.switchKeyword;
    /// <summary>
    /// Gets a SyntaxToken that represents the open parenthesis preceding the switch governing expression.
    /// </summary>
    public SyntaxToken? OpenParenToken => this.openParenToken;
    /// <summary>
    /// Gets an ExpressionSyntax representing the expression of the switch statement.
    /// </summary>
    public ExpressionSyntax Expression => this.expression;
    /// <summary>
    /// Gets a SyntaxToken that represents the close parenthesis following the switch governing expression.
    /// </summary>
    public SyntaxToken? CloseParenToken => this.closeParenToken;
    /// <summary>
    /// Gets a SyntaxToken that represents the open braces preceding the switch sections.
    /// </summary>
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    /// <summary>
    /// Gets a SyntaxList of SwitchSectionSyntax's that represents the switch sections of the switch statement.
    /// </summary>
    public CoreSyntax.SyntaxList<SwitchSectionSyntax> Sections => new CoreSyntax.SyntaxList<SwitchSectionSyntax>(this.sections);
    /// <summary>
    /// Gets a SyntaxToken that represents the open braces following the switch sections.
    /// </summary>
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.switchKeyword,
            2 => this.openParenToken,
            3 => this.expression,
            4 => this.closeParenToken,
            5 => this.openBraceToken,
            6 => this.sections,
            7 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SwitchStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchStatement(this);

    public SwitchStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken switchKeyword, SyntaxToken openParenToken, ExpressionSyntax expression, SyntaxToken closeParenToken, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<SwitchSectionSyntax> sections, SyntaxToken closeBraceToken)
    {
        if (attributeLists != this.AttributeLists || switchKeyword != this.SwitchKeyword || openParenToken != this.OpenParenToken || expression != this.Expression || closeParenToken != this.CloseParenToken || openBraceToken != this.OpenBraceToken || sections != this.Sections || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.SwitchStatement(attributeLists, switchKeyword, openParenToken, expression, closeParenToken, openBraceToken, sections, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SwitchStatementSyntax(this.Kind, this.attributeLists, this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.sections, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SwitchStatementSyntax(this.Kind, this.attributeLists, this.switchKeyword, this.openParenToken, this.expression, this.closeParenToken, this.openBraceToken, this.sections, this.closeBraceToken, GetDiagnostics(), annotations);
}

/// <summary>Represents a switch section syntax of a switch statement.</summary>
internal sealed partial class SwitchSectionSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode? labels;
    internal readonly GreenNode? statements;

    internal SwitchSectionSyntax(SyntaxKind kind, GreenNode? labels, GreenNode? statements, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (labels != null)
        {
            this.AdjustFlagsAndWidth(labels);
            this.labels = labels;
        }
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
    }

    internal SwitchSectionSyntax(SyntaxKind kind, GreenNode? labels, GreenNode? statements, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (labels != null)
        {
            this.AdjustFlagsAndWidth(labels);
            this.labels = labels;
        }
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
    }

    internal SwitchSectionSyntax(SyntaxKind kind, GreenNode? labels, GreenNode? statements)
      : base(kind)
    {
        this.SlotCount = 2;
        if (labels != null)
        {
            this.AdjustFlagsAndWidth(labels);
            this.labels = labels;
        }
        if (statements != null)
        {
            this.AdjustFlagsAndWidth(statements);
            this.statements = statements;
        }
    }

    /// <summary>
    /// Gets a SyntaxList of SwitchLabelSyntax's the represents the possible labels that control can transfer to within the section.
    /// </summary>
    public CoreSyntax.SyntaxList<SwitchLabelSyntax> Labels => new CoreSyntax.SyntaxList<SwitchLabelSyntax>(this.labels);
    /// <summary>
    /// Gets a SyntaxList of StatementSyntax's the represents the statements to be executed when control transfer to a label the belongs to the section.
    /// </summary>
    public CoreSyntax.SyntaxList<StatementSyntax> Statements => new CoreSyntax.SyntaxList<StatementSyntax>(this.statements);

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.labels,
            1 => this.statements,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SwitchSectionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchSection(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchSection(this);

    public SwitchSectionSyntax Update(CoreSyntax.SyntaxList<SwitchLabelSyntax> labels, CoreSyntax.SyntaxList<StatementSyntax> statements)
    {
        if (labels != this.Labels || statements != this.Statements)
        {
            var newNode = SyntaxFactory.SwitchSection(labels, statements);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SwitchSectionSyntax(this.Kind, this.labels, this.statements, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SwitchSectionSyntax(this.Kind, this.labels, this.statements, GetDiagnostics(), annotations);
}

/// <summary>Represents a switch label within a switch statement.</summary>
internal abstract partial class SwitchLabelSyntax : CSharpSyntaxNode
{
    internal SwitchLabelSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal SwitchLabelSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>
    /// Gets a SyntaxToken that represents a case or default keyword that belongs to a switch label.
    /// </summary>
    public abstract SyntaxToken Keyword { get; }

    /// <summary>
    /// Gets a SyntaxToken that represents the colon that terminates the switch label.
    /// </summary>
    public abstract SyntaxToken ColonToken { get; }
}

/// <summary>Represents a case label within a switch statement.</summary>
internal sealed partial class CasePatternSwitchLabelSyntax : SwitchLabelSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly PatternSyntax pattern;
    internal readonly WhenClauseSyntax? whenClause;
    internal readonly SyntaxToken colonToken;

    internal CasePatternSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax? whenClause, SyntaxToken colonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal CasePatternSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax? whenClause, SyntaxToken colonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal CasePatternSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax? whenClause, SyntaxToken colonToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the case keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    /// <summary>
    /// Gets a PatternSyntax that represents the pattern that gets matched for the case label.
    /// </summary>
    public PatternSyntax Pattern => this.pattern;
    public WhenClauseSyntax? WhenClause => this.whenClause;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.pattern,
            2 => this.whenClause,
            3 => this.colonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CasePatternSwitchLabelSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCasePatternSwitchLabel(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCasePatternSwitchLabel(this);

    public CasePatternSwitchLabelSyntax Update(SyntaxToken keyword, PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || pattern != this.Pattern || whenClause != this.WhenClause || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.CasePatternSwitchLabel(keyword, pattern, whenClause, colonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CasePatternSwitchLabelSyntax(this.Kind, this.keyword, this.pattern, this.whenClause, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CasePatternSwitchLabelSyntax(this.Kind, this.keyword, this.pattern, this.whenClause, this.colonToken, GetDiagnostics(), annotations);
}

/// <summary>Represents a case label within a switch statement.</summary>
internal sealed partial class CaseSwitchLabelSyntax : SwitchLabelSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly ExpressionSyntax value;
    internal readonly SyntaxToken colonToken;

    internal CaseSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal CaseSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal CaseSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(value);
        this.value = value;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the case keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    /// <summary>
    /// Gets an ExpressionSyntax that represents the constant expression that gets matched for the case label.
    /// </summary>
    public ExpressionSyntax Value => this.value;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.value,
            2 => this.colonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CaseSwitchLabelSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCaseSwitchLabel(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCaseSwitchLabel(this);

    public CaseSwitchLabelSyntax Update(SyntaxToken keyword, ExpressionSyntax value, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || value != this.Value || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.CaseSwitchLabel(keyword, value, colonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CaseSwitchLabelSyntax(this.Kind, this.keyword, this.value, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CaseSwitchLabelSyntax(this.Kind, this.keyword, this.value, this.colonToken, GetDiagnostics(), annotations);
}

/// <summary>Represents a default label within a switch statement.</summary>
internal sealed partial class DefaultSwitchLabelSyntax : SwitchLabelSyntax
{
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken colonToken;

    internal DefaultSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken colonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal DefaultSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken colonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal DefaultSwitchLabelSyntax(SyntaxKind kind, SyntaxToken keyword, SyntaxToken colonToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the default keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.keyword,
            1 => this.colonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DefaultSwitchLabelSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDefaultSwitchLabel(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDefaultSwitchLabel(this);

    public DefaultSwitchLabelSyntax Update(SyntaxToken keyword, SyntaxToken colonToken)
    {
        if (keyword != this.Keyword || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.DefaultSwitchLabel(keyword, colonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DefaultSwitchLabelSyntax(this.Kind, this.keyword, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DefaultSwitchLabelSyntax(this.Kind, this.keyword, this.colonToken, GetDiagnostics(), annotations);
}

internal sealed partial class SwitchExpressionSyntax : ExpressionSyntax
{
    internal readonly ExpressionSyntax governingExpression;
    internal readonly SyntaxToken switchKeyword;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? arms;
    internal readonly SyntaxToken closeBraceToken;

    internal SwitchExpressionSyntax(SyntaxKind kind, ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, GreenNode? arms, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(governingExpression);
        this.governingExpression = governingExpression;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (arms != null)
        {
            this.AdjustFlagsAndWidth(arms);
            this.arms = arms;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal SwitchExpressionSyntax(SyntaxKind kind, ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, GreenNode? arms, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(governingExpression);
        this.governingExpression = governingExpression;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (arms != null)
        {
            this.AdjustFlagsAndWidth(arms);
            this.arms = arms;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal SwitchExpressionSyntax(SyntaxKind kind, ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, GreenNode? arms, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(governingExpression);
        this.governingExpression = governingExpression;
        this.AdjustFlagsAndWidth(switchKeyword);
        this.switchKeyword = switchKeyword;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (arms != null)
        {
            this.AdjustFlagsAndWidth(arms);
            this.arms = arms;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public ExpressionSyntax GoverningExpression => this.governingExpression;
    public SyntaxToken SwitchKeyword => this.switchKeyword;
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public CoreSyntax.SeparatedSyntaxList<SwitchExpressionArmSyntax> Arms => new CoreSyntax.SeparatedSyntaxList<SwitchExpressionArmSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.arms));
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.governingExpression,
            1 => this.switchKeyword,
            2 => this.openBraceToken,
            3 => this.arms,
            4 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SwitchExpressionSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchExpression(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchExpression(this);

    public SwitchExpressionSyntax Update(ExpressionSyntax governingExpression, SyntaxToken switchKeyword, SyntaxToken openBraceToken, CoreSyntax.SeparatedSyntaxList<SwitchExpressionArmSyntax> arms, SyntaxToken closeBraceToken)
    {
        if (governingExpression != this.GoverningExpression || switchKeyword != this.SwitchKeyword || openBraceToken != this.OpenBraceToken || arms != this.Arms || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.SwitchExpression(governingExpression, switchKeyword, openBraceToken, arms, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SwitchExpressionSyntax(this.Kind, this.governingExpression, this.switchKeyword, this.openBraceToken, this.arms, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SwitchExpressionSyntax(this.Kind, this.governingExpression, this.switchKeyword, this.openBraceToken, this.arms, this.closeBraceToken, GetDiagnostics(), annotations);
}

internal sealed partial class SwitchExpressionArmSyntax : CSharpSyntaxNode
{
    internal readonly PatternSyntax pattern;
    internal readonly WhenClauseSyntax? whenClause;
    internal readonly SyntaxToken equalsGreaterThanToken;
    internal readonly ExpressionSyntax expression;

    internal SwitchExpressionArmSyntax(SyntaxKind kind, PatternSyntax pattern, WhenClauseSyntax? whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(equalsGreaterThanToken);
        this.equalsGreaterThanToken = equalsGreaterThanToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal SwitchExpressionArmSyntax(SyntaxKind kind, PatternSyntax pattern, WhenClauseSyntax? whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(equalsGreaterThanToken);
        this.equalsGreaterThanToken = equalsGreaterThanToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal SwitchExpressionArmSyntax(SyntaxKind kind, PatternSyntax pattern, WhenClauseSyntax? whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(pattern);
        this.pattern = pattern;
        if (whenClause != null)
        {
            this.AdjustFlagsAndWidth(whenClause);
            this.whenClause = whenClause;
        }
        this.AdjustFlagsAndWidth(equalsGreaterThanToken);
        this.equalsGreaterThanToken = equalsGreaterThanToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public PatternSyntax Pattern => this.pattern;
    public WhenClauseSyntax? WhenClause => this.whenClause;
    public SyntaxToken EqualsGreaterThanToken => this.equalsGreaterThanToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.pattern,
            1 => this.whenClause,
            2 => this.equalsGreaterThanToken,
            3 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SwitchExpressionArmSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSwitchExpressionArm(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSwitchExpressionArm(this);

    public SwitchExpressionArmSyntax Update(PatternSyntax pattern, WhenClauseSyntax whenClause, SyntaxToken equalsGreaterThanToken, ExpressionSyntax expression)
    {
        if (pattern != this.Pattern || whenClause != this.WhenClause || equalsGreaterThanToken != this.EqualsGreaterThanToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.SwitchExpressionArm(pattern, whenClause, equalsGreaterThanToken, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SwitchExpressionArmSyntax(this.Kind, this.pattern, this.whenClause, this.equalsGreaterThanToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SwitchExpressionArmSyntax(this.Kind, this.pattern, this.whenClause, this.equalsGreaterThanToken, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class TryStatementSyntax : StatementSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken tryKeyword;
    internal readonly BlockSyntax block;
    internal readonly GreenNode? catches;
    internal readonly FinallyClauseSyntax? @finally;

    internal TryStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken tryKeyword, BlockSyntax block, GreenNode? catches, FinallyClauseSyntax? @finally, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(tryKeyword);
        this.tryKeyword = tryKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (catches != null)
        {
            this.AdjustFlagsAndWidth(catches);
            this.catches = catches;
        }
        if (@finally != null)
        {
            this.AdjustFlagsAndWidth(@finally);
            this.@finally = @finally;
        }
    }

    internal TryStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken tryKeyword, BlockSyntax block, GreenNode? catches, FinallyClauseSyntax? @finally, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(tryKeyword);
        this.tryKeyword = tryKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (catches != null)
        {
            this.AdjustFlagsAndWidth(catches);
            this.catches = catches;
        }
        if (@finally != null)
        {
            this.AdjustFlagsAndWidth(@finally);
            this.@finally = @finally;
        }
    }

    internal TryStatementSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken tryKeyword, BlockSyntax block, GreenNode? catches, FinallyClauseSyntax? @finally)
      : base(kind)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        this.AdjustFlagsAndWidth(tryKeyword);
        this.tryKeyword = tryKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
        if (catches != null)
        {
            this.AdjustFlagsAndWidth(catches);
            this.catches = catches;
        }
        if (@finally != null)
        {
            this.AdjustFlagsAndWidth(@finally);
            this.@finally = @finally;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken TryKeyword => this.tryKeyword;
    public BlockSyntax Block => this.block;
    public CoreSyntax.SyntaxList<CatchClauseSyntax> Catches => new CoreSyntax.SyntaxList<CatchClauseSyntax>(this.catches);
    public FinallyClauseSyntax? Finally => this.@finally;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.tryKeyword,
            2 => this.block,
            3 => this.catches,
            4 => this.@finally,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TryStatementSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTryStatement(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTryStatement(this);

    public TryStatementSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken tryKeyword, BlockSyntax block, CoreSyntax.SyntaxList<CatchClauseSyntax> catches, FinallyClauseSyntax @finally)
    {
        if (attributeLists != this.AttributeLists || tryKeyword != this.TryKeyword || block != this.Block || catches != this.Catches || @finally != this.Finally)
        {
            var newNode = SyntaxFactory.TryStatement(attributeLists, tryKeyword, block, catches, @finally);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TryStatementSyntax(this.Kind, this.attributeLists, this.tryKeyword, this.block, this.catches, this.@finally, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TryStatementSyntax(this.Kind, this.attributeLists, this.tryKeyword, this.block, this.catches, this.@finally, GetDiagnostics(), annotations);
}

internal sealed partial class CatchClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken catchKeyword;
    internal readonly CatchDeclarationSyntax? declaration;
    internal readonly CatchFilterClauseSyntax? filter;
    internal readonly BlockSyntax block;

    internal CatchClauseSyntax(SyntaxKind kind, SyntaxToken catchKeyword, CatchDeclarationSyntax? declaration, CatchFilterClauseSyntax? filter, BlockSyntax block, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(catchKeyword);
        this.catchKeyword = catchKeyword;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (filter != null)
        {
            this.AdjustFlagsAndWidth(filter);
            this.filter = filter;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal CatchClauseSyntax(SyntaxKind kind, SyntaxToken catchKeyword, CatchDeclarationSyntax? declaration, CatchFilterClauseSyntax? filter, BlockSyntax block, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(catchKeyword);
        this.catchKeyword = catchKeyword;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (filter != null)
        {
            this.AdjustFlagsAndWidth(filter);
            this.filter = filter;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal CatchClauseSyntax(SyntaxKind kind, SyntaxToken catchKeyword, CatchDeclarationSyntax? declaration, CatchFilterClauseSyntax? filter, BlockSyntax block)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(catchKeyword);
        this.catchKeyword = catchKeyword;
        if (declaration != null)
        {
            this.AdjustFlagsAndWidth(declaration);
            this.declaration = declaration;
        }
        if (filter != null)
        {
            this.AdjustFlagsAndWidth(filter);
            this.filter = filter;
        }
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public SyntaxToken CatchKeyword => this.catchKeyword;
    public CatchDeclarationSyntax? Declaration => this.declaration;
    public CatchFilterClauseSyntax? Filter => this.filter;
    public BlockSyntax Block => this.block;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.catchKeyword,
            1 => this.declaration,
            2 => this.filter,
            3 => this.block,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CatchClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCatchClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCatchClause(this);

    public CatchClauseSyntax Update(SyntaxToken catchKeyword, CatchDeclarationSyntax declaration, CatchFilterClauseSyntax filter, BlockSyntax block)
    {
        if (catchKeyword != this.CatchKeyword || declaration != this.Declaration || filter != this.Filter || block != this.Block)
        {
            var newNode = SyntaxFactory.CatchClause(catchKeyword, declaration, filter, block);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CatchClauseSyntax(this.Kind, this.catchKeyword, this.declaration, this.filter, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CatchClauseSyntax(this.Kind, this.catchKeyword, this.declaration, this.filter, this.block, GetDiagnostics(), annotations);
}

internal sealed partial class CatchDeclarationSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openParenToken;
    internal readonly TypeSyntax type;
    internal readonly SyntaxToken? identifier;
    internal readonly SyntaxToken closeParenToken;

    internal CatchDeclarationSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken? identifier, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CatchDeclarationSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken? identifier, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CatchDeclarationSyntax(SyntaxKind kind, SyntaxToken openParenToken, TypeSyntax type, SyntaxToken? identifier, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (identifier != null)
        {
            this.AdjustFlagsAndWidth(identifier);
            this.identifier = identifier;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken OpenParenToken => this.openParenToken;
    public TypeSyntax Type => this.type;
    public SyntaxToken? Identifier => this.identifier;
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.type,
            2 => this.identifier,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CatchDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCatchDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCatchDeclaration(this);

    public CatchDeclarationSyntax Update(SyntaxToken openParenToken, TypeSyntax type, SyntaxToken identifier, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || type != this.Type || identifier != this.Identifier || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CatchDeclaration(openParenToken, type, identifier, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CatchDeclarationSyntax(this.Kind, this.openParenToken, this.type, this.identifier, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CatchDeclarationSyntax(this.Kind, this.openParenToken, this.type, this.identifier, this.closeParenToken, GetDiagnostics(), annotations);
}

internal sealed partial class CatchFilterClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken whenKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly ExpressionSyntax filterExpression;
    internal readonly SyntaxToken closeParenToken;

    internal CatchFilterClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(filterExpression);
        this.filterExpression = filterExpression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CatchFilterClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(filterExpression);
        this.filterExpression = filterExpression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CatchFilterClauseSyntax(SyntaxKind kind, SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whenKeyword);
        this.whenKeyword = whenKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(filterExpression);
        this.filterExpression = filterExpression;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    public SyntaxToken WhenKeyword => this.whenKeyword;
    public SyntaxToken OpenParenToken => this.openParenToken;
    public ExpressionSyntax FilterExpression => this.filterExpression;
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.whenKeyword,
            1 => this.openParenToken,
            2 => this.filterExpression,
            3 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CatchFilterClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCatchFilterClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCatchFilterClause(this);

    public CatchFilterClauseSyntax Update(SyntaxToken whenKeyword, SyntaxToken openParenToken, ExpressionSyntax filterExpression, SyntaxToken closeParenToken)
    {
        if (whenKeyword != this.WhenKeyword || openParenToken != this.OpenParenToken || filterExpression != this.FilterExpression || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CatchFilterClause(whenKeyword, openParenToken, filterExpression, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CatchFilterClauseSyntax(this.Kind, this.whenKeyword, this.openParenToken, this.filterExpression, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CatchFilterClauseSyntax(this.Kind, this.whenKeyword, this.openParenToken, this.filterExpression, this.closeParenToken, GetDiagnostics(), annotations);
}

internal sealed partial class FinallyClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken finallyKeyword;
    internal readonly BlockSyntax block;

    internal FinallyClauseSyntax(SyntaxKind kind, SyntaxToken finallyKeyword, BlockSyntax block, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(finallyKeyword);
        this.finallyKeyword = finallyKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal FinallyClauseSyntax(SyntaxKind kind, SyntaxToken finallyKeyword, BlockSyntax block, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(finallyKeyword);
        this.finallyKeyword = finallyKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    internal FinallyClauseSyntax(SyntaxKind kind, SyntaxToken finallyKeyword, BlockSyntax block)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(finallyKeyword);
        this.finallyKeyword = finallyKeyword;
        this.AdjustFlagsAndWidth(block);
        this.block = block;
    }

    public SyntaxToken FinallyKeyword => this.finallyKeyword;
    public BlockSyntax Block => this.block;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.finallyKeyword,
            1 => this.block,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FinallyClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFinallyClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFinallyClause(this);

    public FinallyClauseSyntax Update(SyntaxToken finallyKeyword, BlockSyntax block)
    {
        if (finallyKeyword != this.FinallyKeyword || block != this.Block)
        {
            var newNode = SyntaxFactory.FinallyClause(finallyKeyword, block);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FinallyClauseSyntax(this.Kind, this.finallyKeyword, this.block, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FinallyClauseSyntax(this.Kind, this.finallyKeyword, this.block, GetDiagnostics(), annotations);
}

internal sealed partial class CompilationUnitSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode? externs;
    internal readonly GreenNode? usings;
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken endOfFileToken;

    internal CompilationUnitSyntax(SyntaxKind kind, GreenNode? externs, GreenNode? usings, GreenNode? attributeLists, GreenNode? members, SyntaxToken endOfFileToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(endOfFileToken);
        this.endOfFileToken = endOfFileToken;
    }

    internal CompilationUnitSyntax(SyntaxKind kind, GreenNode? externs, GreenNode? usings, GreenNode? attributeLists, GreenNode? members, SyntaxToken endOfFileToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(endOfFileToken);
        this.endOfFileToken = endOfFileToken;
    }

    internal CompilationUnitSyntax(SyntaxKind kind, GreenNode? externs, GreenNode? usings, GreenNode? attributeLists, GreenNode? members, SyntaxToken endOfFileToken)
      : base(kind)
    {
        this.SlotCount = 5;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(endOfFileToken);
        this.endOfFileToken = endOfFileToken;
    }

    public CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> Externs => new CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax>(this.externs);
    public CoreSyntax.SyntaxList<UsingDirectiveSyntax> Usings => new CoreSyntax.SyntaxList<UsingDirectiveSyntax>(this.usings);
    /// <summary>Gets the attribute declaration list.</summary>
    public CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public SyntaxToken EndOfFileToken => this.endOfFileToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.externs,
            1 => this.usings,
            2 => this.attributeLists,
            3 => this.members,
            4 => this.endOfFileToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CompilationUnitSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCompilationUnit(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCompilationUnit(this);

    public CompilationUnitSyntax Update(CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> externs, CoreSyntax.SyntaxList<UsingDirectiveSyntax> usings, CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken endOfFileToken)
    {
        if (externs != this.Externs || usings != this.Usings || attributeLists != this.AttributeLists || members != this.Members || endOfFileToken != this.EndOfFileToken)
        {
            var newNode = SyntaxFactory.CompilationUnit(externs, usings, attributeLists, members, endOfFileToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CompilationUnitSyntax(this.Kind, this.externs, this.usings, this.attributeLists, this.members, this.endOfFileToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new CompilationUnitSyntax(this.Kind, this.externs, this.usings, this.attributeLists, this.members, this.endOfFileToken, GetDiagnostics(), annotations);
}

/// <summary>
/// Represents an ExternAlias directive syntax, e.g. "extern alias MyAlias;" with specifying "/r:MyAlias=SomeAssembly.dll " on the compiler command line.
/// </summary>
internal sealed partial class ExternAliasDirectiveSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken externKeyword;
    internal readonly SyntaxToken aliasKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken semicolonToken;

    internal ExternAliasDirectiveSyntax(SyntaxKind kind, SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(externKeyword);
        this.externKeyword = externKeyword;
        this.AdjustFlagsAndWidth(aliasKeyword);
        this.aliasKeyword = aliasKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ExternAliasDirectiveSyntax(SyntaxKind kind, SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(externKeyword);
        this.externKeyword = externKeyword;
        this.AdjustFlagsAndWidth(aliasKeyword);
        this.aliasKeyword = aliasKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal ExternAliasDirectiveSyntax(SyntaxKind kind, SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(externKeyword);
        this.externKeyword = externKeyword;
        this.AdjustFlagsAndWidth(aliasKeyword);
        this.aliasKeyword = aliasKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    /// <summary>SyntaxToken representing the extern keyword.</summary>
    public SyntaxToken ExternKeyword => this.externKeyword;
    /// <summary>SyntaxToken representing the alias keyword.</summary>
    public SyntaxToken AliasKeyword => this.aliasKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    /// <summary>SyntaxToken representing the semicolon token.</summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.externKeyword,
            1 => this.aliasKeyword,
            2 => this.identifier,
            3 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ExternAliasDirectiveSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExternAliasDirective(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExternAliasDirective(this);

    public ExternAliasDirectiveSyntax Update(SyntaxToken externKeyword, SyntaxToken aliasKeyword, SyntaxToken identifier, SyntaxToken semicolonToken)
    {
        if (externKeyword != this.ExternKeyword || aliasKeyword != this.AliasKeyword || identifier != this.Identifier || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ExternAliasDirective(externKeyword, aliasKeyword, identifier, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ExternAliasDirectiveSyntax(this.Kind, this.externKeyword, this.aliasKeyword, this.identifier, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ExternAliasDirectiveSyntax(this.Kind, this.externKeyword, this.aliasKeyword, this.identifier, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class UsingDirectiveSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken? globalKeyword;
    internal readonly SyntaxToken usingKeyword;
    internal readonly SyntaxToken? staticKeyword;
    internal readonly SyntaxToken? unsafeKeyword;
    internal readonly NameEqualsSyntax? alias;
    internal readonly TypeSyntax namespaceOrType;
    internal readonly SyntaxToken semicolonToken;

    internal UsingDirectiveSyntax(SyntaxKind kind, SyntaxToken? globalKeyword, SyntaxToken usingKeyword, SyntaxToken? staticKeyword, SyntaxToken? unsafeKeyword, NameEqualsSyntax? alias, TypeSyntax namespaceOrType, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 7;
        if (globalKeyword != null)
        {
            this.AdjustFlagsAndWidth(globalKeyword);
            this.globalKeyword = globalKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        if (staticKeyword != null)
        {
            this.AdjustFlagsAndWidth(staticKeyword);
            this.staticKeyword = staticKeyword;
        }
        if (unsafeKeyword != null)
        {
            this.AdjustFlagsAndWidth(unsafeKeyword);
            this.unsafeKeyword = unsafeKeyword;
        }
        if (alias != null)
        {
            this.AdjustFlagsAndWidth(alias);
            this.alias = alias;
        }
        this.AdjustFlagsAndWidth(namespaceOrType);
        this.namespaceOrType = namespaceOrType;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal UsingDirectiveSyntax(SyntaxKind kind, SyntaxToken? globalKeyword, SyntaxToken usingKeyword, SyntaxToken? staticKeyword, SyntaxToken? unsafeKeyword, NameEqualsSyntax? alias, TypeSyntax namespaceOrType, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 7;
        if (globalKeyword != null)
        {
            this.AdjustFlagsAndWidth(globalKeyword);
            this.globalKeyword = globalKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        if (staticKeyword != null)
        {
            this.AdjustFlagsAndWidth(staticKeyword);
            this.staticKeyword = staticKeyword;
        }
        if (unsafeKeyword != null)
        {
            this.AdjustFlagsAndWidth(unsafeKeyword);
            this.unsafeKeyword = unsafeKeyword;
        }
        if (alias != null)
        {
            this.AdjustFlagsAndWidth(alias);
            this.alias = alias;
        }
        this.AdjustFlagsAndWidth(namespaceOrType);
        this.namespaceOrType = namespaceOrType;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal UsingDirectiveSyntax(SyntaxKind kind, SyntaxToken? globalKeyword, SyntaxToken usingKeyword, SyntaxToken? staticKeyword, SyntaxToken? unsafeKeyword, NameEqualsSyntax? alias, TypeSyntax namespaceOrType, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 7;
        if (globalKeyword != null)
        {
            this.AdjustFlagsAndWidth(globalKeyword);
            this.globalKeyword = globalKeyword;
        }
        this.AdjustFlagsAndWidth(usingKeyword);
        this.usingKeyword = usingKeyword;
        if (staticKeyword != null)
        {
            this.AdjustFlagsAndWidth(staticKeyword);
            this.staticKeyword = staticKeyword;
        }
        if (unsafeKeyword != null)
        {
            this.AdjustFlagsAndWidth(unsafeKeyword);
            this.unsafeKeyword = unsafeKeyword;
        }
        if (alias != null)
        {
            this.AdjustFlagsAndWidth(alias);
            this.alias = alias;
        }
        this.AdjustFlagsAndWidth(namespaceOrType);
        this.namespaceOrType = namespaceOrType;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public SyntaxToken? GlobalKeyword => this.globalKeyword;
    public SyntaxToken UsingKeyword => this.usingKeyword;
    public SyntaxToken? StaticKeyword => this.staticKeyword;
    public SyntaxToken? UnsafeKeyword => this.unsafeKeyword;
    public NameEqualsSyntax? Alias => this.alias;
    public TypeSyntax NamespaceOrType => this.namespaceOrType;
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.globalKeyword,
            1 => this.usingKeyword,
            2 => this.staticKeyword,
            3 => this.unsafeKeyword,
            4 => this.alias,
            5 => this.namespaceOrType,
            6 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.UsingDirectiveSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitUsingDirective(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitUsingDirective(this);

    public UsingDirectiveSyntax Update(SyntaxToken globalKeyword, SyntaxToken usingKeyword, SyntaxToken staticKeyword, SyntaxToken unsafeKeyword, NameEqualsSyntax alias, TypeSyntax namespaceOrType, SyntaxToken semicolonToken)
    {
        if (globalKeyword != this.GlobalKeyword || usingKeyword != this.UsingKeyword || staticKeyword != this.StaticKeyword || unsafeKeyword != this.UnsafeKeyword || alias != this.Alias || namespaceOrType != this.NamespaceOrType || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.UsingDirective(globalKeyword, usingKeyword, staticKeyword, unsafeKeyword, alias, namespaceOrType, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new UsingDirectiveSyntax(this.Kind, this.globalKeyword, this.usingKeyword, this.staticKeyword, this.unsafeKeyword, this.alias, this.namespaceOrType, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new UsingDirectiveSyntax(this.Kind, this.globalKeyword, this.usingKeyword, this.staticKeyword, this.unsafeKeyword, this.alias, this.namespaceOrType, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Member declaration syntax.</summary>
internal abstract partial class MemberDeclarationSyntax : CSharpSyntaxNode
{
    internal MemberDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal MemberDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract CoreSyntax.SyntaxList<SyntaxToken> Modifiers { get; }
}

internal abstract partial class BaseNamespaceDeclarationSyntax : MemberDeclarationSyntax
{
    internal BaseNamespaceDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseNamespaceDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract SyntaxToken NamespaceKeyword { get; }

    public abstract NameSyntax Name { get; }

    public abstract CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> Externs { get; }

    public abstract CoreSyntax.SyntaxList<UsingDirectiveSyntax> Usings { get; }

    public abstract CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members { get; }
}

internal sealed partial class NamespaceDeclarationSyntax : BaseNamespaceDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken namespaceKeyword;
    internal readonly NameSyntax name;
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? externs;
    internal readonly GreenNode? usings;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken closeBraceToken;
    internal readonly SyntaxToken? semicolonToken;

    internal NamespaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, GreenNode? externs, GreenNode? usings, GreenNode? members, SyntaxToken closeBraceToken, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal NamespaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, GreenNode? externs, GreenNode? usings, GreenNode? members, SyntaxToken closeBraceToken, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal NamespaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, GreenNode? externs, GreenNode? usings, GreenNode? members, SyntaxToken closeBraceToken, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 10;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override SyntaxToken NamespaceKeyword => this.namespaceKeyword;
    public override NameSyntax Name => this.name;
    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public override CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> Externs => new CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax>(this.externs);
    public override CoreSyntax.SyntaxList<UsingDirectiveSyntax> Usings => new CoreSyntax.SyntaxList<UsingDirectiveSyntax>(this.usings);
    public override CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public SyntaxToken CloseBraceToken => this.closeBraceToken;
    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.namespaceKeyword,
            3 => this.name,
            4 => this.openBraceToken,
            5 => this.externs,
            6 => this.usings,
            7 => this.members,
            8 => this.closeBraceToken,
            9 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.NamespaceDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNamespaceDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNamespaceDeclaration(this);

    public NamespaceDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> externs, CoreSyntax.SyntaxList<UsingDirectiveSyntax> usings, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || namespaceKeyword != this.NamespaceKeyword || name != this.Name || openBraceToken != this.OpenBraceToken || externs != this.Externs || usings != this.Usings || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.NamespaceDeclaration(attributeLists, modifiers, namespaceKeyword, name, openBraceToken, externs, usings, members, closeBraceToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new NamespaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.namespaceKeyword, this.name, this.openBraceToken, this.externs, this.usings, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new NamespaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.namespaceKeyword, this.name, this.openBraceToken, this.externs, this.usings, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class FileScopedNamespaceDeclarationSyntax : BaseNamespaceDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken namespaceKeyword;
    internal readonly NameSyntax name;
    internal readonly SyntaxToken semicolonToken;
    internal readonly GreenNode? externs;
    internal readonly GreenNode? usings;
    internal readonly GreenNode? members;

    internal FileScopedNamespaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken semicolonToken, GreenNode? externs, GreenNode? usings, GreenNode? members, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
    }

    internal FileScopedNamespaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken semicolonToken, GreenNode? externs, GreenNode? usings, GreenNode? members, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
    }

    internal FileScopedNamespaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken semicolonToken, GreenNode? externs, GreenNode? usings, GreenNode? members)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(namespaceKeyword);
        this.namespaceKeyword = namespaceKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
        if (externs != null)
        {
            this.AdjustFlagsAndWidth(externs);
            this.externs = externs;
        }
        if (usings != null)
        {
            this.AdjustFlagsAndWidth(usings);
            this.usings = usings;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override SyntaxToken NamespaceKeyword => this.namespaceKeyword;
    public override NameSyntax Name => this.name;
    public SyntaxToken SemicolonToken => this.semicolonToken;
    public override CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> Externs => new CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax>(this.externs);
    public override CoreSyntax.SyntaxList<UsingDirectiveSyntax> Usings => new CoreSyntax.SyntaxList<UsingDirectiveSyntax>(this.usings);
    public override CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.namespaceKeyword,
            3 => this.name,
            4 => this.semicolonToken,
            5 => this.externs,
            6 => this.usings,
            7 => this.members,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FileScopedNamespaceDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFileScopedNamespaceDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFileScopedNamespaceDeclaration(this);

    public FileScopedNamespaceDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken namespaceKeyword, NameSyntax name, SyntaxToken semicolonToken, CoreSyntax.SyntaxList<ExternAliasDirectiveSyntax> externs, CoreSyntax.SyntaxList<UsingDirectiveSyntax> usings, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || namespaceKeyword != this.NamespaceKeyword || name != this.Name || semicolonToken != this.SemicolonToken || externs != this.Externs || usings != this.Usings || members != this.Members)
        {
            var newNode = SyntaxFactory.FileScopedNamespaceDeclaration(attributeLists, modifiers, namespaceKeyword, name, semicolonToken, externs, usings, members);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FileScopedNamespaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.namespaceKeyword, this.name, this.semicolonToken, this.externs, this.usings, this.members, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FileScopedNamespaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.namespaceKeyword, this.name, this.semicolonToken, this.externs, this.usings, this.members, GetDiagnostics(), annotations);
}

/// <summary>Class representing one or more attributes applied to a language construct.</summary>
internal sealed partial class AttributeListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly AttributeTargetSpecifierSyntax? target;
    internal readonly GreenNode? attributes;
    internal readonly SyntaxToken closeBracketToken;

    internal AttributeListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax? target, GreenNode? attributes, SyntaxToken closeBracketToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (target != null)
        {
            this.AdjustFlagsAndWidth(target);
            this.target = target;
        }
        if (attributes != null)
        {
            this.AdjustFlagsAndWidth(attributes);
            this.attributes = attributes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal AttributeListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax? target, GreenNode? attributes, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (target != null)
        {
            this.AdjustFlagsAndWidth(target);
            this.target = target;
        }
        if (attributes != null)
        {
            this.AdjustFlagsAndWidth(attributes);
            this.attributes = attributes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal AttributeListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax? target, GreenNode? attributes, SyntaxToken closeBracketToken)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (target != null)
        {
            this.AdjustFlagsAndWidth(target);
            this.target = target;
        }
        if (attributes != null)
        {
            this.AdjustFlagsAndWidth(attributes);
            this.attributes = attributes;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    /// <summary>Gets the open bracket token.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    /// <summary>Gets the optional construct targeted by the attribute.</summary>
    public AttributeTargetSpecifierSyntax? Target => this.target;
    /// <summary>Gets the attribute declaration list.</summary>
    public CoreSyntax.SeparatedSyntaxList<AttributeSyntax> Attributes => new CoreSyntax.SeparatedSyntaxList<AttributeSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.attributes));
    /// <summary>Gets the close bracket token.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.target,
            2 => this.attributes,
            3 => this.closeBracketToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AttributeListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeList(this);

    public AttributeListSyntax Update(SyntaxToken openBracketToken, AttributeTargetSpecifierSyntax target, CoreSyntax.SeparatedSyntaxList<AttributeSyntax> attributes, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || target != this.Target || attributes != this.Attributes || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.AttributeList(openBracketToken, target, attributes, closeBracketToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AttributeListSyntax(this.Kind, this.openBracketToken, this.target, this.attributes, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AttributeListSyntax(this.Kind, this.openBracketToken, this.target, this.attributes, this.closeBracketToken, GetDiagnostics(), annotations);
}

/// <summary>Class representing what language construct an attribute targets.</summary>
internal sealed partial class AttributeTargetSpecifierSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken identifier;
    internal readonly SyntaxToken colonToken;

    internal AttributeTargetSpecifierSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal AttributeTargetSpecifierSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    internal AttributeTargetSpecifierSyntax(SyntaxKind kind, SyntaxToken identifier, SyntaxToken colonToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
    }

    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.identifier,
            1 => this.colonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AttributeTargetSpecifierSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeTargetSpecifier(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeTargetSpecifier(this);

    public AttributeTargetSpecifierSyntax Update(SyntaxToken identifier, SyntaxToken colonToken)
    {
        if (identifier != this.Identifier || colonToken != this.ColonToken)
        {
            var newNode = SyntaxFactory.AttributeTargetSpecifier(identifier, colonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AttributeTargetSpecifierSyntax(this.Kind, this.identifier, this.colonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AttributeTargetSpecifierSyntax(this.Kind, this.identifier, this.colonToken, GetDiagnostics(), annotations);
}

/// <summary>Attribute syntax.</summary>
internal sealed partial class AttributeSyntax : CSharpSyntaxNode
{
    internal readonly NameSyntax name;
    internal readonly AttributeArgumentListSyntax? argumentList;

    internal AttributeSyntax(SyntaxKind kind, NameSyntax name, AttributeArgumentListSyntax? argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        SetFlags(NodeFlags.ContainsAttributes);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
    }

    internal AttributeSyntax(SyntaxKind kind, NameSyntax name, AttributeArgumentListSyntax? argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        SetFlags(NodeFlags.ContainsAttributes);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
    }

    internal AttributeSyntax(SyntaxKind kind, NameSyntax name, AttributeArgumentListSyntax? argumentList)
      : base(kind)
    {
        SetFlags(NodeFlags.ContainsAttributes);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (argumentList != null)
        {
            this.AdjustFlagsAndWidth(argumentList);
            this.argumentList = argumentList;
        }
    }

    /// <summary>Gets the name.</summary>
    public NameSyntax Name => this.name;
    public AttributeArgumentListSyntax? ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.name,
            1 => this.argumentList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AttributeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttribute(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttribute(this);

    public AttributeSyntax Update(NameSyntax name, AttributeArgumentListSyntax argumentList)
    {
        if (name != this.Name || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.Attribute(name, argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AttributeSyntax(this.Kind, this.name, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AttributeSyntax(this.Kind, this.name, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Attribute argument list syntax.</summary>
internal sealed partial class AttributeArgumentListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? arguments;
    internal readonly SyntaxToken closeParenToken;

    internal AttributeArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal AttributeArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal AttributeArgumentListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? arguments, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (arguments != null)
        {
            this.AdjustFlagsAndWidth(arguments);
            this.arguments = arguments;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Gets the arguments syntax list.</summary>
    public CoreSyntax.SeparatedSyntaxList<AttributeArgumentSyntax> Arguments => new CoreSyntax.SeparatedSyntaxList<AttributeArgumentSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.arguments));
    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.arguments,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AttributeArgumentListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeArgumentList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeArgumentList(this);

    public AttributeArgumentListSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<AttributeArgumentSyntax> arguments, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || arguments != this.Arguments || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.AttributeArgumentList(openParenToken, arguments, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AttributeArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AttributeArgumentListSyntax(this.Kind, this.openParenToken, this.arguments, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Attribute argument syntax.</summary>
internal sealed partial class AttributeArgumentSyntax : CSharpSyntaxNode
{
    internal readonly NameEqualsSyntax? nameEquals;
    internal readonly NameColonSyntax? nameColon;
    internal readonly ExpressionSyntax expression;

    internal AttributeArgumentSyntax(SyntaxKind kind, NameEqualsSyntax? nameEquals, NameColonSyntax? nameColon, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal AttributeArgumentSyntax(SyntaxKind kind, NameEqualsSyntax? nameEquals, NameColonSyntax? nameColon, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal AttributeArgumentSyntax(SyntaxKind kind, NameEqualsSyntax? nameEquals, NameColonSyntax? nameColon, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 3;
        if (nameEquals != null)
        {
            this.AdjustFlagsAndWidth(nameEquals);
            this.nameEquals = nameEquals;
        }
        if (nameColon != null)
        {
            this.AdjustFlagsAndWidth(nameColon);
            this.nameColon = nameColon;
        }
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public NameEqualsSyntax? NameEquals => this.nameEquals;
    public NameColonSyntax? NameColon => this.nameColon;
    /// <summary>Gets the expression.</summary>
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.nameEquals,
            1 => this.nameColon,
            2 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AttributeArgumentSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAttributeArgument(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAttributeArgument(this);

    public AttributeArgumentSyntax Update(NameEqualsSyntax nameEquals, NameColonSyntax nameColon, ExpressionSyntax expression)
    {
        if (nameEquals != this.NameEquals || nameColon != this.NameColon || expression != this.Expression)
        {
            var newNode = SyntaxFactory.AttributeArgument(nameEquals, nameColon, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AttributeArgumentSyntax(this.Kind, this.nameEquals, this.nameColon, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AttributeArgumentSyntax(this.Kind, this.nameEquals, this.nameColon, this.expression, GetDiagnostics(), annotations);
}

/// <summary>Class representing an identifier name followed by an equals token.</summary>
internal sealed partial class NameEqualsSyntax : CSharpSyntaxNode
{
    internal readonly IdentifierNameSyntax name;
    internal readonly SyntaxToken equalsToken;

    internal NameEqualsSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken equalsToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
    }

    internal NameEqualsSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken equalsToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
    }

    internal NameEqualsSyntax(SyntaxKind kind, IdentifierNameSyntax name, SyntaxToken equalsToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(equalsToken);
        this.equalsToken = equalsToken;
    }

    /// <summary>Gets the identifier name.</summary>
    public IdentifierNameSyntax Name => this.name;
    public SyntaxToken EqualsToken => this.equalsToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.name,
            1 => this.equalsToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.NameEqualsSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNameEquals(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNameEquals(this);

    public NameEqualsSyntax Update(IdentifierNameSyntax name, SyntaxToken equalsToken)
    {
        if (name != this.Name || equalsToken != this.EqualsToken)
        {
            var newNode = SyntaxFactory.NameEquals(name, equalsToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new NameEqualsSyntax(this.Kind, this.name, this.equalsToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new NameEqualsSyntax(this.Kind, this.name, this.equalsToken, GetDiagnostics(), annotations);
}

/// <summary>Type parameter list syntax.</summary>
internal sealed partial class TypeParameterListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken lessThanToken;
    internal readonly GreenNode? parameters;
    internal readonly SyntaxToken greaterThanToken;

    internal TypeParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? parameters, SyntaxToken greaterThanToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    internal TypeParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? parameters, SyntaxToken greaterThanToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    internal TypeParameterListSyntax(SyntaxKind kind, SyntaxToken lessThanToken, GreenNode? parameters, SyntaxToken greaterThanToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(lessThanToken);
        this.lessThanToken = lessThanToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(greaterThanToken);
        this.greaterThanToken = greaterThanToken;
    }

    /// <summary>Gets the &lt; token.</summary>
    public SyntaxToken LessThanToken => this.lessThanToken;
    /// <summary>Gets the parameter list.</summary>
    public CoreSyntax.SeparatedSyntaxList<TypeParameterSyntax> Parameters => new CoreSyntax.SeparatedSyntaxList<TypeParameterSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.parameters));
    /// <summary>Gets the &gt; token.</summary>
    public SyntaxToken GreaterThanToken => this.greaterThanToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.lessThanToken,
            1 => this.parameters,
            2 => this.greaterThanToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeParameterListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeParameterList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeParameterList(this);

    public TypeParameterListSyntax Update(SyntaxToken lessThanToken, CoreSyntax.SeparatedSyntaxList<TypeParameterSyntax> parameters, SyntaxToken greaterThanToken)
    {
        if (lessThanToken != this.LessThanToken || parameters != this.Parameters || greaterThanToken != this.GreaterThanToken)
        {
            var newNode = SyntaxFactory.TypeParameterList(lessThanToken, parameters, greaterThanToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeParameterListSyntax(this.Kind, this.lessThanToken, this.parameters, this.greaterThanToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeParameterListSyntax(this.Kind, this.lessThanToken, this.parameters, this.greaterThanToken, GetDiagnostics(), annotations);
}

/// <summary>Type parameter syntax.</summary>
internal sealed partial class TypeParameterSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode? attributeLists;
    internal readonly SyntaxToken? varianceKeyword;
    internal readonly SyntaxToken identifier;

    internal TypeParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? varianceKeyword, SyntaxToken identifier, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (varianceKeyword != null)
        {
            this.AdjustFlagsAndWidth(varianceKeyword);
            this.varianceKeyword = varianceKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal TypeParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? varianceKeyword, SyntaxToken identifier, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (varianceKeyword != null)
        {
            this.AdjustFlagsAndWidth(varianceKeyword);
            this.varianceKeyword = varianceKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    internal TypeParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, SyntaxToken? varianceKeyword, SyntaxToken identifier)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (varianceKeyword != null)
        {
            this.AdjustFlagsAndWidth(varianceKeyword);
            this.varianceKeyword = varianceKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public SyntaxToken? VarianceKeyword => this.varianceKeyword;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.varianceKeyword,
            2 => this.identifier,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeParameterSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeParameter(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeParameter(this);

    public TypeParameterSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, SyntaxToken varianceKeyword, SyntaxToken identifier)
    {
        if (attributeLists != this.AttributeLists || varianceKeyword != this.VarianceKeyword || identifier != this.Identifier)
        {
            var newNode = SyntaxFactory.TypeParameter(attributeLists, varianceKeyword, identifier);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeParameterSyntax(this.Kind, this.attributeLists, this.varianceKeyword, this.identifier, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeParameterSyntax(this.Kind, this.attributeLists, this.varianceKeyword, this.identifier, GetDiagnostics(), annotations);
}

/// <summary>Base class for type declaration syntax.</summary>
internal abstract partial class BaseTypeDeclarationSyntax : MemberDeclarationSyntax
{
    internal BaseTypeDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseTypeDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the identifier.</summary>
    public abstract SyntaxToken Identifier { get; }

    /// <summary>Gets the base type list.</summary>
    public abstract BaseListSyntax? BaseList { get; }

    /// <summary>Gets the open brace token.</summary>
    public abstract SyntaxToken? OpenBraceToken { get; }

    /// <summary>Gets the close brace token.</summary>
    public abstract SyntaxToken? CloseBraceToken { get; }

    /// <summary>Gets the optional semicolon token.</summary>
    public abstract SyntaxToken? SemicolonToken { get; }
}

/// <summary>Base class for type declaration syntax (class, struct, interface, record).</summary>
internal abstract partial class TypeDeclarationSyntax : BaseTypeDeclarationSyntax
{
    internal TypeDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal TypeDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the type keyword token ("class", "struct", "interface", "record").</summary>
    public abstract SyntaxToken Keyword { get; }

    public abstract TypeParameterListSyntax? TypeParameterList { get; }

    public abstract ParameterListSyntax? ParameterList { get; }

    /// <summary>Gets the type constraint list.</summary>
    public abstract CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses { get; }

    /// <summary>Gets the member declarations.</summary>
    public abstract CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members { get; }
}

/// <summary>Class type declaration syntax.</summary>
internal sealed partial class ClassDeclarationSyntax : TypeDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax? parameterList;
    internal readonly BaseListSyntax? baseList;
    internal readonly GreenNode? constraintClauses;
    internal readonly SyntaxToken? openBraceToken;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken? closeBraceToken;
    internal readonly SyntaxToken? semicolonToken;

    internal ClassDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal ClassDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal ClassDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the class keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    public override ParameterListSyntax? ParameterList => this.parameterList;
    public override BaseListSyntax? BaseList => this.baseList;
    public override CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken? OpenBraceToken => this.openBraceToken;
    public override CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken? CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.keyword,
            3 => this.identifier,
            4 => this.typeParameterList,
            5 => this.parameterList,
            6 => this.baseList,
            7 => this.constraintClauses,
            8 => this.openBraceToken,
            9 => this.members,
            10 => this.closeBraceToken,
            11 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ClassDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitClassDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitClassDeclaration(this);

    public ClassDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, BaseListSyntax baseList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ClassDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, parameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ClassDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ClassDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Struct type declaration syntax.</summary>
internal sealed partial class StructDeclarationSyntax : TypeDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax? parameterList;
    internal readonly BaseListSyntax? baseList;
    internal readonly GreenNode? constraintClauses;
    internal readonly SyntaxToken? openBraceToken;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken? closeBraceToken;
    internal readonly SyntaxToken? semicolonToken;

    internal StructDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal StructDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal StructDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the struct keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    public override ParameterListSyntax? ParameterList => this.parameterList;
    public override BaseListSyntax? BaseList => this.baseList;
    public override CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken? OpenBraceToken => this.openBraceToken;
    public override CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken? CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.keyword,
            3 => this.identifier,
            4 => this.typeParameterList,
            5 => this.parameterList,
            6 => this.baseList,
            7 => this.constraintClauses,
            8 => this.openBraceToken,
            9 => this.members,
            10 => this.closeBraceToken,
            11 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.StructDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitStructDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitStructDeclaration(this);

    public StructDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, BaseListSyntax baseList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.StructDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, parameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new StructDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new StructDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Interface type declaration syntax.</summary>
internal sealed partial class InterfaceDeclarationSyntax : TypeDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax? parameterList;
    internal readonly BaseListSyntax? baseList;
    internal readonly GreenNode? constraintClauses;
    internal readonly SyntaxToken? openBraceToken;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken? closeBraceToken;
    internal readonly SyntaxToken? semicolonToken;

    internal InterfaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal InterfaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal InterfaceDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 12;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the interface keyword token.</summary>
    public override SyntaxToken Keyword => this.keyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    public override ParameterListSyntax? ParameterList => this.parameterList;
    public override BaseListSyntax? BaseList => this.baseList;
    public override CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken? OpenBraceToken => this.openBraceToken;
    public override CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken? CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.keyword,
            3 => this.identifier,
            4 => this.typeParameterList,
            5 => this.parameterList,
            6 => this.baseList,
            7 => this.constraintClauses,
            8 => this.openBraceToken,
            9 => this.members,
            10 => this.closeBraceToken,
            11 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.InterfaceDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitInterfaceDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitInterfaceDeclaration(this);

    public InterfaceDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, BaseListSyntax baseList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.InterfaceDeclaration(attributeLists, modifiers, keyword, identifier, typeParameterList, parameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new InterfaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new InterfaceDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class RecordDeclarationSyntax : TypeDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly SyntaxToken? classOrStructKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax? parameterList;
    internal readonly BaseListSyntax? baseList;
    internal readonly GreenNode? constraintClauses;
    internal readonly SyntaxToken? openBraceToken;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken? closeBraceToken;
    internal readonly SyntaxToken? semicolonToken;

    internal RecordDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken? classOrStructKeyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 13;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        if (classOrStructKeyword != null)
        {
            this.AdjustFlagsAndWidth(classOrStructKeyword);
            this.classOrStructKeyword = classOrStructKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal RecordDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken? classOrStructKeyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 13;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        if (classOrStructKeyword != null)
        {
            this.AdjustFlagsAndWidth(classOrStructKeyword);
            this.classOrStructKeyword = classOrStructKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal RecordDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, SyntaxToken? classOrStructKeyword, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax? parameterList, BaseListSyntax? baseList, GreenNode? constraintClauses, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 13;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        if (classOrStructKeyword != null)
        {
            this.AdjustFlagsAndWidth(classOrStructKeyword);
            this.classOrStructKeyword = classOrStructKeyword;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        if (parameterList != null)
        {
            this.AdjustFlagsAndWidth(parameterList);
            this.parameterList = parameterList;
        }
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override SyntaxToken Keyword => this.keyword;
    public SyntaxToken? ClassOrStructKeyword => this.classOrStructKeyword;
    public override SyntaxToken Identifier => this.identifier;
    public override TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    public override ParameterListSyntax? ParameterList => this.parameterList;
    public override BaseListSyntax? BaseList => this.baseList;
    public override CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override SyntaxToken? OpenBraceToken => this.openBraceToken;
    public override CoreSyntax.SyntaxList<MemberDeclarationSyntax> Members => new CoreSyntax.SyntaxList<MemberDeclarationSyntax>(this.members);
    public override SyntaxToken? CloseBraceToken => this.closeBraceToken;
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.keyword,
            3 => this.classOrStructKeyword,
            4 => this.identifier,
            5 => this.typeParameterList,
            6 => this.parameterList,
            7 => this.baseList,
            8 => this.constraintClauses,
            9 => this.openBraceToken,
            10 => this.members,
            11 => this.closeBraceToken,
            12 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RecordDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRecordDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRecordDeclaration(this);

    public RecordDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, SyntaxToken classOrStructKeyword, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, BaseListSyntax baseList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken openBraceToken, CoreSyntax.SyntaxList<MemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || classOrStructKeyword != this.ClassOrStructKeyword || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || baseList != this.BaseList || constraintClauses != this.ConstraintClauses || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.RecordDeclaration(this.Kind, attributeLists, modifiers, keyword, classOrStructKeyword, identifier, typeParameterList, parameterList, baseList, constraintClauses, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RecordDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.classOrStructKeyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RecordDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.classOrStructKeyword, this.identifier, this.typeParameterList, this.parameterList, this.baseList, this.constraintClauses, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Enum type declaration syntax.</summary>
internal sealed partial class EnumDeclarationSyntax : BaseTypeDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken enumKeyword;
    internal readonly SyntaxToken identifier;
    internal readonly BaseListSyntax? baseList;
    internal readonly SyntaxToken? openBraceToken;
    internal readonly GreenNode? members;
    internal readonly SyntaxToken? closeBraceToken;
    internal readonly SyntaxToken? semicolonToken;

    internal EnumDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax? baseList, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(enumKeyword);
        this.enumKeyword = enumKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal EnumDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax? baseList, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(enumKeyword);
        this.enumKeyword = enumKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal EnumDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax? baseList, SyntaxToken? openBraceToken, GreenNode? members, SyntaxToken? closeBraceToken, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(enumKeyword);
        this.enumKeyword = enumKeyword;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (baseList != null)
        {
            this.AdjustFlagsAndWidth(baseList);
            this.baseList = baseList;
        }
        if (openBraceToken != null)
        {
            this.AdjustFlagsAndWidth(openBraceToken);
            this.openBraceToken = openBraceToken;
        }
        if (members != null)
        {
            this.AdjustFlagsAndWidth(members);
            this.members = members;
        }
        if (closeBraceToken != null)
        {
            this.AdjustFlagsAndWidth(closeBraceToken);
            this.closeBraceToken = closeBraceToken;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the enum keyword token.</summary>
    public SyntaxToken EnumKeyword => this.enumKeyword;
    public override SyntaxToken Identifier => this.identifier;
    public override BaseListSyntax? BaseList => this.baseList;
    public override SyntaxToken? OpenBraceToken => this.openBraceToken;
    /// <summary>Gets the members declaration list.</summary>
    public CoreSyntax.SeparatedSyntaxList<EnumMemberDeclarationSyntax> Members => new CoreSyntax.SeparatedSyntaxList<EnumMemberDeclarationSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.members));
    public override SyntaxToken? CloseBraceToken => this.closeBraceToken;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.enumKeyword,
            3 => this.identifier,
            4 => this.baseList,
            5 => this.openBraceToken,
            6 => this.members,
            7 => this.closeBraceToken,
            8 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.EnumDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEnumDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEnumDeclaration(this);

    public EnumDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken enumKeyword, SyntaxToken identifier, BaseListSyntax baseList, SyntaxToken openBraceToken, CoreSyntax.SeparatedSyntaxList<EnumMemberDeclarationSyntax> members, SyntaxToken closeBraceToken, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || enumKeyword != this.EnumKeyword || identifier != this.Identifier || baseList != this.BaseList || openBraceToken != this.OpenBraceToken || members != this.Members || closeBraceToken != this.CloseBraceToken || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EnumDeclaration(attributeLists, modifiers, enumKeyword, identifier, baseList, openBraceToken, members, closeBraceToken, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new EnumDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.enumKeyword, this.identifier, this.baseList, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new EnumDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.enumKeyword, this.identifier, this.baseList, this.openBraceToken, this.members, this.closeBraceToken, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Delegate declaration syntax.</summary>
internal sealed partial class DelegateDeclarationSyntax : MemberDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken delegateKeyword;
    internal readonly TypeSyntax returnType;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax parameterList;
    internal readonly GreenNode? constraintClauses;
    internal readonly SyntaxToken semicolonToken;

    internal DelegateDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal DelegateDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal DelegateDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(delegateKeyword);
        this.delegateKeyword = delegateKeyword;
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the "delegate" keyword.</summary>
    public SyntaxToken DelegateKeyword => this.delegateKeyword;
    /// <summary>Gets the return type.</summary>
    public TypeSyntax ReturnType => this.returnType;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    /// <summary>Gets the parameter list.</summary>
    public ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>Gets the constraint clause list.</summary>
    public CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    /// <summary>Gets the semicolon token.</summary>
    public SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.delegateKeyword,
            3 => this.returnType,
            4 => this.identifier,
            5 => this.typeParameterList,
            6 => this.parameterList,
            7 => this.constraintClauses,
            8 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DelegateDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDelegateDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDelegateDeclaration(this);

    public DelegateDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken delegateKeyword, TypeSyntax returnType, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || delegateKeyword != this.DelegateKeyword || returnType != this.ReturnType || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DelegateDeclaration(attributeLists, modifiers, delegateKeyword, returnType, identifier, typeParameterList, parameterList, constraintClauses, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DelegateDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.delegateKeyword, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DelegateDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.delegateKeyword, this.returnType, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class EnumMemberDeclarationSyntax : MemberDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken identifier;
    internal readonly EqualsValueClauseSyntax? equalsValue;

    internal EnumMemberDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken identifier, EqualsValueClauseSyntax? equalsValue, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (equalsValue != null)
        {
            this.AdjustFlagsAndWidth(equalsValue);
            this.equalsValue = equalsValue;
        }
    }

    internal EnumMemberDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken identifier, EqualsValueClauseSyntax? equalsValue, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (equalsValue != null)
        {
            this.AdjustFlagsAndWidth(equalsValue);
            this.equalsValue = equalsValue;
        }
    }

    internal EnumMemberDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken identifier, EqualsValueClauseSyntax? equalsValue)
      : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (equalsValue != null)
        {
            this.AdjustFlagsAndWidth(equalsValue);
            this.equalsValue = equalsValue;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public EqualsValueClauseSyntax? EqualsValue => this.equalsValue;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.identifier,
            3 => this.equalsValue,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.EnumMemberDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEnumMemberDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEnumMemberDeclaration(this);

    public EnumMemberDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken identifier, EqualsValueClauseSyntax equalsValue)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || identifier != this.Identifier || equalsValue != this.EqualsValue)
        {
            var newNode = SyntaxFactory.EnumMemberDeclaration(attributeLists, modifiers, identifier, equalsValue);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new EnumMemberDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.equalsValue, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new EnumMemberDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.equalsValue, GetDiagnostics(), annotations);
}

/// <summary>Base list syntax.</summary>
internal sealed partial class BaseListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken colonToken;
    internal readonly GreenNode? types;

    internal BaseListSyntax(SyntaxKind kind, SyntaxToken colonToken, GreenNode? types, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (types != null)
        {
            this.AdjustFlagsAndWidth(types);
            this.types = types;
        }
    }

    internal BaseListSyntax(SyntaxKind kind, SyntaxToken colonToken, GreenNode? types, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (types != null)
        {
            this.AdjustFlagsAndWidth(types);
            this.types = types;
        }
    }

    internal BaseListSyntax(SyntaxKind kind, SyntaxToken colonToken, GreenNode? types)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (types != null)
        {
            this.AdjustFlagsAndWidth(types);
            this.types = types;
        }
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>Gets the base type references.</summary>
    public CoreSyntax.SeparatedSyntaxList<BaseTypeSyntax> Types => new CoreSyntax.SeparatedSyntaxList<BaseTypeSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.types));

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.colonToken,
            1 => this.types,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BaseListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBaseList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBaseList(this);

    public BaseListSyntax Update(SyntaxToken colonToken, CoreSyntax.SeparatedSyntaxList<BaseTypeSyntax> types)
    {
        if (colonToken != this.ColonToken || types != this.Types)
        {
            var newNode = SyntaxFactory.BaseList(colonToken, types);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BaseListSyntax(this.Kind, this.colonToken, this.types, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BaseListSyntax(this.Kind, this.colonToken, this.types, GetDiagnostics(), annotations);
}

/// <summary>Provides the base class from which the classes that represent base type syntax nodes are derived. This is an abstract class.</summary>
internal abstract partial class BaseTypeSyntax : CSharpSyntaxNode
{
    internal BaseTypeSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseTypeSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract TypeSyntax Type { get; }
}

internal sealed partial class SimpleBaseTypeSyntax : BaseTypeSyntax
{
    internal readonly TypeSyntax type;

    internal SimpleBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal SimpleBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal SimpleBaseTypeSyntax(SyntaxKind kind, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    public override TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.type : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SimpleBaseTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSimpleBaseType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSimpleBaseType(this);

    public SimpleBaseTypeSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.SimpleBaseType(type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SimpleBaseTypeSyntax(this.Kind, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SimpleBaseTypeSyntax(this.Kind, this.type, GetDiagnostics(), annotations);
}

internal sealed partial class PrimaryConstructorBaseTypeSyntax : BaseTypeSyntax
{
    internal readonly TypeSyntax type;
    internal readonly ArgumentListSyntax argumentList;

    internal PrimaryConstructorBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, ArgumentListSyntax argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal PrimaryConstructorBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, ArgumentListSyntax argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal PrimaryConstructorBaseTypeSyntax(SyntaxKind kind, TypeSyntax type, ArgumentListSyntax argumentList)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    public override TypeSyntax Type => this.type;
    public ArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.type,
            1 => this.argumentList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PrimaryConstructorBaseTypeSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPrimaryConstructorBaseType(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPrimaryConstructorBaseType(this);

    public PrimaryConstructorBaseTypeSyntax Update(TypeSyntax type, ArgumentListSyntax argumentList)
    {
        if (type != this.Type || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.PrimaryConstructorBaseType(type, argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PrimaryConstructorBaseTypeSyntax(this.Kind, this.type, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PrimaryConstructorBaseTypeSyntax(this.Kind, this.type, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Type parameter constraint clause.</summary>
internal sealed partial class TypeParameterConstraintClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken whereKeyword;
    internal readonly IdentifierNameSyntax name;
    internal readonly SyntaxToken colonToken;
    internal readonly GreenNode? constraints;

    internal TypeParameterConstraintClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, GreenNode? constraints, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    internal TypeParameterConstraintClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, GreenNode? constraints, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    internal TypeParameterConstraintClauseSyntax(SyntaxKind kind, SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, GreenNode? constraints)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(whereKeyword);
        this.whereKeyword = whereKeyword;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    public SyntaxToken WhereKeyword => this.whereKeyword;
    /// <summary>Gets the identifier.</summary>
    public IdentifierNameSyntax Name => this.name;
    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>Gets the constraints list.</summary>
    public CoreSyntax.SeparatedSyntaxList<TypeParameterConstraintSyntax> Constraints => new CoreSyntax.SeparatedSyntaxList<TypeParameterConstraintSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.constraints));

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.whereKeyword,
            1 => this.name,
            2 => this.colonToken,
            3 => this.constraints,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeParameterConstraintClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeParameterConstraintClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeParameterConstraintClause(this);

    public TypeParameterConstraintClauseSyntax Update(SyntaxToken whereKeyword, IdentifierNameSyntax name, SyntaxToken colonToken, CoreSyntax.SeparatedSyntaxList<TypeParameterConstraintSyntax> constraints)
    {
        if (whereKeyword != this.WhereKeyword || name != this.Name || colonToken != this.ColonToken || constraints != this.Constraints)
        {
            var newNode = SyntaxFactory.TypeParameterConstraintClause(whereKeyword, name, colonToken, constraints);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeParameterConstraintClauseSyntax(this.Kind, this.whereKeyword, this.name, this.colonToken, this.constraints, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeParameterConstraintClauseSyntax(this.Kind, this.whereKeyword, this.name, this.colonToken, this.constraints, GetDiagnostics(), annotations);
}

/// <summary>Base type for type parameter constraint syntax.</summary>
internal abstract partial class TypeParameterConstraintSyntax : CSharpSyntaxNode
{
    internal TypeParameterConstraintSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal TypeParameterConstraintSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Constructor constraint syntax.</summary>
internal sealed partial class ConstructorConstraintSyntax : TypeParameterConstraintSyntax
{
    internal readonly SyntaxToken newKeyword;
    internal readonly SyntaxToken openParenToken;
    internal readonly SyntaxToken closeParenToken;

    internal ConstructorConstraintSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ConstructorConstraintSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ConstructorConstraintSyntax(SyntaxKind kind, SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(newKeyword);
        this.newKeyword = newKeyword;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>Gets the "new" keyword.</summary>
    public SyntaxToken NewKeyword => this.newKeyword;
    /// <summary>Gets the open paren keyword.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    /// <summary>Gets the close paren keyword.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.newKeyword,
            1 => this.openParenToken,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConstructorConstraintSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstructorConstraint(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstructorConstraint(this);

    public ConstructorConstraintSyntax Update(SyntaxToken newKeyword, SyntaxToken openParenToken, SyntaxToken closeParenToken)
    {
        if (newKeyword != this.NewKeyword || openParenToken != this.OpenParenToken || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ConstructorConstraint(newKeyword, openParenToken, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConstructorConstraintSyntax(this.Kind, this.newKeyword, this.openParenToken, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConstructorConstraintSyntax(this.Kind, this.newKeyword, this.openParenToken, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Class or struct constraint syntax.</summary>
internal sealed partial class ClassOrStructConstraintSyntax : TypeParameterConstraintSyntax
{
    internal readonly SyntaxToken classOrStructKeyword;
    internal readonly SyntaxToken? questionToken;

    internal ClassOrStructConstraintSyntax(SyntaxKind kind, SyntaxToken classOrStructKeyword, SyntaxToken? questionToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(classOrStructKeyword);
        this.classOrStructKeyword = classOrStructKeyword;
        if (questionToken != null)
        {
            this.AdjustFlagsAndWidth(questionToken);
            this.questionToken = questionToken;
        }
    }

    internal ClassOrStructConstraintSyntax(SyntaxKind kind, SyntaxToken classOrStructKeyword, SyntaxToken? questionToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(classOrStructKeyword);
        this.classOrStructKeyword = classOrStructKeyword;
        if (questionToken != null)
        {
            this.AdjustFlagsAndWidth(questionToken);
            this.questionToken = questionToken;
        }
    }

    internal ClassOrStructConstraintSyntax(SyntaxKind kind, SyntaxToken classOrStructKeyword, SyntaxToken? questionToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(classOrStructKeyword);
        this.classOrStructKeyword = classOrStructKeyword;
        if (questionToken != null)
        {
            this.AdjustFlagsAndWidth(questionToken);
            this.questionToken = questionToken;
        }
    }

    /// <summary>Gets the constraint keyword ("class" or "struct").</summary>
    public SyntaxToken ClassOrStructKeyword => this.classOrStructKeyword;
    /// <summary>SyntaxToken representing the question mark.</summary>
    public SyntaxToken? QuestionToken => this.questionToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.classOrStructKeyword,
            1 => this.questionToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ClassOrStructConstraintSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitClassOrStructConstraint(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitClassOrStructConstraint(this);

    public ClassOrStructConstraintSyntax Update(SyntaxToken classOrStructKeyword, SyntaxToken questionToken)
    {
        if (classOrStructKeyword != this.ClassOrStructKeyword || questionToken != this.QuestionToken)
        {
            var newNode = SyntaxFactory.ClassOrStructConstraint(this.Kind, classOrStructKeyword, questionToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ClassOrStructConstraintSyntax(this.Kind, this.classOrStructKeyword, this.questionToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ClassOrStructConstraintSyntax(this.Kind, this.classOrStructKeyword, this.questionToken, GetDiagnostics(), annotations);
}

/// <summary>Type constraint syntax.</summary>
internal sealed partial class TypeConstraintSyntax : TypeParameterConstraintSyntax
{
    internal readonly TypeSyntax type;

    internal TypeConstraintSyntax(SyntaxKind kind, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal TypeConstraintSyntax(SyntaxKind kind, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal TypeConstraintSyntax(SyntaxKind kind, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    /// <summary>Gets the type syntax.</summary>
    public TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.type : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeConstraintSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeConstraint(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeConstraint(this);

    public TypeConstraintSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.TypeConstraint(type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeConstraintSyntax(this.Kind, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeConstraintSyntax(this.Kind, this.type, GetDiagnostics(), annotations);
}

/// <summary>Default constraint syntax.</summary>
internal sealed partial class DefaultConstraintSyntax : TypeParameterConstraintSyntax
{
    internal readonly SyntaxToken defaultKeyword;

    internal DefaultConstraintSyntax(SyntaxKind kind, SyntaxToken defaultKeyword, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(defaultKeyword);
        this.defaultKeyword = defaultKeyword;
    }

    internal DefaultConstraintSyntax(SyntaxKind kind, SyntaxToken defaultKeyword, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(defaultKeyword);
        this.defaultKeyword = defaultKeyword;
    }

    internal DefaultConstraintSyntax(SyntaxKind kind, SyntaxToken defaultKeyword)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(defaultKeyword);
        this.defaultKeyword = defaultKeyword;
    }

    /// <summary>Gets the "default" keyword.</summary>
    public SyntaxToken DefaultKeyword => this.defaultKeyword;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.defaultKeyword : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DefaultConstraintSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDefaultConstraint(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDefaultConstraint(this);

    public DefaultConstraintSyntax Update(SyntaxToken defaultKeyword)
    {
        if (defaultKeyword != this.DefaultKeyword)
        {
            var newNode = SyntaxFactory.DefaultConstraint(defaultKeyword);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DefaultConstraintSyntax(this.Kind, this.defaultKeyword, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DefaultConstraintSyntax(this.Kind, this.defaultKeyword, GetDiagnostics(), annotations);
}

/// <summary>The allows type parameter constraint clause.</summary>
internal sealed partial class AllowsConstraintClauseSyntax : TypeParameterConstraintSyntax
{
    internal readonly SyntaxToken allowsKeyword;
    internal readonly GreenNode? constraints;

    internal AllowsConstraintClauseSyntax(SyntaxKind kind, SyntaxToken allowsKeyword, GreenNode? constraints, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(allowsKeyword);
        this.allowsKeyword = allowsKeyword;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    internal AllowsConstraintClauseSyntax(SyntaxKind kind, SyntaxToken allowsKeyword, GreenNode? constraints, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(allowsKeyword);
        this.allowsKeyword = allowsKeyword;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    internal AllowsConstraintClauseSyntax(SyntaxKind kind, SyntaxToken allowsKeyword, GreenNode? constraints)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(allowsKeyword);
        this.allowsKeyword = allowsKeyword;
        if (constraints != null)
        {
            this.AdjustFlagsAndWidth(constraints);
            this.constraints = constraints;
        }
    }

    public SyntaxToken AllowsKeyword => this.allowsKeyword;
    /// <summary>Gets the constraints list.</summary>
    public CoreSyntax.SeparatedSyntaxList<AllowsConstraintSyntax> Constraints => new CoreSyntax.SeparatedSyntaxList<AllowsConstraintSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.constraints));

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.allowsKeyword,
            1 => this.constraints,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AllowsConstraintClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAllowsConstraintClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAllowsConstraintClause(this);

    public AllowsConstraintClauseSyntax Update(SyntaxToken allowsKeyword, CoreSyntax.SeparatedSyntaxList<AllowsConstraintSyntax> constraints)
    {
        if (allowsKeyword != this.AllowsKeyword || constraints != this.Constraints)
        {
            var newNode = SyntaxFactory.AllowsConstraintClause(allowsKeyword, constraints);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AllowsConstraintClauseSyntax(this.Kind, this.allowsKeyword, this.constraints, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AllowsConstraintClauseSyntax(this.Kind, this.allowsKeyword, this.constraints, GetDiagnostics(), annotations);
}

/// <summary>Base type for allow constraint syntax.</summary>
internal abstract partial class AllowsConstraintSyntax : CSharpSyntaxNode
{
    internal AllowsConstraintSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal AllowsConstraintSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>Ref struct constraint syntax.</summary>
internal sealed partial class RefStructConstraintSyntax : AllowsConstraintSyntax
{
    internal readonly SyntaxToken refKeyword;
    internal readonly SyntaxToken structKeyword;

    internal RefStructConstraintSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken structKeyword, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(structKeyword);
        this.structKeyword = structKeyword;
    }

    internal RefStructConstraintSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken structKeyword, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(structKeyword);
        this.structKeyword = structKeyword;
    }

    internal RefStructConstraintSyntax(SyntaxKind kind, SyntaxToken refKeyword, SyntaxToken structKeyword)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(refKeyword);
        this.refKeyword = refKeyword;
        this.AdjustFlagsAndWidth(structKeyword);
        this.structKeyword = structKeyword;
    }

    /// <summary>Gets the "ref" keyword.</summary>
    public SyntaxToken RefKeyword => this.refKeyword;
    /// <summary>Gets the "struct" keyword.</summary>
    public SyntaxToken StructKeyword => this.structKeyword;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.refKeyword,
            1 => this.structKeyword,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.RefStructConstraintSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitRefStructConstraint(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitRefStructConstraint(this);

    public RefStructConstraintSyntax Update(SyntaxToken refKeyword, SyntaxToken structKeyword)
    {
        if (refKeyword != this.RefKeyword || structKeyword != this.StructKeyword)
        {
            var newNode = SyntaxFactory.RefStructConstraint(refKeyword, structKeyword);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new RefStructConstraintSyntax(this.Kind, this.refKeyword, this.structKeyword, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new RefStructConstraintSyntax(this.Kind, this.refKeyword, this.structKeyword, GetDiagnostics(), annotations);
}

internal abstract partial class BaseFieldDeclarationSyntax : MemberDeclarationSyntax
{
    internal BaseFieldDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseFieldDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    public abstract VariableDeclarationSyntax Declaration { get; }

    public abstract SyntaxToken SemicolonToken { get; }
}

internal sealed partial class FieldDeclarationSyntax : BaseFieldDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken semicolonToken;

    internal FieldDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal FieldDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal FieldDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 4;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override VariableDeclarationSyntax Declaration => this.declaration;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.declaration,
            3 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FieldDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFieldDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFieldDeclaration(this);

    public FieldDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.FieldDeclaration(attributeLists, modifiers, declaration, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.declaration, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.declaration, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class EventFieldDeclarationSyntax : BaseFieldDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken eventKeyword;
    internal readonly VariableDeclarationSyntax declaration;
    internal readonly SyntaxToken semicolonToken;

    internal EventFieldDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal EventFieldDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    internal EventFieldDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
      : base(kind)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(declaration);
        this.declaration = declaration;
        this.AdjustFlagsAndWidth(semicolonToken);
        this.semicolonToken = semicolonToken;
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public SyntaxToken EventKeyword => this.eventKeyword;
    public override VariableDeclarationSyntax Declaration => this.declaration;
    public override SyntaxToken SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.eventKeyword,
            3 => this.declaration,
            4 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.EventFieldDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEventFieldDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEventFieldDeclaration(this);

    public EventFieldDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken eventKeyword, VariableDeclarationSyntax declaration, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || eventKeyword != this.EventKeyword || declaration != this.Declaration || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EventFieldDeclaration(attributeLists, modifiers, eventKeyword, declaration, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new EventFieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.declaration, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new EventFieldDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.declaration, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class ExplicitInterfaceSpecifierSyntax : CSharpSyntaxNode
{
    internal readonly NameSyntax name;
    internal readonly SyntaxToken dotToken;

    internal ExplicitInterfaceSpecifierSyntax(SyntaxKind kind, NameSyntax name, SyntaxToken dotToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
    }

    internal ExplicitInterfaceSpecifierSyntax(SyntaxKind kind, NameSyntax name, SyntaxToken dotToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
    }

    internal ExplicitInterfaceSpecifierSyntax(SyntaxKind kind, NameSyntax name, SyntaxToken dotToken)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
    }

    public NameSyntax Name => this.name;
    public SyntaxToken DotToken => this.dotToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.name,
            1 => this.dotToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ExplicitInterfaceSpecifierSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitExplicitInterfaceSpecifier(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitExplicitInterfaceSpecifier(this);

    public ExplicitInterfaceSpecifierSyntax Update(NameSyntax name, SyntaxToken dotToken)
    {
        if (name != this.Name || dotToken != this.DotToken)
        {
            var newNode = SyntaxFactory.ExplicitInterfaceSpecifier(name, dotToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ExplicitInterfaceSpecifierSyntax(this.Kind, this.name, this.dotToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ExplicitInterfaceSpecifierSyntax(this.Kind, this.name, this.dotToken, GetDiagnostics(), annotations);
}

/// <summary>Base type for method declaration syntax.</summary>
internal abstract partial class BaseMethodDeclarationSyntax : MemberDeclarationSyntax
{
    internal BaseMethodDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseMethodDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the parameter list.</summary>
    public abstract ParameterListSyntax ParameterList { get; }

    public abstract BlockSyntax? Body { get; }

    public abstract ArrowExpressionClauseSyntax? ExpressionBody { get; }

    /// <summary>Gets the optional semicolon token.</summary>
    public abstract SyntaxToken? SemicolonToken { get; }
}

/// <summary>Method declaration syntax.</summary>
internal sealed partial class MethodDeclarationSyntax : BaseMethodDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax returnType;
    internal readonly ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier;
    internal readonly SyntaxToken identifier;
    internal readonly TypeParameterListSyntax? typeParameterList;
    internal readonly ParameterListSyntax parameterList;
    internal readonly GreenNode? constraintClauses;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal MethodDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal MethodDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal MethodDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax? typeParameterList, ParameterListSyntax parameterList, GreenNode? constraintClauses, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (typeParameterList != null)
        {
            this.AdjustFlagsAndWidth(typeParameterList);
            this.typeParameterList = typeParameterList;
        }
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (constraintClauses != null)
        {
            this.AdjustFlagsAndWidth(constraintClauses);
            this.constraintClauses = constraintClauses;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the return type syntax.</summary>
    public TypeSyntax ReturnType => this.returnType;
    public ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public TypeParameterListSyntax? TypeParameterList => this.typeParameterList;
    public override ParameterListSyntax ParameterList => this.parameterList;
    /// <summary>Gets the constraint clause list.</summary>
    public CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> ConstraintClauses => new CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax>(this.constraintClauses);
    public override BlockSyntax? Body => this.body;
    public override ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.returnType,
            3 => this.explicitInterfaceSpecifier,
            4 => this.identifier,
            5 => this.typeParameterList,
            6 => this.parameterList,
            7 => this.constraintClauses,
            8 => this.body,
            9 => this.expressionBody,
            10 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.MethodDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitMethodDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitMethodDeclaration(this);

    public MethodDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, TypeParameterListSyntax typeParameterList, ParameterListSyntax parameterList, CoreSyntax.SyntaxList<TypeParameterConstraintClauseSyntax> constraintClauses, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || typeParameterList != this.TypeParameterList || parameterList != this.ParameterList || constraintClauses != this.ConstraintClauses || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.MethodDeclaration(attributeLists, modifiers, returnType, explicitInterfaceSpecifier, identifier, typeParameterList, parameterList, constraintClauses, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new MethodDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.explicitInterfaceSpecifier, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new MethodDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.explicitInterfaceSpecifier, this.identifier, this.typeParameterList, this.parameterList, this.constraintClauses, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Operator declaration syntax.</summary>
internal sealed partial class OperatorDeclarationSyntax : BaseMethodDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax returnType;
    internal readonly ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier;
    internal readonly SyntaxToken operatorKeyword;
    internal readonly SyntaxToken? checkedKeyword;
    internal readonly SyntaxToken operatorToken;
    internal readonly ParameterListSyntax parameterList;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal OperatorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal OperatorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal OperatorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(returnType);
        this.returnType = returnType;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the return type.</summary>
    public TypeSyntax ReturnType => this.returnType;
    public ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the "operator" keyword.</summary>
    public SyntaxToken OperatorKeyword => this.operatorKeyword;
    /// <summary>Gets the "checked" keyword.</summary>
    public SyntaxToken? CheckedKeyword => this.checkedKeyword;
    /// <summary>Gets the operator token.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public override BlockSyntax? Body => this.body;
    public override ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.returnType,
            3 => this.explicitInterfaceSpecifier,
            4 => this.operatorKeyword,
            5 => this.checkedKeyword,
            6 => this.operatorToken,
            7 => this.parameterList,
            8 => this.body,
            9 => this.expressionBody,
            10 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.OperatorDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOperatorDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOperatorDeclaration(this);

    public OperatorDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax returnType, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken checkedKeyword, SyntaxToken operatorToken, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || returnType != this.ReturnType || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || operatorKeyword != this.OperatorKeyword || checkedKeyword != this.CheckedKeyword || operatorToken != this.OperatorToken || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.OperatorDeclaration(attributeLists, modifiers, returnType, explicitInterfaceSpecifier, operatorKeyword, checkedKeyword, operatorToken, parameterList, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new OperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.explicitInterfaceSpecifier, this.operatorKeyword, this.checkedKeyword, this.operatorToken, this.parameterList, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new OperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.returnType, this.explicitInterfaceSpecifier, this.operatorKeyword, this.checkedKeyword, this.operatorToken, this.parameterList, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Conversion operator declaration syntax.</summary>
internal sealed partial class ConversionOperatorDeclarationSyntax : BaseMethodDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken implicitOrExplicitKeyword;
    internal readonly ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier;
    internal readonly SyntaxToken operatorKeyword;
    internal readonly SyntaxToken? checkedKeyword;
    internal readonly TypeSyntax type;
    internal readonly ParameterListSyntax parameterList;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal ConversionOperatorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken implicitOrExplicitKeyword, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal ConversionOperatorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken implicitOrExplicitKeyword, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal ConversionOperatorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken implicitOrExplicitKeyword, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 11;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the "implicit" or "explicit" token.</summary>
    public SyntaxToken ImplicitOrExplicitKeyword => this.implicitOrExplicitKeyword;
    public ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the "operator" token.</summary>
    public SyntaxToken OperatorKeyword => this.operatorKeyword;
    /// <summary>Gets the "checked" keyword.</summary>
    public SyntaxToken? CheckedKeyword => this.checkedKeyword;
    /// <summary>Gets the type.</summary>
    public TypeSyntax Type => this.type;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public override BlockSyntax? Body => this.body;
    public override ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.implicitOrExplicitKeyword,
            3 => this.explicitInterfaceSpecifier,
            4 => this.operatorKeyword,
            5 => this.checkedKeyword,
            6 => this.type,
            7 => this.parameterList,
            8 => this.body,
            9 => this.expressionBody,
            10 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConversionOperatorDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConversionOperatorDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConversionOperatorDeclaration(this);

    public ConversionOperatorDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken implicitOrExplicitKeyword, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken operatorKeyword, SyntaxToken checkedKeyword, TypeSyntax type, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || implicitOrExplicitKeyword != this.ImplicitOrExplicitKeyword || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || operatorKeyword != this.OperatorKeyword || checkedKeyword != this.CheckedKeyword || type != this.Type || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ConversionOperatorDeclaration(attributeLists, modifiers, implicitOrExplicitKeyword, explicitInterfaceSpecifier, operatorKeyword, checkedKeyword, type, parameterList, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConversionOperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.implicitOrExplicitKeyword, this.explicitInterfaceSpecifier, this.operatorKeyword, this.checkedKeyword, this.type, this.parameterList, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConversionOperatorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.implicitOrExplicitKeyword, this.explicitInterfaceSpecifier, this.operatorKeyword, this.checkedKeyword, this.type, this.parameterList, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Constructor declaration syntax.</summary>
internal sealed partial class ConstructorDeclarationSyntax : BaseMethodDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken identifier;
    internal readonly ParameterListSyntax parameterList;
    internal readonly ConstructorInitializerSyntax? initializer;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal ConstructorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax? initializer, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal ConstructorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax? initializer, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal ConstructorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax? initializer, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public ConstructorInitializerSyntax? Initializer => this.initializer;
    public override BlockSyntax? Body => this.body;
    public override ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.identifier,
            3 => this.parameterList,
            4 => this.initializer,
            5 => this.body,
            6 => this.expressionBody,
            7 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConstructorDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstructorDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstructorDeclaration(this);

    public ConstructorDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken identifier, ParameterListSyntax parameterList, ConstructorInitializerSyntax initializer, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || identifier != this.Identifier || parameterList != this.ParameterList || initializer != this.Initializer || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.ConstructorDeclaration(attributeLists, modifiers, identifier, parameterList, initializer, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConstructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.parameterList, this.initializer, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConstructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.identifier, this.parameterList, this.initializer, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Constructor initializer syntax.</summary>
internal sealed partial class ConstructorInitializerSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken colonToken;
    internal readonly SyntaxToken thisOrBaseKeyword;
    internal readonly ArgumentListSyntax argumentList;

    internal ConstructorInitializerSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(thisOrBaseKeyword);
        this.thisOrBaseKeyword = thisOrBaseKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ConstructorInitializerSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(thisOrBaseKeyword);
        this.thisOrBaseKeyword = thisOrBaseKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    internal ConstructorInitializerSyntax(SyntaxKind kind, SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(colonToken);
        this.colonToken = colonToken;
        this.AdjustFlagsAndWidth(thisOrBaseKeyword);
        this.thisOrBaseKeyword = thisOrBaseKeyword;
        this.AdjustFlagsAndWidth(argumentList);
        this.argumentList = argumentList;
    }

    /// <summary>Gets the colon token.</summary>
    public SyntaxToken ColonToken => this.colonToken;
    /// <summary>Gets the "this" or "base" keyword.</summary>
    public SyntaxToken ThisOrBaseKeyword => this.thisOrBaseKeyword;
    public ArgumentListSyntax ArgumentList => this.argumentList;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.colonToken,
            1 => this.thisOrBaseKeyword,
            2 => this.argumentList,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConstructorInitializerSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConstructorInitializer(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConstructorInitializer(this);

    public ConstructorInitializerSyntax Update(SyntaxToken colonToken, SyntaxToken thisOrBaseKeyword, ArgumentListSyntax argumentList)
    {
        if (colonToken != this.ColonToken || thisOrBaseKeyword != this.ThisOrBaseKeyword || argumentList != this.ArgumentList)
        {
            var newNode = SyntaxFactory.ConstructorInitializer(this.Kind, colonToken, thisOrBaseKeyword, argumentList);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConstructorInitializerSyntax(this.Kind, this.colonToken, this.thisOrBaseKeyword, this.argumentList, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConstructorInitializerSyntax(this.Kind, this.colonToken, this.thisOrBaseKeyword, this.argumentList, GetDiagnostics(), annotations);
}

/// <summary>Destructor declaration syntax.</summary>
internal sealed partial class DestructorDeclarationSyntax : BaseMethodDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken tildeToken;
    internal readonly SyntaxToken identifier;
    internal readonly ParameterListSyntax parameterList;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal DestructorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(tildeToken);
        this.tildeToken = tildeToken;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal DestructorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(tildeToken);
        this.tildeToken = tildeToken;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal DestructorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(tildeToken);
        this.tildeToken = tildeToken;
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the tilde token.</summary>
    public SyntaxToken TildeToken => this.tildeToken;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override ParameterListSyntax ParameterList => this.parameterList;
    public override BlockSyntax? Body => this.body;
    public override ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public override SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.tildeToken,
            3 => this.identifier,
            4 => this.parameterList,
            5 => this.body,
            6 => this.expressionBody,
            7 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DestructorDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDestructorDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDestructorDeclaration(this);

    public DestructorDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken tildeToken, SyntaxToken identifier, ParameterListSyntax parameterList, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || tildeToken != this.TildeToken || identifier != this.Identifier || parameterList != this.ParameterList || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.DestructorDeclaration(attributeLists, modifiers, tildeToken, identifier, parameterList, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DestructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.tildeToken, this.identifier, this.parameterList, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DestructorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.tildeToken, this.identifier, this.parameterList, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Base type for property declaration syntax.</summary>
internal abstract partial class BasePropertyDeclarationSyntax : MemberDeclarationSyntax
{
    internal BasePropertyDeclarationSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BasePropertyDeclarationSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the type syntax.</summary>
    public abstract TypeSyntax Type { get; }

    /// <summary>Gets the optional explicit interface specifier.</summary>
    public abstract ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier { get; }

    public abstract AccessorListSyntax? AccessorList { get; }
}

internal sealed partial class PropertyDeclarationSyntax : BasePropertyDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax type;
    internal readonly ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier;
    internal readonly SyntaxToken identifier;
    internal readonly AccessorListSyntax? accessorList;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly EqualsValueClauseSyntax? initializer;
    internal readonly SyntaxToken? semicolonToken;

    internal PropertyDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax? accessorList, ArrowExpressionClauseSyntax? expressionBody, EqualsValueClauseSyntax? initializer, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal PropertyDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax? accessorList, ArrowExpressionClauseSyntax? expressionBody, EqualsValueClauseSyntax? initializer, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal PropertyDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax? accessorList, ArrowExpressionClauseSyntax? expressionBody, EqualsValueClauseSyntax? initializer, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (initializer != null)
        {
            this.AdjustFlagsAndWidth(initializer);
            this.initializer = initializer;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override TypeSyntax Type => this.type;
    public override ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override AccessorListSyntax? AccessorList => this.accessorList;
    public ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    public EqualsValueClauseSyntax? Initializer => this.initializer;
    public SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.type,
            3 => this.explicitInterfaceSpecifier,
            4 => this.identifier,
            5 => this.accessorList,
            6 => this.expressionBody,
            7 => this.initializer,
            8 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.PropertyDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitPropertyDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitPropertyDeclaration(this);

    public PropertyDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, EqualsValueClauseSyntax initializer, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || accessorList != this.AccessorList || expressionBody != this.ExpressionBody || initializer != this.Initializer || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.PropertyDeclaration(attributeLists, modifiers, type, explicitInterfaceSpecifier, identifier, accessorList, expressionBody, initializer, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new PropertyDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.explicitInterfaceSpecifier, this.identifier, this.accessorList, this.expressionBody, this.initializer, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new PropertyDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.explicitInterfaceSpecifier, this.identifier, this.accessorList, this.expressionBody, this.initializer, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>The syntax for the expression body of an expression-bodied member.</summary>
internal sealed partial class ArrowExpressionClauseSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken arrowToken;
    internal readonly ExpressionSyntax expression;

    internal ArrowExpressionClauseSyntax(SyntaxKind kind, SyntaxToken arrowToken, ExpressionSyntax expression, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ArrowExpressionClauseSyntax(SyntaxKind kind, SyntaxToken arrowToken, ExpressionSyntax expression, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    internal ArrowExpressionClauseSyntax(SyntaxKind kind, SyntaxToken arrowToken, ExpressionSyntax expression)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(arrowToken);
        this.arrowToken = arrowToken;
        this.AdjustFlagsAndWidth(expression);
        this.expression = expression;
    }

    public SyntaxToken ArrowToken => this.arrowToken;
    public ExpressionSyntax Expression => this.expression;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.arrowToken,
            1 => this.expression,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ArrowExpressionClauseSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitArrowExpressionClause(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitArrowExpressionClause(this);

    public ArrowExpressionClauseSyntax Update(SyntaxToken arrowToken, ExpressionSyntax expression)
    {
        if (arrowToken != this.ArrowToken || expression != this.Expression)
        {
            var newNode = SyntaxFactory.ArrowExpressionClause(arrowToken, expression);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ArrowExpressionClauseSyntax(this.Kind, this.arrowToken, this.expression, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ArrowExpressionClauseSyntax(this.Kind, this.arrowToken, this.expression, GetDiagnostics(), annotations);
}

internal sealed partial class EventDeclarationSyntax : BasePropertyDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken eventKeyword;
    internal readonly TypeSyntax type;
    internal readonly ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier;
    internal readonly SyntaxToken identifier;
    internal readonly AccessorListSyntax? accessorList;
    internal readonly SyntaxToken? semicolonToken;

    internal EventDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax? accessorList, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal EventDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax? accessorList, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal EventDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax? accessorList, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 8;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(eventKeyword);
        this.eventKeyword = eventKeyword;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public SyntaxToken EventKeyword => this.eventKeyword;
    public override TypeSyntax Type => this.type;
    public override ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public override AccessorListSyntax? AccessorList => this.accessorList;
    public SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.eventKeyword,
            3 => this.type,
            4 => this.explicitInterfaceSpecifier,
            5 => this.identifier,
            6 => this.accessorList,
            7 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.EventDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitEventDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitEventDeclaration(this);

    public EventDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken eventKeyword, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken identifier, AccessorListSyntax accessorList, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || eventKeyword != this.EventKeyword || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || identifier != this.Identifier || accessorList != this.AccessorList || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.EventDeclaration(attributeLists, modifiers, eventKeyword, type, explicitInterfaceSpecifier, identifier, accessorList, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new EventDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.type, this.explicitInterfaceSpecifier, this.identifier, this.accessorList, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new EventDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.eventKeyword, this.type, this.explicitInterfaceSpecifier, this.identifier, this.accessorList, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class IndexerDeclarationSyntax : BasePropertyDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax type;
    internal readonly ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier;
    internal readonly SyntaxToken thisKeyword;
    internal readonly BracketedParameterListSyntax parameterList;
    internal readonly AccessorListSyntax? accessorList;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal IndexerDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken thisKeyword, BracketedParameterListSyntax parameterList, AccessorListSyntax? accessorList, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(thisKeyword);
        this.thisKeyword = thisKeyword;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal IndexerDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken thisKeyword, BracketedParameterListSyntax parameterList, AccessorListSyntax? accessorList, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(thisKeyword);
        this.thisKeyword = thisKeyword;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal IndexerDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax? explicitInterfaceSpecifier, SyntaxToken thisKeyword, BracketedParameterListSyntax parameterList, AccessorListSyntax? accessorList, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 9;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (explicitInterfaceSpecifier != null)
        {
            this.AdjustFlagsAndWidth(explicitInterfaceSpecifier);
            this.explicitInterfaceSpecifier = explicitInterfaceSpecifier;
        }
        this.AdjustFlagsAndWidth(thisKeyword);
        this.thisKeyword = thisKeyword;
        this.AdjustFlagsAndWidth(parameterList);
        this.parameterList = parameterList;
        if (accessorList != null)
        {
            this.AdjustFlagsAndWidth(accessorList);
            this.accessorList = accessorList;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override TypeSyntax Type => this.type;
    public override ExplicitInterfaceSpecifierSyntax? ExplicitInterfaceSpecifier => this.explicitInterfaceSpecifier;
    public SyntaxToken ThisKeyword => this.thisKeyword;
    /// <summary>Gets the parameter list.</summary>
    public BracketedParameterListSyntax ParameterList => this.parameterList;
    public override AccessorListSyntax? AccessorList => this.accessorList;
    public ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    public SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.type,
            3 => this.explicitInterfaceSpecifier,
            4 => this.thisKeyword,
            5 => this.parameterList,
            6 => this.accessorList,
            7 => this.expressionBody,
            8 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.IndexerDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIndexerDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIndexerDeclaration(this);

    public IndexerDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax type, ExplicitInterfaceSpecifierSyntax explicitInterfaceSpecifier, SyntaxToken thisKeyword, BracketedParameterListSyntax parameterList, AccessorListSyntax accessorList, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || explicitInterfaceSpecifier != this.ExplicitInterfaceSpecifier || thisKeyword != this.ThisKeyword || parameterList != this.ParameterList || accessorList != this.AccessorList || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.IndexerDeclaration(attributeLists, modifiers, type, explicitInterfaceSpecifier, thisKeyword, parameterList, accessorList, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new IndexerDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.explicitInterfaceSpecifier, this.thisKeyword, this.parameterList, this.accessorList, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new IndexerDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.explicitInterfaceSpecifier, this.thisKeyword, this.parameterList, this.accessorList, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

internal sealed partial class AccessorListSyntax : CSharpSyntaxNode
{
    internal readonly SyntaxToken openBraceToken;
    internal readonly GreenNode? accessors;
    internal readonly SyntaxToken closeBraceToken;

    internal AccessorListSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? accessors, SyntaxToken closeBraceToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (accessors != null)
        {
            this.AdjustFlagsAndWidth(accessors);
            this.accessors = accessors;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal AccessorListSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? accessors, SyntaxToken closeBraceToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (accessors != null)
        {
            this.AdjustFlagsAndWidth(accessors);
            this.accessors = accessors;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    internal AccessorListSyntax(SyntaxKind kind, SyntaxToken openBraceToken, GreenNode? accessors, SyntaxToken closeBraceToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBraceToken);
        this.openBraceToken = openBraceToken;
        if (accessors != null)
        {
            this.AdjustFlagsAndWidth(accessors);
            this.accessors = accessors;
        }
        this.AdjustFlagsAndWidth(closeBraceToken);
        this.closeBraceToken = closeBraceToken;
    }

    public SyntaxToken OpenBraceToken => this.openBraceToken;
    public CoreSyntax.SyntaxList<AccessorDeclarationSyntax> Accessors => new CoreSyntax.SyntaxList<AccessorDeclarationSyntax>(this.accessors);
    public SyntaxToken CloseBraceToken => this.closeBraceToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBraceToken,
            1 => this.accessors,
            2 => this.closeBraceToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AccessorListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAccessorList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAccessorList(this);

    public AccessorListSyntax Update(SyntaxToken openBraceToken, CoreSyntax.SyntaxList<AccessorDeclarationSyntax> accessors, SyntaxToken closeBraceToken)
    {
        if (openBraceToken != this.OpenBraceToken || accessors != this.Accessors || closeBraceToken != this.CloseBraceToken)
        {
            var newNode = SyntaxFactory.AccessorList(openBraceToken, accessors, closeBraceToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AccessorListSyntax(this.Kind, this.openBraceToken, this.accessors, this.closeBraceToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AccessorListSyntax(this.Kind, this.openBraceToken, this.accessors, this.closeBraceToken, GetDiagnostics(), annotations);
}

internal sealed partial class AccessorDeclarationSyntax : CSharpSyntaxNode
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly SyntaxToken keyword;
    internal readonly BlockSyntax? body;
    internal readonly ArrowExpressionClauseSyntax? expressionBody;
    internal readonly SyntaxToken? semicolonToken;

    internal AccessorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal AccessorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    internal AccessorDeclarationSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, SyntaxToken keyword, BlockSyntax? body, ArrowExpressionClauseSyntax? expressionBody, SyntaxToken? semicolonToken)
      : base(kind)
    {
        this.SlotCount = 6;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(keyword);
        this.keyword = keyword;
        if (body != null)
        {
            this.AdjustFlagsAndWidth(body);
            this.body = body;
        }
        if (expressionBody != null)
        {
            this.AdjustFlagsAndWidth(expressionBody);
            this.expressionBody = expressionBody;
        }
        if (semicolonToken != null)
        {
            this.AdjustFlagsAndWidth(semicolonToken);
            this.semicolonToken = semicolonToken;
        }
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>Gets the modifier list.</summary>
    public CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    /// <summary>Gets the keyword token, or identifier if an erroneous accessor declaration.</summary>
    public SyntaxToken Keyword => this.keyword;
    /// <summary>Gets the optional body block which may be empty, but it is null if there are no braces.</summary>
    public BlockSyntax? Body => this.body;
    /// <summary>Gets the optional expression body.</summary>
    public ArrowExpressionClauseSyntax? ExpressionBody => this.expressionBody;
    /// <summary>Gets the optional semicolon token.</summary>
    public SyntaxToken? SemicolonToken => this.semicolonToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.keyword,
            3 => this.body,
            4 => this.expressionBody,
            5 => this.semicolonToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.AccessorDeclarationSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitAccessorDeclaration(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitAccessorDeclaration(this);

    public AccessorDeclarationSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, SyntaxToken keyword, BlockSyntax body, ArrowExpressionClauseSyntax expressionBody, SyntaxToken semicolonToken)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || keyword != this.Keyword || body != this.Body || expressionBody != this.ExpressionBody || semicolonToken != this.SemicolonToken)
        {
            var newNode = SyntaxFactory.AccessorDeclaration(this.Kind, attributeLists, modifiers, keyword, body, expressionBody, semicolonToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new AccessorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.body, this.expressionBody, this.semicolonToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new AccessorDeclarationSyntax(this.Kind, this.attributeLists, this.modifiers, this.keyword, this.body, this.expressionBody, this.semicolonToken, GetDiagnostics(), annotations);
}

/// <summary>Base type for parameter list syntax.</summary>
internal abstract partial class BaseParameterListSyntax : CSharpSyntaxNode
{
    internal BaseParameterListSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseParameterListSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the parameter list.</summary>
    public abstract CoreSyntax.SeparatedSyntaxList<ParameterSyntax> Parameters { get; }
}

/// <summary>Parameter list syntax.</summary>
internal sealed partial class ParameterListSyntax : BaseParameterListSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? parameters;
    internal readonly SyntaxToken closeParenToken;

    internal ParameterListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? parameters, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParameterListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? parameters, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal ParameterListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? parameters, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    public override CoreSyntax.SeparatedSyntaxList<ParameterSyntax> Parameters => new CoreSyntax.SeparatedSyntaxList<ParameterSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.parameters));
    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.parameters,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ParameterListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParameterList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParameterList(this);

    public ParameterListSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<ParameterSyntax> parameters, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || parameters != this.Parameters || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.ParameterList(openParenToken, parameters, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ParameterListSyntax(this.Kind, this.openParenToken, this.parameters, this.closeParenToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ParameterListSyntax(this.Kind, this.openParenToken, this.parameters, this.closeParenToken, GetDiagnostics(), annotations);
}

/// <summary>Parameter list syntax with surrounding brackets.</summary>
internal sealed partial class BracketedParameterListSyntax : BaseParameterListSyntax
{
    internal readonly SyntaxToken openBracketToken;
    internal readonly GreenNode? parameters;
    internal readonly SyntaxToken closeBracketToken;

    internal BracketedParameterListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? parameters, SyntaxToken closeBracketToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal BracketedParameterListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? parameters, SyntaxToken closeBracketToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    internal BracketedParameterListSyntax(SyntaxKind kind, SyntaxToken openBracketToken, GreenNode? parameters, SyntaxToken closeBracketToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openBracketToken);
        this.openBracketToken = openBracketToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeBracketToken);
        this.closeBracketToken = closeBracketToken;
    }

    /// <summary>Gets the open bracket token.</summary>
    public SyntaxToken OpenBracketToken => this.openBracketToken;
    public override CoreSyntax.SeparatedSyntaxList<ParameterSyntax> Parameters => new CoreSyntax.SeparatedSyntaxList<ParameterSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.parameters));
    /// <summary>Gets the close bracket token.</summary>
    public SyntaxToken CloseBracketToken => this.closeBracketToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openBracketToken,
            1 => this.parameters,
            2 => this.closeBracketToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.BracketedParameterListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitBracketedParameterList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitBracketedParameterList(this);

    public BracketedParameterListSyntax Update(SyntaxToken openBracketToken, CoreSyntax.SeparatedSyntaxList<ParameterSyntax> parameters, SyntaxToken closeBracketToken)
    {
        if (openBracketToken != this.OpenBracketToken || parameters != this.Parameters || closeBracketToken != this.CloseBracketToken)
        {
            var newNode = SyntaxFactory.BracketedParameterList(openBracketToken, parameters, closeBracketToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new BracketedParameterListSyntax(this.Kind, this.openBracketToken, this.parameters, this.closeBracketToken, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new BracketedParameterListSyntax(this.Kind, this.openBracketToken, this.parameters, this.closeBracketToken, GetDiagnostics(), annotations);
}

/// <summary>Base parameter syntax.</summary>
internal abstract partial class BaseParameterSyntax : CSharpSyntaxNode
{
    internal BaseParameterSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseParameterSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public abstract CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists { get; }

    /// <summary>Gets the modifier list.</summary>
    public abstract CoreSyntax.SyntaxList<SyntaxToken> Modifiers { get; }

    public abstract TypeSyntax? Type { get; }
}

/// <summary>Parameter syntax.</summary>
internal sealed partial class ParameterSyntax : BaseParameterSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax? type;
    internal readonly SyntaxToken identifier;
    internal readonly EqualsValueClauseSyntax? @default;

    internal ParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? type, SyntaxToken identifier, EqualsValueClauseSyntax? @default, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (@default != null)
        {
            this.AdjustFlagsAndWidth(@default);
            this.@default = @default;
        }
    }

    internal ParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? type, SyntaxToken identifier, EqualsValueClauseSyntax? @default, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (@default != null)
        {
            this.AdjustFlagsAndWidth(@default);
            this.@default = @default;
        }
    }

    internal ParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? type, SyntaxToken identifier, EqualsValueClauseSyntax? @default)
      : base(kind)
    {
        this.SlotCount = 5;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
        this.AdjustFlagsAndWidth(identifier);
        this.identifier = identifier;
        if (@default != null)
        {
            this.AdjustFlagsAndWidth(@default);
            this.@default = @default;
        }
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>Gets the modifier list.</summary>
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override TypeSyntax? Type => this.type;
    /// <summary>Gets the identifier.</summary>
    public SyntaxToken Identifier => this.identifier;
    public EqualsValueClauseSyntax? Default => this.@default;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.type,
            3 => this.identifier,
            4 => this.@default,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ParameterSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitParameter(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitParameter(this);

    public ParameterSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax type, SyntaxToken identifier, EqualsValueClauseSyntax @default)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type || identifier != this.Identifier || @default != this.Default)
        {
            var newNode = SyntaxFactory.Parameter(attributeLists, modifiers, type, identifier, @default);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ParameterSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.identifier, this.@default, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ParameterSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, this.identifier, this.@default, GetDiagnostics(), annotations);
}

/// <summary>Parameter syntax.</summary>
internal sealed partial class FunctionPointerParameterSyntax : BaseParameterSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax type;

    internal FunctionPointerParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal FunctionPointerParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal FunctionPointerParameterSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    /// <summary>Gets the attribute declaration list.</summary>
    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    /// <summary>Gets the modifier list.</summary>
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public override TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.type,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.FunctionPointerParameterSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitFunctionPointerParameter(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitFunctionPointerParameter(this);

    public FunctionPointerParameterSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax type)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type)
        {
            var newNode = SyntaxFactory.FunctionPointerParameter(attributeLists, modifiers, type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new FunctionPointerParameterSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new FunctionPointerParameterSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, GetDiagnostics(), annotations);
}

internal sealed partial class IncompleteMemberSyntax : MemberDeclarationSyntax
{
    internal readonly GreenNode? attributeLists;
    internal readonly GreenNode? modifiers;
    internal readonly TypeSyntax? type;

    internal IncompleteMemberSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
    }

    internal IncompleteMemberSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
    }

    internal IncompleteMemberSyntax(SyntaxKind kind, GreenNode? attributeLists, GreenNode? modifiers, TypeSyntax? type)
      : base(kind)
    {
        this.SlotCount = 3;
        if (attributeLists != null)
        {
            this.AdjustFlagsAndWidth(attributeLists);
            this.attributeLists = attributeLists;
        }
        if (modifiers != null)
        {
            this.AdjustFlagsAndWidth(modifiers);
            this.modifiers = modifiers;
        }
        if (type != null)
        {
            this.AdjustFlagsAndWidth(type);
            this.type = type;
        }
    }

    public override CoreSyntax.SyntaxList<AttributeListSyntax> AttributeLists => new CoreSyntax.SyntaxList<AttributeListSyntax>(this.attributeLists);
    public override CoreSyntax.SyntaxList<SyntaxToken> Modifiers => new CoreSyntax.SyntaxList<SyntaxToken>(this.modifiers);
    public TypeSyntax? Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.attributeLists,
            1 => this.modifiers,
            2 => this.type,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.IncompleteMemberSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIncompleteMember(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIncompleteMember(this);

    public IncompleteMemberSyntax Update(CoreSyntax.SyntaxList<AttributeListSyntax> attributeLists, CoreSyntax.SyntaxList<SyntaxToken> modifiers, TypeSyntax type)
    {
        if (attributeLists != this.AttributeLists || modifiers != this.Modifiers || type != this.Type)
        {
            var newNode = SyntaxFactory.IncompleteMember(attributeLists, modifiers, type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new IncompleteMemberSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new IncompleteMemberSyntax(this.Kind, this.attributeLists, this.modifiers, this.type, GetDiagnostics(), annotations);
}

internal sealed partial class SkippedTokensTriviaSyntax : StructuredTriviaSyntax
{
    internal readonly GreenNode? tokens;

    internal SkippedTokensTriviaSyntax(SyntaxKind kind, GreenNode? tokens, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        if (tokens != null)
        {
            this.AdjustFlagsAndWidth(tokens);
            this.tokens = tokens;
        }
    }

    internal SkippedTokensTriviaSyntax(SyntaxKind kind, GreenNode? tokens, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        if (tokens != null)
        {
            this.AdjustFlagsAndWidth(tokens);
            this.tokens = tokens;
        }
    }

    internal SkippedTokensTriviaSyntax(SyntaxKind kind, GreenNode? tokens)
      : base(kind)
    {
        this.SlotCount = 1;
        if (tokens != null)
        {
            this.AdjustFlagsAndWidth(tokens);
            this.tokens = tokens;
        }
    }

    public CoreSyntax.SyntaxList<SyntaxToken> Tokens => new CoreSyntax.SyntaxList<SyntaxToken>(this.tokens);

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.tokens : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.SkippedTokensTriviaSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitSkippedTokensTrivia(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitSkippedTokensTrivia(this);

    public SkippedTokensTriviaSyntax Update(CoreSyntax.SyntaxList<SyntaxToken> tokens)
    {
        if (tokens != this.Tokens)
        {
            var newNode = SyntaxFactory.SkippedTokensTrivia(tokens);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new SkippedTokensTriviaSyntax(this.Kind, this.tokens, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new SkippedTokensTriviaSyntax(this.Kind, this.tokens, GetDiagnostics(), annotations);
}

internal sealed partial class DocumentationCommentTriviaSyntax : StructuredTriviaSyntax
{
    internal readonly GreenNode? content;
    internal readonly SyntaxToken endOfComment;

    internal DocumentationCommentTriviaSyntax(SyntaxKind kind, GreenNode? content, SyntaxToken endOfComment, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        if (content != null)
        {
            this.AdjustFlagsAndWidth(content);
            this.content = content;
        }
        this.AdjustFlagsAndWidth(endOfComment);
        this.endOfComment = endOfComment;
    }

    internal DocumentationCommentTriviaSyntax(SyntaxKind kind, GreenNode? content, SyntaxToken endOfComment, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        if (content != null)
        {
            this.AdjustFlagsAndWidth(content);
            this.content = content;
        }
        this.AdjustFlagsAndWidth(endOfComment);
        this.endOfComment = endOfComment;
    }

    internal DocumentationCommentTriviaSyntax(SyntaxKind kind, GreenNode? content, SyntaxToken endOfComment)
      : base(kind)
    {
        this.SlotCount = 2;
        if (content != null)
        {
            this.AdjustFlagsAndWidth(content);
            this.content = content;
        }
        this.AdjustFlagsAndWidth(endOfComment);
        this.endOfComment = endOfComment;
    }

    public CoreSyntax.SyntaxList<XmlNodeSyntax> Content => new CoreSyntax.SyntaxList<XmlNodeSyntax>(this.content);
    public SyntaxToken EndOfComment => this.endOfComment;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.content,
            1 => this.endOfComment,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.DocumentationCommentTriviaSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitDocumentationCommentTrivia(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitDocumentationCommentTrivia(this);

    public DocumentationCommentTriviaSyntax Update(CoreSyntax.SyntaxList<XmlNodeSyntax> content, SyntaxToken endOfComment)
    {
        if (content != this.Content || endOfComment != this.EndOfComment)
        {
            var newNode = SyntaxFactory.DocumentationCommentTrivia(this.Kind, content, endOfComment);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new DocumentationCommentTriviaSyntax(this.Kind, this.content, this.endOfComment, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new DocumentationCommentTriviaSyntax(this.Kind, this.content, this.endOfComment, GetDiagnostics(), annotations);
}

/// <summary>
/// A symbol referenced by a cref attribute (e.g. in a &lt;see&gt; or &lt;seealso&gt; documentation comment tag).
/// For example, the M in &lt;see cref="M" /&gt;.
/// </summary>
internal abstract partial class CrefSyntax : CSharpSyntaxNode
{
    internal CrefSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal CrefSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>
/// A symbol reference that definitely refers to a type.
/// For example, "int", "A::B", "A.B", "A&lt;T&gt;", but not "M()" (has parameter list) or "this" (indexer).
/// NOTE: TypeCrefSyntax, QualifiedCrefSyntax, and MemberCrefSyntax overlap.  The syntax in a TypeCrefSyntax
/// will always be bound as type, so it's safer to use QualifiedCrefSyntax or MemberCrefSyntax if the symbol
/// might be a non-type member.
/// </summary>
internal sealed partial class TypeCrefSyntax : CrefSyntax
{
    internal readonly TypeSyntax type;

    internal TypeCrefSyntax(SyntaxKind kind, TypeSyntax type, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal TypeCrefSyntax(SyntaxKind kind, TypeSyntax type, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    internal TypeCrefSyntax(SyntaxKind kind, TypeSyntax type)
      : base(kind)
    {
        this.SlotCount = 1;
        this.AdjustFlagsAndWidth(type);
        this.type = type;
    }

    public TypeSyntax Type => this.type;

    internal override GreenNode? GetSlot(int index)
        => index == 0 ? this.type : null;

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.TypeCrefSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitTypeCref(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitTypeCref(this);

    public TypeCrefSyntax Update(TypeSyntax type)
    {
        if (type != this.Type)
        {
            var newNode = SyntaxFactory.TypeCref(type);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new TypeCrefSyntax(this.Kind, this.type, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new TypeCrefSyntax(this.Kind, this.type, GetDiagnostics(), annotations);
}

/// <summary>
/// A symbol reference to a type or non-type member that is qualified by an enclosing type or namespace.
/// For example, cref="System.String.ToString()".
/// NOTE: TypeCrefSyntax, QualifiedCrefSyntax, and MemberCrefSyntax overlap.  The syntax in a TypeCrefSyntax
/// will always be bound as type, so it's safer to use QualifiedCrefSyntax or MemberCrefSyntax if the symbol
/// might be a non-type member.
/// </summary>
internal sealed partial class QualifiedCrefSyntax : CrefSyntax
{
    internal readonly TypeSyntax container;
    internal readonly SyntaxToken dotToken;
    internal readonly MemberCrefSyntax member;

    internal QualifiedCrefSyntax(SyntaxKind kind, TypeSyntax container, SyntaxToken dotToken, MemberCrefSyntax member, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(container);
        this.container = container;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(member);
        this.member = member;
    }

    internal QualifiedCrefSyntax(SyntaxKind kind, TypeSyntax container, SyntaxToken dotToken, MemberCrefSyntax member, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(container);
        this.container = container;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(member);
        this.member = member;
    }

    internal QualifiedCrefSyntax(SyntaxKind kind, TypeSyntax container, SyntaxToken dotToken, MemberCrefSyntax member)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(container);
        this.container = container;
        this.AdjustFlagsAndWidth(dotToken);
        this.dotToken = dotToken;
        this.AdjustFlagsAndWidth(member);
        this.member = member;
    }

    public TypeSyntax Container => this.container;
    public SyntaxToken DotToken => this.dotToken;
    public MemberCrefSyntax Member => this.member;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.container,
            1 => this.dotToken,
            2 => this.member,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.QualifiedCrefSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitQualifiedCref(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitQualifiedCref(this);

    public QualifiedCrefSyntax Update(TypeSyntax container, SyntaxToken dotToken, MemberCrefSyntax member)
    {
        if (container != this.Container || dotToken != this.DotToken || member != this.Member)
        {
            var newNode = SyntaxFactory.QualifiedCref(container, dotToken, member);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new QualifiedCrefSyntax(this.Kind, this.container, this.dotToken, this.member, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new QualifiedCrefSyntax(this.Kind, this.container, this.dotToken, this.member, GetDiagnostics(), annotations);
}

/// <summary>
/// The unqualified part of a CrefSyntax.
/// For example, "ToString()" in "object.ToString()".
/// NOTE: TypeCrefSyntax, QualifiedCrefSyntax, and MemberCrefSyntax overlap.  The syntax in a TypeCrefSyntax
/// will always be bound as type, so it's safer to use QualifiedCrefSyntax or MemberCrefSyntax if the symbol
/// might be a non-type member.
/// </summary>
internal abstract partial class MemberCrefSyntax : CrefSyntax
{
    internal MemberCrefSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal MemberCrefSyntax(SyntaxKind kind)
      : base(kind)
    {
    }
}

/// <summary>
/// A MemberCrefSyntax specified by a name (an identifier, predefined type keyword, or an alias-qualified name,
/// with an optional type parameter list) and an optional parameter list.
/// For example, "M", "M&lt;T&gt;" or "M(int)".
/// Also, "A::B()" or "string()".
/// </summary>
internal sealed partial class NameMemberCrefSyntax : MemberCrefSyntax
{
    internal readonly TypeSyntax name;
    internal readonly CrefParameterListSyntax? parameters;

    internal NameMemberCrefSyntax(SyntaxKind kind, TypeSyntax name, CrefParameterListSyntax? parameters, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal NameMemberCrefSyntax(SyntaxKind kind, TypeSyntax name, CrefParameterListSyntax? parameters, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal NameMemberCrefSyntax(SyntaxKind kind, TypeSyntax name, CrefParameterListSyntax? parameters)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(name);
        this.name = name;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    public TypeSyntax Name => this.name;
    public CrefParameterListSyntax? Parameters => this.parameters;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.name,
            1 => this.parameters,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.NameMemberCrefSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitNameMemberCref(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitNameMemberCref(this);

    public NameMemberCrefSyntax Update(TypeSyntax name, CrefParameterListSyntax parameters)
    {
        if (name != this.Name || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.NameMemberCref(name, parameters);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new NameMemberCrefSyntax(this.Kind, this.name, this.parameters, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new NameMemberCrefSyntax(this.Kind, this.name, this.parameters, GetDiagnostics(), annotations);
}

/// <summary>
/// A MemberCrefSyntax specified by a this keyword and an optional parameter list.
/// For example, "this" or "this[int]".
/// </summary>
internal sealed partial class IndexerMemberCrefSyntax : MemberCrefSyntax
{
    internal readonly SyntaxToken thisKeyword;
    internal readonly CrefBracketedParameterListSyntax? parameters;

    internal IndexerMemberCrefSyntax(SyntaxKind kind, SyntaxToken thisKeyword, CrefBracketedParameterListSyntax? parameters, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(thisKeyword);
        this.thisKeyword = thisKeyword;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal IndexerMemberCrefSyntax(SyntaxKind kind, SyntaxToken thisKeyword, CrefBracketedParameterListSyntax? parameters, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(thisKeyword);
        this.thisKeyword = thisKeyword;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal IndexerMemberCrefSyntax(SyntaxKind kind, SyntaxToken thisKeyword, CrefBracketedParameterListSyntax? parameters)
      : base(kind)
    {
        this.SlotCount = 2;
        this.AdjustFlagsAndWidth(thisKeyword);
        this.thisKeyword = thisKeyword;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    public SyntaxToken ThisKeyword => this.thisKeyword;
    public CrefBracketedParameterListSyntax? Parameters => this.parameters;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.thisKeyword,
            1 => this.parameters,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.IndexerMemberCrefSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitIndexerMemberCref(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitIndexerMemberCref(this);

    public IndexerMemberCrefSyntax Update(SyntaxToken thisKeyword, CrefBracketedParameterListSyntax parameters)
    {
        if (thisKeyword != this.ThisKeyword || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.IndexerMemberCref(thisKeyword, parameters);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new IndexerMemberCrefSyntax(this.Kind, this.thisKeyword, this.parameters, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new IndexerMemberCrefSyntax(this.Kind, this.thisKeyword, this.parameters, GetDiagnostics(), annotations);
}

/// <summary>
/// A MemberCrefSyntax specified by an operator keyword, an operator symbol and an optional parameter list.
/// For example, "operator +" or "operator -[int]".
/// NOTE: the operator must be overloadable.
/// </summary>
internal sealed partial class OperatorMemberCrefSyntax : MemberCrefSyntax
{
    internal readonly SyntaxToken operatorKeyword;
    internal readonly SyntaxToken? checkedKeyword;
    internal readonly SyntaxToken operatorToken;
    internal readonly CrefParameterListSyntax? parameters;

    internal OperatorMemberCrefSyntax(SyntaxKind kind, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, SyntaxToken operatorToken, CrefParameterListSyntax? parameters, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal OperatorMemberCrefSyntax(SyntaxKind kind, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, SyntaxToken operatorToken, CrefParameterListSyntax? parameters, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal OperatorMemberCrefSyntax(SyntaxKind kind, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, SyntaxToken operatorToken, CrefParameterListSyntax? parameters)
      : base(kind)
    {
        this.SlotCount = 4;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(operatorToken);
        this.operatorToken = operatorToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    public SyntaxToken OperatorKeyword => this.operatorKeyword;
    public SyntaxToken? CheckedKeyword => this.checkedKeyword;
    /// <summary>Gets the operator token.</summary>
    public SyntaxToken OperatorToken => this.operatorToken;
    public CrefParameterListSyntax? Parameters => this.parameters;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.operatorKeyword,
            1 => this.checkedKeyword,
            2 => this.operatorToken,
            3 => this.parameters,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.OperatorMemberCrefSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitOperatorMemberCref(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitOperatorMemberCref(this);

    public OperatorMemberCrefSyntax Update(SyntaxToken operatorKeyword, SyntaxToken checkedKeyword, SyntaxToken operatorToken, CrefParameterListSyntax parameters)
    {
        if (operatorKeyword != this.OperatorKeyword || checkedKeyword != this.CheckedKeyword || operatorToken != this.OperatorToken || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.OperatorMemberCref(operatorKeyword, checkedKeyword, operatorToken, parameters);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new OperatorMemberCrefSyntax(this.Kind, this.operatorKeyword, this.checkedKeyword, this.operatorToken, this.parameters, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new OperatorMemberCrefSyntax(this.Kind, this.operatorKeyword, this.checkedKeyword, this.operatorToken, this.parameters, GetDiagnostics(), annotations);
}

/// <summary>
/// A MemberCrefSyntax specified by an implicit or explicit keyword, an operator keyword, a destination type, and an optional parameter list.
/// For example, "implicit operator int" or "explicit operator MyType(int)".
/// </summary>
internal sealed partial class ConversionOperatorMemberCrefSyntax : MemberCrefSyntax
{
    internal readonly SyntaxToken implicitOrExplicitKeyword;
    internal readonly SyntaxToken operatorKeyword;
    internal readonly SyntaxToken? checkedKeyword;
    internal readonly TypeSyntax type;
    internal readonly CrefParameterListSyntax? parameters;

    internal ConversionOperatorMemberCrefSyntax(SyntaxKind kind, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, TypeSyntax type, CrefParameterListSyntax? parameters, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal ConversionOperatorMemberCrefSyntax(SyntaxKind kind, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, TypeSyntax type, CrefParameterListSyntax? parameters, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    internal ConversionOperatorMemberCrefSyntax(SyntaxKind kind, SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, SyntaxToken? checkedKeyword, TypeSyntax type, CrefParameterListSyntax? parameters)
      : base(kind)
    {
        this.SlotCount = 5;
        this.AdjustFlagsAndWidth(implicitOrExplicitKeyword);
        this.implicitOrExplicitKeyword = implicitOrExplicitKeyword;
        this.AdjustFlagsAndWidth(operatorKeyword);
        this.operatorKeyword = operatorKeyword;
        if (checkedKeyword != null)
        {
            this.AdjustFlagsAndWidth(checkedKeyword);
            this.checkedKeyword = checkedKeyword;
        }
        this.AdjustFlagsAndWidth(type);
        this.type = type;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
    }

    public SyntaxToken ImplicitOrExplicitKeyword => this.implicitOrExplicitKeyword;
    public SyntaxToken OperatorKeyword => this.operatorKeyword;
    public SyntaxToken? CheckedKeyword => this.checkedKeyword;
    public TypeSyntax Type => this.type;
    public CrefParameterListSyntax? Parameters => this.parameters;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.implicitOrExplicitKeyword,
            1 => this.operatorKeyword,
            2 => this.checkedKeyword,
            3 => this.type,
            4 => this.parameters,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.ConversionOperatorMemberCrefSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitConversionOperatorMemberCref(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitConversionOperatorMemberCref(this);

    public ConversionOperatorMemberCrefSyntax Update(SyntaxToken implicitOrExplicitKeyword, SyntaxToken operatorKeyword, SyntaxToken checkedKeyword, TypeSyntax type, CrefParameterListSyntax parameters)
    {
        if (implicitOrExplicitKeyword != this.ImplicitOrExplicitKeyword || operatorKeyword != this.OperatorKeyword || checkedKeyword != this.CheckedKeyword || type != this.Type || parameters != this.Parameters)
        {
            var newNode = SyntaxFactory.ConversionOperatorMemberCref(implicitOrExplicitKeyword, operatorKeyword, checkedKeyword, type, parameters);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new ConversionOperatorMemberCrefSyntax(this.Kind, this.implicitOrExplicitKeyword, this.operatorKeyword, this.checkedKeyword, this.type, this.parameters, diagnostics, GetAnnotations());

    internal override GreenNode SetAnnotations(SyntaxAnnotation[]? annotations)
        => new ConversionOperatorMemberCrefSyntax(this.Kind, this.implicitOrExplicitKeyword, this.operatorKeyword, this.checkedKeyword, this.type, this.parameters, GetDiagnostics(), annotations);
}

/// <summary>
/// A list of cref parameters with surrounding punctuation.
/// Unlike regular parameters, cref parameters do not have names.
/// </summary>
internal abstract partial class BaseCrefParameterListSyntax : CSharpSyntaxNode
{
    internal BaseCrefParameterListSyntax(SyntaxKind kind, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
    }

    internal BaseCrefParameterListSyntax(SyntaxKind kind)
      : base(kind)
    {
    }

    /// <summary>Gets the parameter list.</summary>
    public abstract CoreSyntax.SeparatedSyntaxList<CrefParameterSyntax> Parameters { get; }
}

/// <summary>
/// A parenthesized list of cref parameters.
/// </summary>
internal sealed partial class CrefParameterListSyntax : BaseCrefParameterListSyntax
{
    internal readonly SyntaxToken openParenToken;
    internal readonly GreenNode? parameters;
    internal readonly SyntaxToken closeParenToken;

    internal CrefParameterListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? parameters, SyntaxToken closeParenToken, DiagnosticInfo[]? diagnostics, SyntaxAnnotation[]? annotations)
      : base(kind, diagnostics, annotations)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CrefParameterListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? parameters, SyntaxToken closeParenToken, SyntaxFactoryContext context)
      : base(kind)
    {
        this.SetFactoryContext(context);
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    internal CrefParameterListSyntax(SyntaxKind kind, SyntaxToken openParenToken, GreenNode? parameters, SyntaxToken closeParenToken)
      : base(kind)
    {
        this.SlotCount = 3;
        this.AdjustFlagsAndWidth(openParenToken);
        this.openParenToken = openParenToken;
        if (parameters != null)
        {
            this.AdjustFlagsAndWidth(parameters);
            this.parameters = parameters;
        }
        this.AdjustFlagsAndWidth(closeParenToken);
        this.closeParenToken = closeParenToken;
    }

    /// <summary>Gets the open paren token.</summary>
    public SyntaxToken OpenParenToken => this.openParenToken;
    public override CoreSyntax.SeparatedSyntaxList<CrefParameterSyntax> Parameters => new CoreSyntax.SeparatedSyntaxList<CrefParameterSyntax>(new CoreSyntax.SyntaxList<CSharpSyntaxNode>(this.parameters));
    /// <summary>Gets the close paren token.</summary>
    public SyntaxToken CloseParenToken => this.closeParenToken;

    internal override GreenNode? GetSlot(int index)
        => index switch
        {
            0 => this.openParenToken,
            1 => this.parameters,
            2 => this.closeParenToken,
            _ => null,
        };

    internal override SyntaxNode CreateRed(SyntaxNode? parent, int position) => new CSharp.Syntax.CrefParameterListSyntax(this, parent, position);

    public override void Accept(CSharpSyntaxVisitor visitor) => visitor.VisitCrefParameterList(this);
    public override TResult Accept<TResult>(CSharpSyntaxVisitor<TResult> visitor) => visitor.VisitCrefParameterList(this);

    public CrefParameterListSyntax Update(SyntaxToken openParenToken, CoreSyntax.SeparatedSyntaxList<CrefParameterSyntax> parameters, SyntaxToken closeParenToken)
    {
        if (openParenToken != this.OpenParenToken || parameters != this.Parameters || closeParenToken != this.CloseParenToken)
        {
            var newNode = SyntaxFactory.CrefParameterList(openParenToken, parameters, closeParenToken);
            var diags = GetDiagnostics();
            if (diags?.Length > 0)
                newNode = newNode.WithDiagnosticsGreen(diags);
            var annotations = GetAnnotations();
            if (annotations?.Length > 0)
                newNode = newNode.WithAnnotationsGreen(annotations);
            return newNode;
        }

        return this;
    }

    internal override GreenNode SetDiagnostics(DiagnosticInfo[]? diagnostics)
        => new CrefParameterListSyntax(this.Kind, this.openParenToken, this.parameters, this.closeParenToken, diagnostics, GetAnnotations());

    internal override Gre