/*
 * (C) Copyright 2014- ECMWF.
 * 
 * This software is licensed under the terms of the Apache Licence Version 2.0
 * which can be obtained at http://www.apache.org/licenses/LICENSE-2.0.
 * In applying this licence, ECMWF does not waive the privileges and immunities
 * granted to it by virtue of its status as an intergovernmental organisation
 * nor does it submit to any jurisdiction.
 */

#include <sys/time.h>

#include "transi_test.h"

// -----------------------------------------------------------------------------
// IMPLEMENTATIONS

int test_use_mpi() {
    if ( getenv( "TRANS_USE_MPI" ) ) { return atoi( getenv( "TRANS_USE_MPI" ) ); }
    return 1;
}

int transi_test_nprgpew() {
    if ( getenv( "TRANS_NPRGPEW" ) ) { return atoi( getenv( "TRANS_NPRGPEW" ) ); }
    return 1;
}

double transi_test_time()
{
  static double time_init = -1;
  double time_in_secs;
  struct timeval tbuf;
  if (gettimeofday(&tbuf,NULL) == -1) perror("transi_test_time");
  if (time_init == -1) time_init = 
    (double) tbuf.tv_sec + (tbuf.tv_usec / 1000000.0);
  time_in_secs = 
  (double) tbuf.tv_sec + (tbuf.tv_usec / 1000000.0) - time_init;
  return time_in_secs;
}

void print_time(const char* str,double elapsed)
{
  int msec = elapsed * 1000;
  printf("%s%d seconds %d milliseconds\n",str, msec/1000, msec%1000);
}

#ifdef TRANSI_HAVE_MEMORY
#include <malloc.h>
#endif

void display_mallinfo(void)
{
#ifdef TRANSI_HAVE_MEMORY
  struct mallinfo mi;

    mi = mallinfo();

    printf("Total non-mmapped bytes (arena):       %d\n", mi.arena);
    printf("# of free chunks (ordblks):            %d\n", mi.ordblks);
    printf("# of free fastbin blocks (smblks):     %d\n", mi.smblks);
    printf("# of mapped regions (hblks):           %d\n", mi.hblks);
    printf("Bytes in mapped regions (hblkhd):      %d\n", mi.hblkhd);
    printf("Max. total allocated space (usmblks):  %d\n", mi.usmblks);
    printf("Free bytes held in fastbins (fsmblks): %d\n", mi.fsmblks);
    printf("Total allocated space (uordblks):      %d\n", mi.uordblks);
    printf("Total free space (fordblks):           %d\n", mi.fordblks);
    printf("Topmost releasable block (keepcost):   %d\n", mi.keepcost);
#endif
}

int allocated()
{
#ifdef TRANSI_HAVE_MEMORY
  struct mallinfo mi;
  mi = mallinfo();
  return mi.hblkhd + mi.uordblks;
#else
  return 0;
#endif
}

void print_mem(const char* str,const int bytes)
{
#ifdef TRANSI_HAVE_MEMORY
  float B, KB, MB;
  B = bytes;
  KB = B/1024.;
  MB = KB/1024.;
  if( MB > 0.1 )
    printf("%s%f MB\n",str,MB);
  else
    printf("%s%f KB\n",str,KB);
#endif
}


void set_standard_rgg(struct Trans_t* trans, int N, int T)
{
  if( N==48 ) // TL95
  {
    int nloen[] = {20,25,36,40,45,50,60,60,72,75,80,90,96,100,108,120,120,120,128,135,144,144,160,160,160,160,160,180,180,180,180,180,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,192,180,180,180,180,180,160,160,160,160,160,144,144,135,128,120,120,120,108,100,96,90,80,75,72,60,60,50,45,40,36,25,20};
    trans_set_resol(trans,sizeof(nloen)/sizeof(int),nloen);
    if( T<0 )
      trans_set_trunc(trans,95);
    else
      trans_set_trunc(trans,T);
    return;
  }

  if( N==80 ) // TL159
  {
    int nloen[] = {18,25,36,40,45,54,60,64,72,72,80,90,96,100,108,120,120,128,135,144,144,150,160,160,180,180,180,192,192,200,200,216,216,216,225,225,240,240,240,256,256,256,256,288,288,288,288,288,288,288,288,288,300,300,300,300,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,320,300,300,300,300,288,288,288,288,288,288,288,288,288,256,256,256,256,240,240,240,225,225,216,216,216,200,200,192,192,180,180,180,160,160,150,144,144,135,128,120,120,108,100,96,90,80,72,72,64,60,54,45,40,36,25,18};
    trans_set_resol(trans,sizeof(nloen)/sizeof(int),nloen);
    if( T<0 )
      trans_set_trunc(trans,159);
    else
      trans_set_trunc(trans,T);
    return;
  }

  if( N==128 ) // TL255
  {
    int nloen[] =  {18,25,36,40,45,50,60,64,72,72,80,90,90,100,108,120,120,125,128,144,144,150,160,160,180,180,180,192,192,200,216,216,216,225,240,240,240,250,250,256,270,270,288,288,288,300,300,320,320,320,320,324,360,360,360,360,360,360,360,375,375,375,375,384,384,400,400,400,400,405,432,432,432,432,432,432,432,450,450,450,450,450,480,480,480,480,480,480,480,480,480,480,486,486,486,500,500,500,500,500,500,500,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,512,500,500,500,500,500,500,500,486,486,486,480,480,480,480,480,480,480,480,480,480,450,450,450,450,450,432,432,432,432,432,432,432,405,400,400,400,400,384,384,375,375,375,375,360,360,360,360,360,360,360,324,320,320,320,320,300,300,288,288,288,270,270,256,250,250,240,240,240,225,216,216,216,200,192,192,180,180,180,160,160,150,144,144,128,125,120,120,108,100,90,90,80,72,72,64,60,50,45,40,36,25,18};
    trans_set_resol(trans,sizeof(nloen)/sizeof(int),nloen);
    if( T<0 )
      trans_set_trunc(trans,255);
    else
      trans_set_trunc(trans,T);
    return;
  }

  if( N==256 ) // TL511
  {
    int nloen[] =  {18,25,32,40,45,50,60,64,72,72,75,81,90,96,100,108,120,120,125,135,144,150,160,160,180,180,180,192,192,200,216,216,216,225,240,240,243,250,256,270,270,288,288,288,300,300,320,320,320,324,360,360,360,360,360,360,375,375,384,384,400,400,400,432,432,432,432,432,450,450,450,480,480,480,480,480,486,500,500,500,512,512,540,540,540,540,540,576,576,576,576,576,576,600,600,600,600,600,640,640,640,640,640,640,640,640,648,675,675,675,675,675,675,720,720,720,720,720,720,720,720,720,729,729,750,750,750,750,750,768,768,768,768,800,800,800,800,800,800,800,800,810,810,864,864,864,864,864,864,864,864,864,864,864,864,864,864,900,900,900,900,900,900,900,900,900,900,900,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,972,972,972,972,972,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1024,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,1000,972,972,972,972,972,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,960,900,900,900,900,900,900,900,900,900,900,900,864,864,864,864,864,864,864,864,864,864,864,864,864,864,810,810,800,800,800,800,800,800,800,800,768,768,768,768,750,750,750,750,750,729,729,720,720,720,720,720,720,720,720,720,675,675,675,675,675,675,648,640,640,640,640,640,640,640,640,600,600,600,600,600,576,576,576,576,576,576,540,540,540,540,540,512,512,500,500,500,486,480,480,480,480,480,450,450,450,432,432,432,432,432,400,400,400,384,384,375,375,360,360,360,360,360,360,324,320,320,320,300,300,288,288,288,270,270,256,250,243,240,240,225,216,216,216,200,192,192,180,180,180,160,160,150,144,135,125,120,120,108,100,96,90,81,75,72,72,64,60,50,45,40,32,25,18};
    trans_set_resol(trans,sizeof(nloen)/sizeof(int),nloen);
    if( T<0 )
      trans_set_trunc(trans,511);
    else
      trans_set_trunc(trans,T);
    return;
  }

  if( N==640 ) // TL1279
  {
    int nloen[] = {18,25,32,40,45,50,60,60,72,72,75,81,90,90,96,100,108,120,120,125,135,144,150,160,160,180,180,180,192,192,200,216,216,216,225,240,240,243,250,256,270,270,288,288,288,300,300,320,320,320,360,360,360,360,360,360,375,375,384,384,400,400,400,432,432,432,432,450,450,450,480,480,480,480,480,486,500,500,512,512,540,540,540,540,540,576,576,576,576,576,600,600,600,600,640,640,640,640,640,640,640,648,675,675,675,675,720,720,720,720,720,720,720,720,729,750,750,750,750,768,768,768,800,800,800,800,800,810,810,864,864,864,864,864,864,864,864,900,900,900,900,900,900,960,960,960,960,960,960,960,960,960,960,960,972,972,1000,1000,1000,1000,1000,1024,1024,1024,1024,1080,1080,1080,1080,1080,1080,1080,1080,1080,1125,1125,1125,1125,1125,1125,1125,1125,1152,1152,1152,1152,1152,1200,1200,1200,1200,1200,1200,1200,1200,1215,1215,1215,1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1296,1296,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1458,1458,1458,1458,1500,1500,1500,1500,1500,1500,1500,1500,1536,1536,1536,1536,1536,1536,1536,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1620,1620,1620,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1920,1920,1920,1920,1920,1920,1920,1920,1920,1920,1920,1944,1944,1944,1944,1944,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2025,2025,2025,2025,2025,2025,2048,2048,2048,2048,2048,2048,2048,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2187,2187,2187,2187,2187,2187,2187,2187,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2430,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2187,2187,2187,2187,2187,2187,2187,2187,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2048,2048,2048,2048,2048,2048,2048,2025,2025,2025,2025,2025,2025,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,1944,1944,1944,1944,1944,1920,1920,1920,1920,1920,1920,1920,1920,1920,1920,1920,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1620,1620,1620,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1536,1536,1536,1536,1536,1536,1536,1500,1500,1500,1500,1500,1500,1500,1500,1458,1458,1458,1458,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1350,1350,1350,1350,1350,1350,1350,1350,1350,1350,1296,1296,1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1280,1215,1215,1215,1200,1200,1200,1200,1200,1200,1200,1200,1152,1152,1152,1152,1152,1125,1125,1125,1125,1125,1125,1125,1125,1080,1080,1080,1080,1080,1080,1080,1080,1080,1024,1024,1024,1024,1000,1000,1000,1000,1000,972,972,960,960,960,960,960,960,960,960,960,960,960,900,900,900,900,900,900,864,864,864,864,864,864,864,864,810,810,800,800,800,800,800,768,768,768,750,750,750,750,729,720,720,720,720,720,720,720,720,675,675,675,675,648,640,640,640,640,640,640,640,600,600,600,600,576,576,576,576,576,540,540,540,540,540,512,512,500,500,486,480,480,480,480,480,450,450,450,432,432,432,432,400,400,400,384,384,375,375,360,360,360,360,360,360,320,320,320,300,300,288,288,288,270,270,256,250,243,240,240,225,216,216,216,200,192,192,180,180,180,160,160,150,144,135,125,120,120,108,100,96,90,90,81,75,72,72,60,60,50,45,40,32,25,18};
    trans_set_resol(trans,sizeof(nloen)/sizeof(int),nloen);
    if( T<0 )
      trans_set_trunc(trans,1279);
    else
      trans_set_trunc(trans,T);
    return;
  }

  if( N==1024 ) // TL2047
  {
    int nloen[] = {18,25,32,40,45,50,60,64,72,72,75,81,90,96,96,108,108,120,120,125,125,135,144,150,160,160,180,180,180,192,192,200,216,216,225,225,240,240,243,250,256,270,270,288,288,288,300,300,320,320,320,360,360,360,360,360,360,375,375,384,384,400,400,405,432,432,432,432,450,450,450,480,480,480,480,480,486,500,500,512,512,540,540,540,540,576,576,576,576,576,576,600,600,600,600,625,625,625,625,640,640,648,675,675,675,675,675,720,720,720,720,720,720,720,729,750,750,750,750,768,768,800,800,800,800,800,800,810,864,864,864,864,864,864,864,864,864,900,900,900,900,900,900,960,960,960,960,960,960,960,960,960,972,972,1000,1000,1000,1000,1000,1024,1024,1024,1024,1080,1080,1080,1080,1080,1080,1080,1080,1080,1125,1125,1125,1125,1125,1125,1125,1152,1152,1152,1152,1152,1200,1200,1200,1200,1200,1200,1200,1215,1215,1215,1250,1250,1250,1250,1250,1250,1280,1280,1280,1280,1280,1296,1296,1350,1350,1350,1350,1350,1350,1350,1350,1350,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1458,1458,1458,1500,1500,1500,1500,1500,1500,1500,1500,1536,1536,1536,1536,1536,1536,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1620,1620,1620,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1920,1920,1920,1920,1920,1920,1920,1920,1944,1944,1944,1944,1944,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,2025,2025,2025,2025,2048,2048,2048,2048,2048,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2187,2187,2187,2187,2187,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2430,2430,2430,2430,2430,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2592,2592,2592,2592,2592,2592,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2916,2916,2916,2916,2916,2916,2916,2916,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3240,3240,3240,3240,3240,3240,3240,3240,3240,3240,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4096,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4050,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,4000,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3888,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3840,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3750,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3645,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3600,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3456,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3375,3240,3240,3240,3240,3240,3240,3240,3240,3240,3240,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3200,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3125,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3072,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,3000,2916,2916,2916,2916,2916,2916,2916,2916,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2880,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2700,2592,2592,2592,2592,2592,2592,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2560,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2500,2430,2430,2430,2430,2430,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2400,2304,2304,2304,2304,2304,2304,2304,2304,2304,2304,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2250,2187,2187,2187,2187,2187,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2160,2048,2048,2048,2048,2048,2025,2025,2025,2025,2000,2000,2000,2000,2000,2000,2000,2000,2000,2000,1944,1944,1944,1944,1944,1920,1920,1920,1920,1920,1920,1920,1920,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1875,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1800,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1728,1620,1620,1620,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1600,1536,1536,1536,1536,1536,1536,1500,1500,1500,1500,1500,1500,1500,1500,1458,1458,1458,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1440,1350,1350,1350,1350,1350,1350,1350,1350,1350,1296,1296,1280,1280,1280,1280,1280,1250,1250,1250,1250,1250,1250,1215,1215,1215,1200,1200,1200,1200,1200,1200,1200,1152,1152,1152,1152,1152,1125,1125,1125,1125,1125,1125,1125,1080,1080,1080,1080,1080,1080,1080,1080,1080,1024,1024,1024,1024,1000,1000,1000,1000,1000,972,972,960,960,960,960,960,960,960,960,960,900,900,900,900,900,900,864,864,864,864,864,864,864,864,864,810,800,800,800,800,800,800,768,768,750,750,750,750,729,720,720,720,720,720,720,720,675,675,675,675,675,648,640,640,625,625,625,625,600,600,600,600,576,576,576,576,576,576,540,540,540,540,512,512,500,500,486,480,480,480,480,480,450,450,450,432,432,432,432,405,400,400,384,384,375,375,360,360,360,360,360,360,320,320,320,300,300,288,288,288,270,270,256,250,243,240,240,225,225,216,216,200,192,192,180,180,180,160,160,150,144,135,125,125,120,120,108,108,96,96,90,81,75,72,72,64,60,50,45,40,32,25,18};
    trans_set_resol(trans,sizeof(nloen)/sizeof(int),nloen);
    if( T<0 )
      trans_set_trunc(trans,2047);
    else
      trans_set_trunc(trans,T);
    return;
  }
}
